/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.px;

import com.tridium.sys.schema.ComponentSlotMap;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.HashMap;
import javax.baja.file.BIFile;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComplex;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.BLayerStatus;
import javax.baja.ui.px.BPxInclude;
import javax.baja.ui.px.PxLayer;
import javax.baja.ui.px.PxProperty;
import javax.baja.util.BTypeSpec;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PxDecoder
extends XParser {
    private String[] modules;
    private PxProperty[] props;
    private PxLayer[] layers;
    private HashMap types;
    private BOrd baseOrd;
    private TypeInfo media;
    private Context cx;

    public BWidget decodeDocument() throws Exception {
        return this.decodeDocument(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BWidget decodeDocument(boolean close) throws Exception {
        BWidget bWidget;
        block7: {
            try {
                XElem root = this.parse();
                if (!root.name().equals("px")) {
                    throw this.err("Root element must be \"px\"", root);
                }
                String ver = root.get("version");
                if (!ver.equals("1.0")) {
                    throw this.err("Only version 1.0 is supported", root);
                }
                String media = root.get("media", null);
                if (media != null) {
                    try {
                        this.media = Sys.getRegistry().getType(media);
                    }
                    catch (TypeNotFoundException e) {
                        this.warning("Media not found: " + media, root);
                    }
                }
                this.decodeImport(root);
                this.decodeLayers(root);
                BWidget rootWidget = this.decodeContent(root);
                this.decodeProperties(root, rootWidget);
                bWidget = rootWidget;
                Object var3_8 = null;
                if (!close) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var3_9 = null;
                    if (!close) break block8;
                    this.close();
                }
                throw throwable;
            }
            this.close();
        }
        return bWidget;
    }

    public TypeInfo getMedia() {
        return this.media;
    }

    private final void decodeImport(XElem root) throws Exception {
        XElem elem = root.elem("import");
        if (elem == null) {
            throw this.err("Missing <import> element", root);
        }
        XElem[] moduleElems = elem.elems("module");
        this.modules = new String[moduleElems.length];
        int i = 0;
        while (i < moduleElems.length) {
            this.modules[i] = moduleElems[i].get("name");
            ++i;
        }
    }

    private final void decodeProperties(XElem root, BWidget rootWidget) throws Exception {
        XElem elem = root.elem("properties");
        if (elem == null) {
            this.props = new PxProperty[0];
            return;
        }
        XElem[] propElems = elem.elems("property");
        this.props = new PxProperty[propElems.length];
        int i = 0;
        while (i < propElems.length) {
            String name = propElems[i].get("name");
            BTypeSpec type = BTypeSpec.make((String)propElems[i].get("type"));
            BSimple value = this.decodeSimple((BValue)type.getResolvedType().getInstance(), propElems[i].get("value"));
            XElem[] targElems = propElems[i].elems("target");
            SlotPath[] targets = new SlotPath[targElems.length];
            int j = 0;
            while (j < targElems.length) {
                String path = targElems[j].get("ord");
                targets[j] = new SlotPath(path.substring("slot:".length()));
                ++j;
            }
            this.props[i] = new PxProperty(name, type, (BValue)value, targets);
            ++i;
        }
    }

    private final void decodeLayers(XElem root) throws Exception {
        XElem layRoot = root.elem("layers");
        if (layRoot == null) {
            this.layers = new PxLayer[0];
            return;
        }
        XElem[] elems = layRoot.elems("layer");
        this.layers = new PxLayer[elems.length];
        int i = 0;
        while (i < elems.length) {
            String name = elems[i].get("name");
            BLayerStatus status = BLayerStatus.make(elems[i].get("status"));
            this.layers[i] = new PxLayer(name, status);
            ++i;
        }
    }

    private final BWidget decodeContent(XElem root) throws Exception {
        XElem elem = root.elem("content");
        if (elem == null) {
            throw this.err("Missing <content> element", root);
        }
        XElem[] subElems = elem.elems();
        if (subElems.length != 1) {
            throw this.err("There must be exactly one child element under <content>", elem);
        }
        XElem widgetElem = subElems[0];
        BValue value = this.decodeFromElem(widgetElem);
        if (value == null || value instanceof BWidget) {
            return (BWidget)value;
        }
        throw this.err("Content type " + value.getType() + " is not a Widget", widgetElem);
    }

    private final BValue decodeFromElem(XElem x) throws Exception {
        TypeInfo type = this.toType(x);
        BValue value = null;
        try {
            value = (BValue)type.getInstance();
            if (value instanceof BPxInclude) {
                value.fw(205, (Object)this.baseOrd, (Object)this.cx, null, null);
            }
        }
        catch (Throwable e) {
            throw this.err("Cannot create instance of " + type, x, e);
        }
        if (value instanceof BSimple) {
            String string = x.get("value");
            value = this.decodeSimple(value, string);
        } else {
            this.decodeProps(x, (BComplex)value);
        }
        return value;
    }

    private final void decodeProps(XElem x, BComplex c) throws Exception {
        String type = c.getType().getTypeName();
        int i = 0;
        while (i < x.attrSize()) {
            String name = x.attrName(i);
            try {
                Property prop = c.getProperty(name);
                if (prop == null) {
                    if (name.equals("h") && c.isComponent()) {
                        ((ComponentSlotMap)c.fw(1)).setHandle((Object)x.attrValue(i));
                    }
                } else {
                    BValue value = c.get(prop);
                    if (!value.isSimple()) {
                        throw this.err("Expecting simple prop: " + name, x);
                    }
                    value = this.decodeSimple(value, x.attrValue(i));
                    c.set(prop, value);
                }
            }
            catch (XException e) {
                throw e;
            }
            catch (Exception e) {
                throw this.err("Cannot decode " + type + '.' + name, x, e);
            }
            ++i;
        }
        XElem[] kids = x.elems();
        int i2 = 0;
        while (i2 < kids.length) {
            XElem kid = kids[i2];
            String name = kid.get("name", null);
            BValue value = this.decodeFromElem(kid);
            try {
                if (name != null && c.getProperty(name) != null) {
                    c.set(name, value);
                } else {
                    c.asComponent().add(name, value);
                }
            }
            catch (XException e) {
                throw e;
            }
            catch (Exception e) {
                throw this.err("Cannot decode " + type + '.' + name, kid, e);
            }
            ++i2;
        }
    }

    private final TypeInfo toType(XElem x) {
        String typeName = x.name();
        TypeInfo type = (TypeInfo)this.types.get(typeName);
        if (type != null) {
            return type;
        }
        int i = 0;
        while (i < this.modules.length) {
            try {
                type = Sys.getRegistry().getType(this.modules[i] + ':' + typeName);
                this.types.put(typeName, type);
                return type;
            }
            catch (Exception e) {
                ++i;
            }
        }
        throw this.err("Unknown type " + typeName, x);
    }

    private final BSimple decodeSimple(BValue proto, String str) throws Exception {
        BSimple val = (BSimple)((BSimple)proto).decodeFromString(str);
        val.fw(205, (Object)this.baseOrd, (Object)this.cx, null, null);
        return val;
    }

    private final void loadBrush(BBrush brush) {
        BBrush.Paint p = brush.getPaint();
        if (p instanceof BBrush.Image) {
            BImage img = ((BBrush.Image)p).getImage();
            img.setBaseOrd(this.baseOrd);
        }
    }

    XException err(String msg, XElem elem, Throwable cause) {
        return new XException(msg, elem, cause);
    }

    XException err(String msg, XElem elem) {
        return new XException(msg, elem);
    }

    void warning(String msg, XElem elem) {
        String line = "";
        if (elem != null) {
            line = " [line " + elem.line() + ']';
        }
        System.out.println("WARNING: " + msg + line);
    }

    public PxProperty[] getPxProperties() {
        return (PxProperty[])new Array((Object[])this.props).trim();
    }

    public PxLayer[] getPxLayers() {
        return (PxLayer[])new Array((Object[])this.layers).trim();
    }

    private final /* synthetic */ void this() {
        this.types = new HashMap();
    }

    public PxDecoder(BIFile file) throws Exception {
        this(file, null);
    }

    public PxDecoder(BIFile file, Context cx) throws Exception {
        this(file.getAbsoluteOrd(), new BufferedInputStream(file.getInputStream()), cx);
    }

    public PxDecoder(BOrd baseOrd, InputStream in) throws Exception {
        this(baseOrd, in, null);
    }

    public PxDecoder(BOrd baseOrd, InputStream in, Context cx) throws Exception {
        super(in);
        this.this();
        this.baseOrd = baseOrd;
        this.cx = cx;
    }
}

