/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.pane;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.ToolPaneTheme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BLabelPaneContainer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BToolPane
extends BLabelPaneContainer {
    public static final Type TYPE;
    private static BBrush textBrush;
    private static BFont textFont;
    private static BImage restoreIcon;
    private static BImage maximizeIcon;
    private static int MAX;
    private MenuController menuController;
    private int[] sizes;
    private int[] restore;
    private BLabel armed;
    private MouseCursor origCursor;
    private boolean maximized;
    private boolean resizing;
    private int anchor;
    private int resize;
    private int resizeIndex;
    static /* synthetic */ Class class$javax$baja$ui$pane$BToolPane;

    public Type getType() {
        return TYPE;
    }

    public MenuController getMenuController() {
        return this.menuController;
    }

    public void setMenuController(MenuController menuController) {
        this.menuController = menuController;
    }

    public void computePreferredSize() {
        this.setPreferredSize(150.0, 200.0);
    }

    public void doLayout(BWidget[] kids) {
        if (kids.length == 0) {
            return;
        }
        int w = (int)this.getWidth();
        int h = (int)this.getHeight();
        if (this.sizes.length != kids.length) {
            this.sizes = new int[kids.length];
            int ds = MAX / this.sizes.length;
            int i = 0;
            while (i < this.sizes.length) {
                this.sizes[i] = ds;
                ++i;
            }
            this.maximized = false;
        }
        BLabelPane pane = (BLabelPane)kids[0];
        BLabel label = pane.getLabel();
        label.computePreferredSize();
        int ph = (int)label.getPreferredHeight() + 4;
        int dh = h - ph * kids.length;
        if (dh < 0) {
            dh = 0;
        }
        int dy = 0;
        int sum = 0;
        int i = 0;
        while (i < kids.length) {
            int sz = (int)((float)dh * ((float)this.sizes[i] / (float)MAX));
            if (i == kids.length - 2 && sz > 0 && this.sizes[kids.length - 1] == 0) {
                sz = dh - sum;
            }
            pane = (BLabelPane)kids[i];
            label = pane.getLabel();
            BWidget content = pane.getContent();
            int lx = this.menuController == null ? 5 : 20;
            int lw = w - lx - 20;
            label.setBounds(lx, dy, lw, ph);
            label.layout();
            content.setBounds(0.0, dy + ph, w, i == kids.length - 1 ? h - (dy + ph) : sz);
            content.layout();
            dy += ph + sz;
            sum += sz;
            ++i;
        }
    }

    public void paint(Graphics g) {
        int w = (int)this.getWidth();
        int h = (int)this.getHeight();
        BWidget[] kids = this.getChildWidgets();
        int i = 0;
        while (i < kids.length) {
            BLabelPane kid = (BLabelPane)kids[i];
            BLabel bLabel = kid.getLabel();
            boolean bl = false;
            if (this.sizes[i] == MAX && this.maximized) {
                bl = true;
            }
            boolean bl2 = false;
            if (kids.length > 1) {
                bl2 = true;
            }
            this.paintLabel(g, bLabel, bl, w, bl2);
            this.paintChild(g, kid.getContent());
            ++i;
        }
        g.setBrush(Theme.toolPane().getControlForeground(this));
        g.strokeRect(0.0, 0.0, (double)(w - 1), (double)(h - 1));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void paintHeaderBackground(Graphics g, BLabel label) {
        g.push();
        try {
            ToolPaneTheme toolPaneTheme = Theme.toolPane();
            boolean bl = false;
            if (label == this.armed) {
                bl = true;
            }
            g.setBrush(toolPaneTheme.getBackground(this, bl));
            g.clip(0.0, label.getY(), this.getWidth(), label.getHeight());
            g.translate(0.0, label.getY());
            g.fillRect(0.0, 0.0, this.getWidth(), label.getHeight());
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            g.pop();
            throw throwable;
        }
        {
            Object var4_5 = null;
        }
        g.pop();
    }

    void paintLabel(Graphics g, BLabel label, boolean max, int w, boolean drawIcon) {
        this.paintHeaderBackground(g, label);
        ToolPaneTheme toolPaneTheme = Theme.toolPane();
        boolean bl = false;
        if (label == this.armed) {
            bl = true;
        }
        label.setFont(toolPaneTheme.getHeaderFont(this, bl));
        ToolPaneTheme toolPaneTheme2 = Theme.toolPane();
        boolean bl2 = false;
        if (label == this.armed) {
            bl2 = true;
        }
        label.setForeground(toolPaneTheme2.getForeground(this, bl2));
        this.paintChild(g, label);
        if (drawIcon) {
            int ix = w - 18;
            int iy = (int)label.getY() + ((int)label.getHeight() - 16) / 2;
            g.drawImage(max ? restoreIcon : maximizeIcon, (double)ix, (double)iy);
        }
        if (this.menuController != null) {
            int ay = (int)label.getY() + ((int)label.getHeight() - 5) / 2 - 1;
            ToolPaneTheme toolPaneTheme3 = Theme.toolPane();
            boolean bl3 = false;
            if (label == this.armed) {
                bl3 = true;
            }
            g.setBrush(toolPaneTheme3.getForeground(this, bl3));
            this.paintMenuArrow(g, 5, ay);
        }
    }

    void paintMenuArrow(Graphics g, int x, int y) {
        int arrowWidth = 3;
        int mid = x + 10 - arrowWidth - 4;
        int bottom = y + arrowWidth + 2;
        int i = 0;
        while (i < arrowWidth) {
            g.strokeLine((double)(mid - i), (double)(bottom - i), (double)(mid + i), (double)(bottom - i));
            ++i;
        }
    }

    public void added(Property prop, Context context) {
        super.added(prop, context);
        BValue value = this.get(prop);
        if (value instanceof BLabelPane) {
            BLabel label = ((BLabelPane)value).getLabel();
            label.setForeground(textBrush);
            label.setFont(Theme.toolPane().getTextFont(this));
            label.setHalign(BHalign.left);
        }
    }

    public BWidget childAt(Point pt) {
        BWidget[] kids = this.getChildWidgets();
        int i = 0;
        while (i < kids.length) {
            BLabelPane kid = (BLabelPane)kids[i];
            BWidget w = kid.getContent();
            int dx = (int)pt.x - (int)w.getX();
            int dy = (int)pt.y - (int)w.getY();
            if (w.isVisible() && w.contains(dx, dy)) {
                return w;
            }
            ++i;
        }
        return null;
    }

    public String getStyleSelector() {
        return "pane tool-pane";
    }

    public void keyPressed(BKeyEvent event) {
        if (this.resizing && event.getKeyCode() == 27) {
            System.arraycopy(this.restore, 0, this.sizes, 0, this.sizes.length);
            this.resizing = false;
            this.relayout();
            this.restoreCursor();
        }
    }

    public void mousePressed(BMouseEvent event) {
        this.requestFocus();
        int mx = (int)event.getX();
        int my = (int)event.getY();
        int index = this.getLabelPaneAt(mx, my);
        if (index < 0) {
            return;
        }
        if ((double)mx > this.getWidth() - 20.0) {
            if (!this.maximized) {
                this.restore = new int[this.sizes.length];
                System.arraycopy(this.sizes, 0, this.restore, 0, this.sizes.length);
                this.maximized = true;
            }
            if (this.maximized && this.sizes[index] == MAX) {
                System.arraycopy(this.restore, 0, this.sizes, 0, this.sizes.length);
                this.maximized = false;
            } else {
                int i = 0;
                while (i < this.sizes.length) {
                    int n = 0;
                    if (i == index) {
                        n = MAX;
                    }
                    this.sizes[i] = n;
                    ++i;
                }
            }
            this.relayout();
        } else if (this.menuController != null && mx < 20) {
            BMenu menu = this.menuController.getMenu(this, this.getLabelPane(index).getContent());
            if (menu != null) {
                menu.open(this.armed, -this.armed.getX(), this.armed.getHeight());
            }
        } else if (!this.maximized && index > 0) {
            this.restore = new int[this.sizes.length];
            System.arraycopy(this.sizes, 0, this.restore, 0, this.sizes.length);
            this.resizing = true;
            this.anchor = this.resize = (int)event.getY();
            this.resizeIndex = index - 1;
        } else if (this.maximized) {
            System.arraycopy(this.restore, 0, this.sizes, 0, this.sizes.length);
            this.maximized = false;
            this.relayout();
        }
    }

    public void mouseReleased(BMouseEvent event) {
        if (this.resizing) {
            this.resizing = false;
            this.restoreCursor();
            this.relayout();
        }
    }

    public void mouseMoved(BMouseEvent event) {
        if (this.resizing) {
            return;
        }
        int mx = (int)event.getX();
        int my = (int)event.getY();
        BLabel old = this.armed;
        int index = this.getLabelPaneAt(mx, my);
        BLabel bLabel = this.armed = index < 0 ? null : this.getLabelPane(index).getLabel();
        if (old != this.armed && index >= 0) {
            this.armed = this.getLabelPane(index).getLabel();
            this.repaint();
        }
        if (!this.maximized && index > 0 && this.armed != null && this.inResizeZone(this.armed, mx, my)) {
            this.setCursor();
        } else {
            this.restoreCursor();
        }
    }

    public void mouseEntered(BMouseEvent event) {
        this.mouseMoved(event);
    }

    public void mouseExited(BMouseEvent event) {
        if (this.resizing) {
            return;
        }
        this.restoreCursor();
        this.armed = null;
        this.repaint();
    }

    public void mouseDragged(BMouseEvent event) {
        if (this.resizing) {
            this.resize = (int)event.getY();
            this.resize();
            this.relayout();
        }
    }

    private final BLabelPane getLabelPane(int index) {
        return (BLabelPane)this.getChildWidgets()[index];
    }

    private final int getLabelPaneAt(int x, int y) {
        BWidget[] kids = this.getChildWidgets();
        int i = 0;
        while (i < kids.length) {
            int dy;
            int dx;
            BLabelPane kid = (BLabelPane)kids[i];
            BLabel label = kid.getLabel();
            if (label.contains(dx = (int)label.getX(), dy = y - (int)label.getY())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private final boolean inResizeZone(BLabel label, int x, int y) {
        return label.contains((double)x - label.getX(), (double)y - label.getY());
    }

    private final BLabelPane getPrevious(BLabelPane pane) {
        BWidget[] kids = this.getChildWidgets();
        int i = 0;
        while (i < kids.length - 1) {
            if (kids[i + 1] == pane) {
                return (BLabelPane)kids[i];
            }
            ++i;
        }
        return null;
    }

    private final void setCursor() {
        if (this.origCursor == null) {
            this.origCursor = this.getMouseCursor();
            this.setMouseCursor(MouseCursor.nResize);
        }
    }

    private final void restoreCursor() {
        if (this.origCursor != null) {
            this.setMouseCursor(this.origCursor);
            this.origCursor = null;
        }
    }

    private final void resize() {
        float delta = (float)(this.resize - this.anchor) / (float)this.getHeight();
        int r = this.resizeIndex;
        int temp = 0;
        int i = 0;
        while (i < r) {
            temp += this.sizes[i];
            ++i;
        }
        this.sizes[r] = this.restore[r] + (int)(delta * (float)MAX);
        if (this.sizes[r] < 0) {
            this.sizes[r] = 0;
        }
        if (this.sizes[r] + temp > MAX) {
            int n = r;
            this.sizes[n] = this.sizes[n] - (this.sizes[r] + temp - MAX);
        }
        temp += this.sizes[r];
        i = r + 1;
        while (i < this.sizes.length - 1) {
            if (this.sizes[r] > 0) {
                this.sizes[i] = this.restore[i] + (int)((float)this.restore[i] * -delta);
            }
            if (this.sizes[i] < 0) {
                this.sizes[i] = 0;
            }
            if (temp + this.sizes[i] > MAX) {
                int n = i;
                this.sizes[n] = this.sizes[n] - (this.sizes[i] + temp - MAX);
            }
            temp += this.sizes[i];
            ++i;
        }
        this.sizes[this.sizes.length - 1] = MAX - temp;
    }

    public String pickle() {
        StringBuffer buf = new StringBuffer("toolpane=");
        BWidget[] kids = this.getChildWidgets();
        if (kids.length != this.sizes.length) {
            return buf.toString();
        }
        int i = 0;
        while (i < kids.length) {
            if (i > 0) {
                buf.append(";");
            }
            buf.append(this.sizes[i]);
            ++i;
        }
        return buf.toString();
    }

    public void unpickle(String str) {
        BWidget[] kids;
        String[] sub = TextUtil.split((String)(str = str.substring("toolpane=".length())), (char)';');
        if (sub.length != (kids = this.getChildWidgets()).length) {
            return;
        }
        int[] old = this.sizes;
        try {
            this.sizes = new int[sub.length];
            int i = 0;
            while (i < sub.length) {
                this.sizes[i] = Integer.parseInt(sub[i]);
                if (this.sizes[i] == MAX && this.sizes.length > 1) {
                    this.restore = new int[this.sizes.length];
                    int ds = MAX / this.sizes.length;
                    int j = 0;
                    while (j < this.restore.length) {
                        this.restore[j] = ds;
                        ++j;
                    }
                    this.maximized = true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.sizes = old;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.sizes = new int[0];
        this.restore = new int[0];
        this.armed = null;
        this.origCursor = null;
        this.maximized = false;
        this.resizing = false;
    }

    public BToolPane() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$ui$pane$BToolPane;
        if (clazz == null) {
            clazz = class$javax$baja$ui$pane$BToolPane = BToolPane.class("[Ljavax.baja.ui.pane.BToolPane;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        textBrush = BColor.white.toBrush();
        textFont = Theme.widget().getBoldText();
        restoreIcon = BImage.make((String)"module://icons/x16/restoreWhite.png");
        maximizeIcon = BImage.make((String)"module://icons/x16/maximizeWhite.png");
        MAX = 10000;
    }

    public static interface MenuController {
        public BMenu getMenu(BToolPane var1, BWidget var2);
    }
}

