/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.pane;

import com.tridium.ui.theme.SplitPaneTheme;
import com.tridium.ui.theme.Theme;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BPane;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSplitPane
extends BPane {
    public static final Property widget1 = BSplitPane.newProperty((int)0, (BValue)new BNullWidget(), null);
    public static final Property widget2 = BSplitPane.newProperty((int)0, (BValue)new BNullWidget(), null);
    public static final Property dividerWidth = BSplitPane.newProperty((int)0, (int)6, (BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.make((double)0.0)));
    public static final Property moveableDivider = BSplitPane.newProperty((int)0, (boolean)true, null);
    public static final Property dividerPosition = BSplitPane.newProperty((int)0, (int)50, (BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.make((double)0.0)));
    public static final Property orientation = BSplitPane.newProperty((int)0, (BValue)BOrientation.horizontal, null);
    public static final Property continuousLayout = BSplitPane.newProperty((int)0, (boolean)true, null);
    public static final Topic dividerMoved = BSplitPane.newTopic((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    private BBrush shadowDivBrush;
    private RectGeom origDivRect;
    private RectGeom divRect;
    private boolean visibleDivider;
    private boolean inDrag;
    private double dragOffset;
    static /* synthetic */ Class class$javax$baja$ui$pane$BSplitPane;

    public BWidget getWidget1() {
        return (BWidget)this.get(widget1);
    }

    public void setWidget1(BWidget v) {
        this.set(widget1, (BValue)v, null);
    }

    public BWidget getWidget2() {
        return (BWidget)this.get(widget2);
    }

    public void setWidget2(BWidget v) {
        this.set(widget2, (BValue)v, null);
    }

    public double getDividerWidth() {
        return this.getDouble(dividerWidth);
    }

    public void setDividerWidth(double v) {
        this.setDouble(dividerWidth, v, null);
    }

    public boolean getMoveableDivider() {
        return this.getBoolean(moveableDivider);
    }

    public void setMoveableDivider(boolean v) {
        this.setBoolean(moveableDivider, v, null);
    }

    public double getDividerPosition() {
        return this.getDouble(dividerPosition);
    }

    public void setDividerPosition(double v) {
        this.setDouble(dividerPosition, v, null);
    }

    public BOrientation getOrientation() {
        return (BOrientation)this.get(orientation);
    }

    public void setOrientation(BOrientation v) {
        this.set(orientation, (BValue)v, null);
    }

    public boolean getContinuousLayout() {
        return this.getBoolean(continuousLayout);
    }

    public void setContinuousLayout(boolean v) {
        this.setBoolean(continuousLayout, v, null);
    }

    public void fireDividerMoved(BWidgetEvent event) {
        this.fire(dividerMoved, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public double getAbsoluteDividerLocation() {
        double pos = this.getDividerPosition();
        if (this.getOrientation() == BOrientation.horizontal) {
            double w = this.getWidth() - this.getDividerWidth();
            return w * (pos / 100.0);
        }
        double h = this.getHeight() - this.getDividerWidth();
        return h * (pos / 100.0);
    }

    public void setAbsoluteDividerLocation(double loc) {
        if (this.getOrientation() == BOrientation.horizontal) {
            double w = this.getWidth() - this.getDividerWidth();
            loc = Math.max(loc, 0.0);
            loc = Math.min(loc, w);
            this.setDividerPosition(loc / w * 100.0);
        } else {
            double h = this.getHeight() - this.getDividerWidth();
            loc = Math.max(loc, 0.0);
            loc = Math.min(loc, h);
            this.setDividerPosition(loc / h * 100.0);
        }
    }

    public void childCalledRelayout(BWidget child) {
    }

    public void computePreferredSize() {
        double w = 0.0;
        double h = 0.0;
        BWidget widget1 = this.getWidget1();
        BWidget widget2 = this.getWidget2();
        int visCount = 0;
        if (widget1.isVisible()) {
            ++visCount;
        }
        if (widget2.isVisible()) {
            ++visCount;
        }
        if (widget1.isVisible()) {
            widget1.computePreferredSize();
        }
        if (widget2.isVisible()) {
            widget2.computePreferredSize();
        }
        if (this.getOrientation() == BOrientation.vertical) {
            double d = h = visCount == 2 ? this.getDividerWidth() : 0.0;
            if (widget1.isVisible()) {
                h += widget1.getPreferredHeight();
                w = widget1.getPreferredWidth();
            }
            if (widget2.isVisible()) {
                h += widget2.getPreferredHeight();
                w = Math.max(w, widget2.getPreferredWidth());
            }
        } else if (this.getOrientation() == BOrientation.horizontal) {
            h = visCount == 2 ? this.getDividerWidth() : 0.0;
            w = h;
            if (widget1.isVisible()) {
                w += widget1.getPreferredWidth();
                h = widget1.getPreferredHeight();
            }
            if (widget2.isVisible()) {
                w += widget2.getPreferredWidth();
                h = Math.max(h, widget2.getPreferredHeight());
            }
        }
        this.setPreferredSize(w, h);
    }

    public void doLayout(BWidget[] kids) {
        if (this.getWidth() == 0.0 || this.getHeight() == 0.0) {
            return;
        }
        if (this.getOrientation() == BOrientation.horizontal) {
            this.layoutHorizontal();
        } else if (this.getOrientation() == BOrientation.vertical) {
            this.layoutVertical();
        }
    }

    private final void layoutHorizontal() {
        double divLoc;
        double w = this.getWidth();
        double h = this.getHeight();
        BWidget widget1 = this.getWidget1();
        BWidget widget2 = this.getWidget2();
        this.divRect = new RectGeom(0.0, 0.0, this.getDividerWidth(), h);
        boolean bl = false;
        if (this.getDividerWidth() > 0.0) {
            bl = this.visibleDivider = true;
        }
        if (!widget1.isVisible()) {
            widget1.setBounds(0.0, 0.0, 0.0, 0.0);
            this.visibleDivider = false;
            if (widget2.isVisible()) {
                widget2.setBounds(0.0, 0.0, (int)w, (int)h);
            }
            return;
        }
        if (!widget2.isVisible()) {
            widget2.setBounds(0.0, 0.0, 0.0, 0.0);
            this.visibleDivider = false;
            if (widget1.isVisible()) {
                widget1.setBounds(0.0, 0.0, (int)w, (int)h);
            }
            return;
        }
        double divPos = this.getDividerPosition();
        if (divPos > 100.0) {
            divPos = 50.0;
        }
        this.divRect.x = divLoc = (w - this.divRect.width) * (divPos / 100.0);
        widget1.setBounds(0.0, 0.0, (int)this.divRect.x, (int)h);
        double w2 = w - this.divRect.x - this.divRect.width;
        widget2.setBounds((int)(this.divRect.x + this.divRect.width), 0.0, (int)w2, (int)h);
    }

    private final void layoutVertical() {
        double divLoc;
        double w = this.getWidth();
        double h = this.getHeight();
        BWidget widget1 = this.getWidget1();
        BWidget widget2 = this.getWidget2();
        this.divRect = new RectGeom(0.0, 0.0, w, this.getDividerWidth());
        boolean bl = false;
        if (this.getDividerWidth() > 0.0) {
            bl = this.visibleDivider = true;
        }
        if (!widget1.isVisible()) {
            widget1.setBounds(0.0, 0.0, 0.0, 0.0);
            this.visibleDivider = false;
            if (widget2.isVisible()) {
                widget2.setBounds(0.0, 0.0, (int)w, (int)h);
            }
            return;
        }
        if (!widget2.isVisible()) {
            widget2.setBounds(0.0, 0.0, 0.0, 0.0);
            this.visibleDivider = false;
            if (widget1.isVisible()) {
                widget1.setBounds(0.0, 0.0, (int)w, (int)h);
            }
            return;
        }
        double divPos = this.getDividerPosition();
        this.divRect.y = divLoc = (h - this.divRect.height) * (divPos / 100.0);
        widget1.setBounds(0.0, 0.0, (int)w, (int)this.divRect.y);
        double h2 = h - this.divRect.y - this.divRect.height;
        widget2.setBounds(0.0, (int)(this.divRect.y + this.divRect.height), (int)w, (int)h2);
    }

    private final boolean inDivider(double x, double y) {
        if (this.visibleDivider) {
            return this.divRect.contains(x, y);
        }
        return false;
    }

    public void paint(Graphics g) {
        SplitPaneTheme theme = Theme.splitPane();
        double w = this.getWidth();
        double h = this.getHeight();
        BWidget widget1 = this.getWidget1();
        BWidget widget2 = this.getWidget2();
        if (widget1.isNull()) {
            g.setBrush(theme.getWindowBackground());
            if (this.getOrientation() == BOrientation.horizontal) {
                g.fillRect(0.0, 0.0, this.divRect.x, h);
            } else {
                g.fillRect(0.0, 0.0, w, this.divRect.y);
            }
            this.paintChild(g, widget1);
        } else if (widget1.isVisible()) {
            this.paintChild(g, widget1);
        }
        if (widget2.isNull()) {
            g.setBrush(theme.getWindowBackground());
            if (this.getOrientation() == BOrientation.horizontal) {
                g.fillRect(this.divRect.x + this.divRect.width, 0.0, w - this.divRect.x - this.divRect.width, h);
            } else {
                g.fillRect(0.0, this.divRect.y + this.divRect.height, w, h - this.divRect.y - this.divRect.height);
            }
            this.paintChild(g, widget2);
        } else if (widget2.isVisible()) {
            this.paintChild(g, widget2);
        }
        if (this.visibleDivider) {
            boolean doubleDiv;
            boolean bl = false;
            if (!this.getContinuousLayout() && this.inDrag) {
                bl = true;
            }
            if (doubleDiv = bl) {
                theme.paintDivider(g, this, this.origDivRect, doubleDiv, this.getMoveableDivider());
                g.setBrush(this.shadowDivBrush);
                g.fill((IGeom)this.divRect);
            } else {
                theme.paintDivider(g, this, this.divRect, doubleDiv, this.getMoveableDivider());
            }
        }
    }

    public BWidget childAt(Point pt) {
        if (this.inDrag) {
            return null;
        }
        return super.childAt(pt);
    }

    public String getStyleSelector() {
        return "pane split-pane";
    }

    public void mouseEntered(BMouseEvent evt) {
        MouseCursor c = this.checkCursor(evt.getX(), evt.getY());
        if (c != null) {
            this.setMouseCursor(c);
        }
    }

    public void mouseExited(BMouseEvent evt) {
        if (!this.inDrag) {
            this.resetCursor();
        }
    }

    public void mousePressed(BMouseEvent evt) {
        if (!this.inDivider(evt.getX(), evt.getY())) {
            return;
        }
        if (!this.getMoveableDivider()) {
            return;
        }
        if (!this.getContinuousLayout()) {
            this.origDivRect = new RectGeom((IRectGeom)this.divRect);
        }
        this.dragOffset = this.getOrientation() == BOrientation.horizontal ? evt.getX() - this.divRect.x : evt.getY() - this.divRect.y;
        this.inDrag = true;
    }

    public void mouseReleased(BMouseEvent evt) {
        this.dragOffset = 0.0;
        this.inDrag = false;
        if (!this.getContinuousLayout()) {
            this.origDivRect = null;
            this.relayout();
        }
        this.fireDividerMoved(new BWidgetEvent(1, this));
        MouseCursor c = this.checkCursor(evt.getX(), evt.getY());
        if (c != null) {
            this.setMouseCursor(c);
        }
    }

    public void mouseMoved(BMouseEvent evt) {
        MouseCursor c = this.checkCursor(evt.getX(), evt.getY());
        if (c != null) {
            this.setMouseCursor(c);
        }
    }

    public void mouseDragged(BMouseEvent evt) {
        double newPos;
        if (!this.inDrag) {
            return;
        }
        if (this.getOrientation() == BOrientation.horizontal) {
            newPos = Math.max(0.0, evt.getX() - this.dragOffset);
            this.divRect.x = newPos = Math.min(newPos, this.getWidth() - this.divRect.width);
        } else {
            newPos = Math.max(0.0, evt.getY() - this.dragOffset);
            this.divRect.y = newPos = Math.min(newPos, this.getHeight() - this.divRect.height);
        }
        this.setDividerPosition(this.fromAbsolute(newPos));
        if (this.getContinuousLayout()) {
            this.relayout();
        } else {
            this.repaint();
        }
    }

    private final double fromAbsolute(double absPos) {
        if (this.getOrientation() == BOrientation.horizontal) {
            double w = this.getWidth() - this.getDividerWidth();
            if (w <= 0.0) {
                return 0.0;
            }
            return absPos / w * 100.0;
        }
        double h = this.getHeight() - this.getDividerWidth();
        if (h <= 0.0) {
            return 0.0;
        }
        return absPos / h * 100.0;
    }

    private final void resetCursor() {
        if (!this.getMoveableDivider()) {
            return;
        }
        this.setMouseCursor(MouseCursor.normal);
    }

    private final MouseCursor checkCursor(double x, double y) {
        if (!this.getMoveableDivider()) {
            return null;
        }
        if (this.inDivider(x, y)) {
            if (this.getOrientation() == BOrientation.horizontal) {
                return MouseCursor.eResize;
            }
            return MouseCursor.nResize;
        }
        return MouseCursor.normal;
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x != 304) {
            return super.fw(x, a, b, c, d);
        }
        Point p = (Point)a;
        return this.checkCursor(p.x, p.y);
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.shadowDivBrush = BColor.make((int)0, (int)0, (int)0, (int)75).toBrush();
        this.inDrag = false;
        this.dragOffset = 0.0;
    }

    public BSplitPane(BOrientation orientation, double dividerPosition) {
        this.this();
        this.setOrientation(orientation);
        this.setDividerPosition(dividerPosition);
    }

    public BSplitPane(BWidget widget1, BWidget widget2) {
        this.this();
        this.setWidget1(widget1);
        this.setWidget2(widget2);
    }

    public BSplitPane() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$ui$pane$BSplitPane;
        if (clazz == null) {
            clazz = class$javax$baja$ui$pane$BSplitPane = BSplitPane.class("[Ljavax.baja.ui.pane.BSplitPane;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"widgets/splitPane.png");
    }
}

