/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.pane;

import com.tridium.ui.theme.Theme;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.Graphics;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BPane;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BGridPane
extends BPane {
    public static final Property columnCount = BGridPane.newProperty((int)0, (int)2, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    public static final Property valign = BGridPane.newProperty((int)0, (BValue)BValign.center, null);
    public static final Property halign = BGridPane.newProperty((int)0, (BValue)BHalign.center, null);
    public static final Property rowAlign = BGridPane.newProperty((int)0, (BValue)BValign.center, null);
    public static final Property columnAlign = BGridPane.newProperty((int)0, (BValue)BHalign.left, null);
    public static final Property rowGap = BGridPane.newProperty((int)0, (int)3, null);
    public static final Property columnGap = BGridPane.newProperty((int)0, (int)3, null);
    public static final Property uniformRowHeight = BGridPane.newProperty((int)0, (boolean)false, null);
    public static final Property uniformColumnWidth = BGridPane.newProperty((int)0, (boolean)false, null);
    public static final Property stretchRow = BGridPane.newProperty((int)0, (int)-1, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)-1)));
    public static final Property stretchColumn = BGridPane.newProperty((int)0, (int)-1, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)-1)));
    public static final Property colorRows = BGridPane.newProperty((int)0, (boolean)false, null);
    public static final Property bandBrush = BGridPane.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Type TYPE;
    private static final BIcon icon;
    double xo;
    double yo;
    double[] cw;
    double[] rh;
    static /* synthetic */ Class class$javax$baja$ui$pane$BGridPane;

    public int getColumnCount() {
        return this.getInt(columnCount);
    }

    public void setColumnCount(int v) {
        this.setInt(columnCount, v, null);
    }

    public BValign getValign() {
        return (BValign)this.get(valign);
    }

    public void setValign(BValign v) {
        this.set(valign, (BValue)v, null);
    }

    public BHalign getHalign() {
        return (BHalign)this.get(halign);
    }

    public void setHalign(BHalign v) {
        this.set(halign, (BValue)v, null);
    }

    public BValign getRowAlign() {
        return (BValign)this.get(rowAlign);
    }

    public void setRowAlign(BValign v) {
        this.set(rowAlign, (BValue)v, null);
    }

    public BHalign getColumnAlign() {
        return (BHalign)this.get(columnAlign);
    }

    public void setColumnAlign(BHalign v) {
        this.set(columnAlign, (BValue)v, null);
    }

    public double getRowGap() {
        return this.getDouble(rowGap);
    }

    public void setRowGap(double v) {
        this.setDouble(rowGap, v, null);
    }

    public double getColumnGap() {
        return this.getDouble(columnGap);
    }

    public void setColumnGap(double v) {
        this.setDouble(columnGap, v, null);
    }

    public boolean getUniformRowHeight() {
        return this.getBoolean(uniformRowHeight);
    }

    public void setUniformRowHeight(boolean v) {
        this.setBoolean(uniformRowHeight, v, null);
    }

    public boolean getUniformColumnWidth() {
        return this.getBoolean(uniformColumnWidth);
    }

    public void setUniformColumnWidth(boolean v) {
        this.setBoolean(uniformColumnWidth, v, null);
    }

    public int getStretchRow() {
        return this.getInt(stretchRow);
    }

    public void setStretchRow(int v) {
        this.setInt(stretchRow, v, null);
    }

    public int getStretchColumn() {
        return this.getInt(stretchColumn);
    }

    public void setStretchColumn(int v) {
        this.setInt(stretchColumn, v, null);
    }

    public boolean getColorRows() {
        return this.getBoolean(colorRows);
    }

    public void setColorRows(boolean v) {
        this.setBoolean(colorRows, v, null);
    }

    public BBrush getBandBrush() {
        return (BBrush)this.get(bandBrush);
    }

    public void setBandBrush(BBrush v) {
        this.set(bandBrush, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void computePreferredSize() {
        BWidget[] kids = this.getChildWidgets();
        double hgap = this.getColumnGap();
        double vgap = this.getRowGap();
        int columns = this.getColumnCount();
        if (columns < 1) {
            columns = 1;
        }
        int rows = kids.length / columns;
        if (kids.length % columns > 0) {
            ++rows;
        }
        this.cw = new double[columns];
        this.rh = new double[rows];
        double maxw = 0.0;
        double maxh = 0.0;
        int i = 0;
        int r = 0;
        block0: while (r < this.rh.length) {
            int c = 0;
            while (c < this.cw.length) {
                BWidget kid;
                if (i >= kids.length) break block0;
                if ((kid = kids[i++]).isVisible()) {
                    kid.computePreferredSize();
                    this.cw[c] = Math.max(this.cw[c], kid.getPreferredWidth());
                    this.rh[r] = Math.max(this.rh[r], kid.getPreferredHeight());
                    maxw = Math.max(this.cw[c], maxw);
                    maxh = Math.max(this.rh[r], maxh);
                }
                ++c;
            }
            ++r;
        }
        if (this.getUniformColumnWidth()) {
            int c = 0;
            while (c < this.cw.length) {
                this.cw[c] = maxw;
                ++c;
            }
        }
        if (this.getUniformRowHeight()) {
            r = 0;
            while (r < this.rh.length) {
                this.rh[r] = maxh;
                ++r;
            }
        }
        double pw = 0.0;
        double ph = 0.0;
        i = 0;
        while (i < this.cw.length) {
            if (i > 0) {
                pw += hgap;
            }
            pw += this.cw[i];
            ++i;
        }
        i = 0;
        while (i < this.rh.length) {
            if (i > 0) {
                ph += vgap;
            }
            ph += this.rh[i];
            ++i;
        }
        this.setPreferredSize(pw, ph);
    }

    public void doLayout(BWidget[] kids) {
        this.computePreferredSize();
        double pw = this.getPreferredWidth();
        double ph = this.getPreferredHeight();
        double w = this.getWidth();
        double h = this.getHeight();
        double hgap = this.getColumnGap();
        double vgap = this.getRowGap();
        int hlayout = this.getColumnAlign().getOrdinal();
        int vlayout = this.getRowAlign().getOrdinal();
        int stretchRow = this.getStretchRow();
        int stretchCol = this.getStretchColumn();
        this.xo = 0.0;
        if (w > pw && stretchCol < 0) {
            int hpalign = this.getHalign().getOrdinal();
            if (hpalign == 1) {
                this.xo = (w - pw) / (double)2;
            }
            if (hpalign == 2) {
                this.xo = w - pw;
            }
        }
        this.yo = 0.0;
        if (h > ph && stretchRow < 0) {
            int vpalign = this.getValign().getOrdinal();
            if (vpalign == 1) {
                this.yo = (h - ph) / (double)2;
            }
            if (vpalign == 2) {
                this.yo = h - ph;
            }
        }
        if (stretchCol >= 0 && stretchCol < this.cw.length && w > pw) {
            int n = stretchCol;
            this.cw[n] = this.cw[n] + (w - pw);
        }
        if (stretchRow >= 0 && stretchRow < this.rh.length && h > ph) {
            int n = stretchRow;
            this.rh[n] = this.rh[n] + (h - ph);
        }
        int i = 0;
        double cx = 0.0;
        double ry = 0.0;
        int r = 0;
        block0: while (r < this.rh.length) {
            cx = 0.0;
            int c = 0;
            while (c < this.cw.length) {
                if (i >= kids.length) break block0;
                BWidget kid = kids[i++];
                double colw = this.cw[c];
                double rowh = this.rh[r];
                double kph = kid.getPreferredHeight();
                double kx = this.xo + cx;
                double ky = this.yo + ry;
                double kw = colw;
                double kh = rowh;
                if (hlayout != 3) {
                    kw = kid.getPreferredWidth();
                    if (hlayout == 1) {
                        kx = this.xo + cx + (colw - kw) / (double)2;
                    }
                    if (hlayout == 2) {
                        kx = this.xo + cx + colw - kw;
                    }
                }
                if (vlayout != 3) {
                    kh = kid.getPreferredHeight();
                    if (vlayout == 1) {
                        ky = this.yo + ry + (rowh - kh) / (double)2;
                    }
                    if (vlayout == 2) {
                        ky = this.yo + ry + rowh - kh;
                    }
                }
                kid.setBounds((int)kx, (int)ky, (int)kw, (int)kh);
                cx += this.cw[c] + hgap;
                ++c;
            }
            ry += this.rh[r] + vgap;
            ++r;
        }
    }

    public void paint(Graphics g) {
        double vgap = this.getRowGap();
        double w = this.getWidth();
        Theme.pane().paintBackground(g, this);
        if (this.getColorRows()) {
            g.setBrush(Theme.gridPane().getBandBrush(this));
            double vgapHalf = vgap / (double)2;
            double ry = this.yo;
            int r = 0;
            while (r < this.rh.length) {
                if (r % 2 == 0) {
                    g.fillRect(0.0, ry - vgapHalf, w, this.rh[r] + vgap);
                }
                ry += this.rh[r] + vgap;
                ++r;
            }
        }
        this.paintChildren(g);
    }

    public String getStyleSelector() {
        return "pane grid-pane";
    }

    public void changed(Property prop, Context context) {
        this.relayout();
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.cw = new double[0];
        this.rh = new double[0];
    }

    public BGridPane(int columnCount) {
        this.this();
        this.setColumnCount(columnCount);
    }

    public BGridPane() {
        this.this();
    }

    public BGridPane(int columnCount, BWidget[] childWidgets) {
        this.this();
        this.setColumnCount(columnCount);
        int i = 0;
        while (i < childWidgets.length) {
            this.add(null, (BValue)childWidgets[i]);
            ++i;
        }
    }

    public BGridPane(BWidget[] childWidgets) {
        this.this();
        int i = 0;
        while (i < childWidgets.length) {
            this.add(null, (BValue)childWidgets[i]);
            ++i;
        }
    }

    static {
        Class clazz = class$javax$baja$ui$pane$BGridPane;
        if (clazz == null) {
            clazz = class$javax$baja$ui$pane$BGridPane = BGridPane.class("[Ljavax.baja.ui.pane.BGridPane;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"widgets/gridPane.png");
    }
}

