/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.pane;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BPane;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BExpandablePane
extends BPane {
    public static final Property summary = BExpandablePane.newProperty((int)0, (BValue)new BNullWidget(), null);
    public static final Property expansion = BExpandablePane.newProperty((int)0, (BValue)new BNullWidget(), null);
    public static final Property expanderHalign = BExpandablePane.newProperty((int)0, (BValue)BHalign.right, null);
    public static final Property summaryBackground = BExpandablePane.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Topic expanderEvent = BExpandablePane.newTopic((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    private static final double GAP = 2.0;
    private static final double MIN_EXPANDER_HEIGHT = 17.0;
    private boolean isExpanded;
    private boolean expanderVisible;
    private RectGeom button;
    private boolean overButton;
    static /* synthetic */ Class class$javax$baja$ui$pane$BExpandablePane;

    public BWidget getSummary() {
        return (BWidget)this.get(summary);
    }

    public void setSummary(BWidget v) {
        this.set(summary, (BValue)v, null);
    }

    public BWidget getExpansion() {
        return (BWidget)this.get(expansion);
    }

    public void setExpansion(BWidget v) {
        this.set(expansion, (BValue)v, null);
    }

    public BHalign getExpanderHalign() {
        return (BHalign)this.get(expanderHalign);
    }

    public void setExpanderHalign(BHalign v) {
        this.set(expanderHalign, (BValue)v, null);
    }

    public BBrush getSummaryBackground() {
        return (BBrush)this.get(summaryBackground);
    }

    public void setSummaryBackground(BBrush v) {
        this.set(summaryBackground, (BValue)v, null);
    }

    public void fireExpanderEvent(BWidgetEvent event) {
        this.fire(expanderEvent, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean isExpanded) {
        if (this.isExpanded != isExpanded) {
            this.isExpanded = isExpanded;
            if (isExpanded) {
                this.relayoutSync();
                this.scrollToVisible(new RectGeom(0.0, 0.0, this.getWidth(), this.getHeight()));
            } else {
                this.relayout();
            }
        }
    }

    public void setExpanderVisible(boolean expanderVisible) {
        if (this.expanderVisible != expanderVisible) {
            this.expanderVisible = expanderVisible;
            this.relayout();
        }
    }

    public void computePreferredSize() {
        BWidget summary = this.getSummary();
        summary.computePreferredSize();
        double pw = summary.getPreferredWidth();
        double ph = summary.getPreferredHeight();
        if (this.expanderVisible) {
            pw += (double)2 + Theme.expandablePane().getExpanderWidth();
            ph = Math.max(ph, 17.0);
        }
        if (this.isExpanded) {
            BWidget expansion = this.getExpansion();
            expansion.computePreferredSize();
            pw = Math.max(pw, expansion.getPreferredWidth());
            ph += expansion.getPreferredHeight();
        }
        this.setPreferredSize(pw, ph);
    }

    public void doLayout(BWidget[] kids) {
        double gap;
        double w = this.getWidth();
        double h = this.getHeight();
        BWidget summary = this.getSummary();
        summary.computePreferredSize();
        double sw = summary.getPreferredWidth();
        double sh = summary.getPreferredHeight();
        double seh = Math.max(sh, 17.0);
        double d = gap = summary.isNull() ? 0.0 : (double)2;
        if (this.expanderVisible) {
            double yoffset;
            double ew = Theme.expandablePane().getExpanderWidth();
            double d2 = yoffset = sh >= seh ? seh - sh : 0.0;
            if (this.getExpanderHalign() == BHalign.right) {
                summary.setBounds(0.0, (seh - sh) / (double)2, Math.min(sw, w - gap - ew), sh);
                this.button.set(sw + gap, yoffset, ew, seh);
            } else {
                this.button.set(0.0, yoffset, ew, seh);
                summary.setBounds(ew + gap, (seh - sh) / (double)2, Math.min(sw, w - gap - ew), sh);
            }
        } else {
            summary.setBounds(0.0, (seh - sh) / (double)2, sw, sh);
            this.button.set(0.0, 0.0, 0.0, 0.0);
        }
        BWidget expansion = this.getExpansion();
        if (this.isExpanded) {
            expansion.setBounds(0.0, seh, w, h - seh);
        } else {
            expansion.setBounds(0.0, 0.0, 0.0, 0.0);
        }
    }

    public void paint(Graphics g) {
        BBrush bg = this.getSummaryBackground();
        if (!bg.isNull()) {
            g.setBrush(bg);
            g.fillRect(0.0, 0.0, this.getWidth(), Math.max(this.getSummary().getHeight(), 17.0));
        }
        this.paintChild(g, this.getSummary());
        if (this.isExpanded) {
            this.paintChild(g, this.getExpansion());
        }
        if (this.expanderVisible) {
            Theme.expandablePane().paintButton(g, this, this.button, this.isExpanded, this.overButton);
        }
    }

    public void mouseReleased(BMouseEvent event) {
        if (this.button.contains(event.getX(), event.getY())) {
            this.setExpanded(this.isExpanded ^ true);
            this.fireExpanderEvent(new BWidgetEvent(2, this));
        }
    }

    public void mouseEntered(BMouseEvent event) {
        super.mouseEntered(event);
        this.checkOverButton(event);
    }

    public void mouseExited(BMouseEvent event) {
        this.overButton = false;
        this.repaint();
    }

    public void mouseMoved(BMouseEvent event) {
        super.mouseMoved(event);
        this.checkOverButton(event);
    }

    private final void checkOverButton(BMouseEvent event) {
        double my;
        double mx = event.getX();
        boolean nowOverButton = this.button.contains(mx, my = event.getY());
        if (nowOverButton != this.overButton) {
            this.overButton = nowOverButton;
            this.repaint();
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.isExpanded = false;
        this.expanderVisible = true;
        this.button = new RectGeom();
    }

    public BExpandablePane(BWidget summary, BWidget expansion, BHalign align) {
        this.this();
        this.setSummary(summary);
        this.setExpansion(expansion);
        this.setExpanderHalign(align);
    }

    public BExpandablePane(BWidget summary, BWidget expansion) {
        this.this();
        this.setSummary(summary);
        this.setExpansion(expansion);
    }

    public BExpandablePane() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$ui$pane$BExpandablePane;
        if (clazz == null) {
            clazz = class$javax$baja$ui$pane$BExpandablePane = BExpandablePane.class("[Ljavax.baja.ui.pane.BExpandablePane;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"widgets/expandablePane.png");
    }
}

