/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.pane;

import com.tridium.gx.GraphPaper;
import com.tridium.gx.GxEnv;
import com.tridium.gx.Hatching;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BSize;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.IPoint;
import javax.baja.gx.Point;
import javax.baja.nre.util.Array;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLayout;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScaleMode;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.shape.BShape;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCanvasPane
extends BPane {
    public static final Property viewSize = BCanvasPane.newProperty((int)0, (BValue)BSize.make((double)100.0, (double)100.0), null);
    public static final Property scale = BCanvasPane.newProperty((int)0, (BValue)BScaleMode.none, null);
    public static final Property halign = BCanvasPane.newProperty((int)0, (BValue)BHalign.center, null);
    public static final Property valign = BCanvasPane.newProperty((int)0, (BValue)BValign.center, null);
    public static final Property background = BCanvasPane.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Type TYPE;
    private static final BIcon icon;
    public boolean overrideClip;
    private BTransform scaleTransform;
    private double dx;
    private double dy;
    private double sx;
    private double sy;
    private boolean paintGraphPaper;
    private boolean paintHatching;
    private GraphPaper graphPaper;
    private Hatching hatching;
    static /* synthetic */ Class class$javax$baja$ui$pane$BCanvasPane;
    static /* synthetic */ Class class$javax$baja$ui$BWidget;

    public BSize getViewSize() {
        return (BSize)this.get(viewSize);
    }

    public void setViewSize(BSize v) {
        this.set(viewSize, (BValue)v, null);
    }

    public BScaleMode getScale() {
        return (BScaleMode)this.get(scale);
    }

    public void setScale(BScaleMode v) {
        this.set(scale, (BValue)v, null);
    }

    public BHalign getHalign() {
        return (BHalign)this.get(halign);
    }

    public void setHalign(BHalign v) {
        this.set(halign, (BValue)v, null);
    }

    public BValign getValign() {
        return (BValign)this.get(valign);
    }

    public void setValign(BValign v) {
        this.set(valign, (BValue)v, null);
    }

    public BBrush getBackground() {
        return (BBrush)this.get(background);
    }

    public void setBackground(BBrush v) {
        this.set(background, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void computePreferredSize() {
        this.setPreferredSize(this.getViewSize().width, this.getViewSize().height);
    }

    public void doLayout(BWidget[] kids) {
        double w = this.getWidth();
        double h = this.getHeight();
        double vw = this.getViewSize().width;
        double vh = this.getViewSize().height;
        switch (this.getScale().getOrdinal()) {
            case 1: {
                this.sx = w / vw;
                this.sy = h / vh;
                this.dy = 0.0;
                this.dx = 0.0;
                break;
            }
            case 2: {
                this.sx = this.sy = Math.min(w / vw, h / vh);
                if (this.sx == w / vw) {
                    this.dx = 0.0;
                    this.dy = this.doValign(h, vh * this.sx);
                    break;
                }
                this.dx = this.doHalign(w, vw * this.sx);
                this.dy = 0.0;
                break;
            }
            case 3: {
                this.sx = w / vw;
                this.sy = 1.0;
                this.dx = 0.0;
                this.dy = this.doValign(h, vh);
                break;
            }
            case 4: {
                this.sx = 1.0;
                this.sy = h / vh;
                this.dx = this.doHalign(w, vw);
                this.dy = 0.0;
                break;
            }
            default: {
                this.sy = 1.0;
                this.sx = 1.0;
                this.dx = this.doHalign(w, vw);
                this.dy = this.doValign(h, vh);
            }
        }
        this.dx = Math.floor(this.dx);
        this.dy = Math.floor(this.dy);
        this.scaleTransform = BTransform.make((BTransform.Transform[])new BTransform.Transform[]{new BTransform.Translate(this.dx, this.dy), new BTransform.Scale(this.sx, this.sy)});
        int i = 0;
        while (i < kids.length) {
            BLayout layout = kids[i].getLayout();
            if (!layout.isNull()) {
                kids[i].computePreferredSize();
                double cx = layout.getX();
                double cy = layout.getY();
                double cw = layout.getWidth();
                double ch = layout.getHeight();
                if (layout.getXUnit() == 1) {
                    cx = cx / 100.0 * vw;
                }
                if (layout.getYUnit() == 1) {
                    cy = cy / 100.0 * vh;
                }
                if (layout.getWidthUnit() == 1) {
                    cw = cw / 100.0 * vw;
                } else if (layout.getWidthUnit() == 2) {
                    cw = kids[i].getPreferredWidth();
                }
                if (layout.getHeightUnit() == 1) {
                    ch = ch / 100.0 * vh;
                } else if (layout.getHeightUnit() == 2) {
                    ch = kids[i].getPreferredHeight();
                }
                kids[i].setBounds(cx, cy, cw, ch);
            }
            ++i;
        }
    }

    private final double doHalign(double w, double dw) {
        BHalign halign = this.getHalign();
        if (halign == BHalign.left) {
            return 0.0;
        }
        if (halign == BHalign.center) {
            return (w - dw) / (double)2;
        }
        return w - dw - 1.0;
    }

    private final double doValign(double h, double dh) {
        BValign valign = this.getValign();
        if (valign == BValign.top) {
            return 0.0;
        }
        if (valign == BValign.center) {
            return (h - dh) / (double)2;
        }
        return h - dh - 1.0;
    }

    public BWidget childAt(Point pt) {
        return super.childAt(this.scaleTransform.getInverse().transform((IPoint)pt, null));
    }

    public BWidget[] childrenAt(Point pt) {
        pt = this.scaleTransform.getInverse().transform((IPoint)pt, null);
        Class clazz = class$javax$baja$ui$BWidget;
        if (clazz == null) {
            clazz = class$javax$baja$ui$BWidget = BCanvasPane.class("[Ljavax.baja.ui.BWidget;", false);
        }
        Array arr = new Array(clazz);
        BWidget[] children = this.getChildWidgets();
        int i = children.length - 1;
        while (i >= 0) {
            BWidget child = children[i];
            if (child.isVisible() && child.contains(pt.x - child.getX(), pt.y - child.getY())) {
                arr.add((Object)child);
            }
            --i;
        }
        if (arr.size() == 0) {
            return null;
        }
        return (BWidget[])arr.trim();
    }

    public Point translateToChild(BWidget child, Point pt) {
        pt = this.scaleTransform.getInverse().transform((IPoint)pt, pt);
        return super.translateToChild(child, pt);
    }

    public Point translateFromChild(BWidget child, Point pt) {
        pt.x += child.getX();
        pt.y += child.getY();
        pt = this.scaleTransform.transform((IPoint)pt, pt);
        return pt;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paint(Graphics g) {
        BBrush brush = this.getBackground();
        if (!brush.isNull()) {
            g.setBrush(brush);
            g.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        }
        g.push();
        try {
            g.transform(this.scaleTransform);
            g.clip(0.0, 0.0, this.getViewSize().width + 1.0, this.getViewSize().height + 1.0);
            if (this.paintGraphPaper) {
                this.graphPaper.fillRect(g, this.dx < 0.0 ? -this.dx * this.sx : 0.0, this.dy < 0.0 ? -this.dy * this.sy : 0.0, this.getWidth() / this.sx, this.getHeight() / this.sy);
            }
            boolean bl = false;
            if (this.paintHatching && this.hatchable()) {
                bl = true;
            }
            this.paintKids(g, bl);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            g.pop();
            throw throwable;
        }
        {
            Object var4_5 = null;
        }
        g.pop();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void paintKids(Graphics g, boolean hatch) {
        IGeom clip = g.getClip();
        BWidget[] children = this.getChildWidgets();
        int i = 0;
        while (true) {
            block8: {
                Object var16_11;
                if (i >= children.length) {
                    return;
                }
                BWidget child = children[i];
                if (!child.isVisible()) break block8;
                double x = child.getX();
                double y = child.getY();
                double width = child.getWidth();
                double height = child.getHeight();
                if (!this.overrideClip && !clip.intersects(x, y, width, height)) break block8;
                g.push();
                try {
                    try {
                        g.clip(x, y, width, height);
                        g.translate(x, y);
                        child.paint(g);
                        if (hatch && !(child instanceof BShape)) {
                            g.transform(BTransform.makeScale((double)this.sx, (double)this.sy));
                            this.hatching.fillRect(g, this.dx + x < 0.0 ? -(this.dx + x) * this.sx : 0.0, this.dy + y < 0.0 ? -(this.dy + y) * this.sy : 0.0, width / this.sx, height / this.sy);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    var16_11 = null;
                    g.pop();
                    throw throwable;
                }
                {
                    var16_11 = null;
                }
                g.pop();
            }
            ++i;
        }
    }

    private final boolean hatchable() {
        BWidget parent = this.getParentWidget();
        while (parent != null) {
            BLabelPane tab;
            BTabbedPane pane;
            if (parent instanceof BCanvasPane) {
                return false;
            }
            if (parent instanceof BLabelPane && parent.getParentWidget() instanceof BTabbedPane && (pane = (BTabbedPane)(tab = (BLabelPane)parent).getParentWidget()).getSelectedLabelPane() != tab) {
                return false;
            }
            parent = parent.getParentWidget();
        }
        return true;
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 304) {
            Object[] gp = (Object[])a;
            this.paintGraphPaper = (Boolean)gp[0];
            if (this.paintGraphPaper) {
                if (this.graphPaper == null) {
                    this.graphPaper = GxEnv.get().makeGraphPaper();
                }
                this.graphPaper.setSize(((Integer)gp[1]).intValue());
                this.graphPaper.setColor((BColor)gp[2]);
            }
            Object[] ha = (Object[])b;
            this.paintHatching = (Boolean)ha[0];
            if (this.paintHatching) {
                if (this.hatching == null) {
                    this.hatching = GxEnv.get().makeHatching();
                }
                this.hatching.setColor((BColor)ha[1]);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    public BIcon getIcon() {
        return icon;
    }

    public BTransform getScaleTransform() {
        return this.scaleTransform;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.overrideClip = false;
        this.scaleTransform = BTransform.DEFAULT;
    }

    public BCanvasPane() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$ui$pane$BCanvasPane;
        if (clazz == null) {
            clazz = class$javax$baja$ui$pane$BCanvasPane = BCanvasPane.class("[Ljavax.baja.ui.pane.BCanvasPane;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"widgets/canvasPane.png");
    }
}

