/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.list;

import java.util.BitSet;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListSubject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ListSelection
extends BList.ListSupport {
    private BitSet bits;
    private int lead;
    private int anchor;

    public boolean isSelected(int index) {
        return this.bits.get(index);
    }

    public void selectAll() {
        int count = this.getModel().getItemCount();
        if (count > 0) {
            this.select(0, count - 1);
        }
    }

    public void select(int index) {
        this.select(index, false);
    }

    public void select(int index, boolean clear) {
        if (clear || index < 0) {
            this.bits = new BitSet(this.bits.size());
        }
        if (index >= 0) {
            this.bits.set(index);
            this.anchor = this.lead = index;
        }
        this.updateList();
    }

    public void select(int anchor, int lead) {
        this.select(anchor, lead, false);
    }

    public void select(int anchor, int lead, boolean clear) {
        this.anchor = anchor;
        this.lead = lead;
        int end = lead;
        int start = anchor;
        if (end < start) {
            int temp = start;
            start = end;
            end = temp;
        }
        int r = start;
        while (r <= end) {
            this.bits.set(r);
            ++r;
        }
        this.updateList();
    }

    public void select(int[] indices) {
        this.bits = new BitSet(this.bits.size());
        if (indices.length == 0) {
            return;
        }
        this.anchor = indices[0];
        this.lead = indices[indices.length - 1];
        int i = 0;
        while (i < indices.length) {
            this.bits.set(indices[i]);
            ++i;
        }
        this.updateList();
    }

    public void deselect(int index) {
        this.bits.clear(index);
        this.anchor = this.lead = index;
        this.updateList();
    }

    public void deselectAll() {
        this.bits = new BitSet(this.bits.size());
        this.updateList();
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.getItemCount() == 0) {
            bl = true;
        }
        return bl;
    }

    public int getItemCount() {
        int count = this.bits.size();
        int n = 0;
        int i = 0;
        while (i < count) {
            if (this.bits.get(i)) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public int getItem() {
        int r = 0;
        while (r < this.bits.size()) {
            if (this.bits.get(r)) {
                return r;
            }
            ++r;
        }
        return -1;
    }

    public int[] getItems() {
        int itemCount = this.getList().getModel().getItemCount();
        int[] temp = new int[itemCount];
        int n = 0;
        int r = 0;
        while (r < itemCount) {
            if (this.bits.get(r)) {
                temp[n++] = r;
            }
            ++r;
        }
        int[] result = new int[n];
        System.arraycopy(temp, 0, result, 0, n);
        return result;
    }

    public final ListSubject getSubject() {
        return this.getSubject(this.lead);
    }

    public ListSubject getSubject(int activeIndex) {
        return new ListSubject(this.getList(), this.getItems(), activeIndex);
    }

    public int getAnchor() {
        return this.anchor;
    }

    public int getLead() {
        return this.lead;
    }

    public void updateList() {
        BList list = this.getList();
        if (list != null) {
            list.repaint();
            this.getList().fireSelectionModified(new BWidgetEvent(1, this.getList()));
        }
    }

    private final /* synthetic */ void this() {
        this.bits = new BitSet();
        this.lead = -1;
        this.anchor = -1;
    }

    public ListSelection() {
        this.this();
    }
}

