/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.theme.Theme;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.SingleLineParser;

public class BTextField
extends BTextEditor {
    public static final Property visibleColumns = BTextField.newProperty((int)0, (int)20, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)));
    public static final Property expandHeight = BTextField.newProperty((int)0, (boolean)false, null);
    public static final Topic actionPerformed = BTextField.newTopic((int)0, null);
    public static final Topic cancelled = BTextField.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$BTextField == null ? (class$javax$baja$ui$BTextField = BTextField.class$("javax.baja.ui.BTextField")) : class$javax$baja$ui$BTextField));
    private static final BIcon icon = BIcon.std((String)"widgets/textField.png");
    private static BInsets dropDownInsets = BInsets.make((double)1.0, (double)1.0, (double)1.0, (double)1.0);
    private double scrollOffset;
    private boolean consumeActionKeyEvent;
    static /* synthetic */ Class class$javax$baja$ui$BTextField;

    public int getVisibleColumns() {
        return this.getInt(visibleColumns);
    }

    public void setVisibleColumns(int v) {
        this.setInt(visibleColumns, v, null);
    }

    public boolean getExpandHeight() {
        return this.getBoolean(expandHeight);
    }

    public void setExpandHeight(boolean v) {
        this.setBoolean(expandHeight, v, null);
    }

    public void fireActionPerformed(BWidgetEvent event) {
        this.fire(actionPerformed, (BValue)event, null);
    }

    public void fireCancelled(BWidgetEvent event) {
        this.fire(cancelled, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BTextField(String text, int visibleColumns, boolean editable) {
        super(text, editable);
        this.setVisibleColumns(visibleColumns);
        this.initTextField();
    }

    public BTextField(String text, int visibleColumns) {
        super(text, true);
        this.setVisibleColumns(visibleColumns);
        this.initTextField();
    }

    public BTextField(String text) {
        super(text, true);
        this.initTextField();
    }

    public BTextField() {
        this.initTextField();
    }

    private void initTextField() {
        this.setParser(new SingleLineParser());
    }

    public boolean isSingleLine() {
        return true;
    }

    public void scrollToVisible(Position pos) {
        BInsets insets = Theme.textField().getInsets();
        Line line = this.getRenderer().getModel().getLine(pos.line);
        double lineWidth = this.getRenderer().getLineWidth(line, 0, pos.column);
        double dx1 = lineWidth - insets.left;
        int index = pos.column > 0 ? 1 : 0;
        double cellWidth = this.getRenderer().getColumnWidth(line, pos.column - index);
        double dx2 = dx1 + cellWidth;
        double cx1 = this.scrollOffset;
        double width = this.getWidth() - insets.left - insets.right;
        double cx2 = cx1 + width;
        if (cx2 < dx2) {
            cx1 += dx2 - cx2;
        }
        if (cx1 > dx1) {
            cx1 = dx1;
        }
        if (cx1 < 0.0) {
            cx1 = 0.0;
        }
        this.scrollOffset = cx1;
        this.repaint();
    }

    public Position getPositionAt(double x, double y) {
        return super.getPositionAt(x + this.scrollOffset, y);
    }

    public void computePreferredSize() {
        double cellHeight = this.getRenderer().getLineHeight();
        double cellWidth = this.getRenderer().getColumnWidth(null, 0);
        BInsets insets = this.getInsets();
        double pw = cellWidth * (double)this.getVisibleColumns() + insets.left + insets.right;
        double ph = cellHeight + insets.top + insets.bottom;
        this.setPreferredSize(pw, ph);
    }

    protected BInsets getInsets() {
        if (this.getParent() instanceof BDropDown) {
            return dropDownInsets;
        }
        return Theme.textField().getInsets();
    }

    public void paint(Graphics g) {
        BInsets insets = this.getInsets();
        double ph = this.getRenderer().getLineHeight() + insets.top + insets.bottom;
        double ty = 0.0;
        if (this.getExpandHeight()) {
            g.setBrush(Theme.textField().getTextBackground(this));
            g.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
            ty = (this.getHeight() - ph) / 2.0;
        }
        g.translate(-this.scrollOffset, ty);
        super.paint(g);
        g.translate(this.scrollOffset, -ty);
        if (!(this.getParent() instanceof BDropDown)) {
            this.paintBorder(g);
        }
    }

    protected void paintBorder(Graphics g) {
        double h = this.getHeight();
        if (!this.getExpandHeight()) {
            BInsets insets = this.getInsets();
            h = this.getRenderer().getLineHeight() + insets.top + insets.bottom;
        }
        Theme.textField().paintBorder(g, this, this.getWidth(), h);
    }

    public void setConsumeActionKeyEvent(boolean consume) {
        this.consumeActionKeyEvent = consume;
    }

    public void keyPressed(BKeyEvent event) {
        if (event.getKeyCode() != 10 && event.getKeyCode() != 27) {
            if (event.getKeyCode() == 40) {
                BComplex parent = this.getParent();
                if (parent instanceof BTextDropDown) {
                    ((BTextDropDown)parent).openDropDown();
                }
            } else {
                super.keyPressed(event);
            }
        }
    }

    public void keyTyped(BKeyEvent event) {
        char key = event.getKeyChar();
        if (key == '\n' || key == '\r') {
            return;
        }
        if (event.getKeyCode() == 27) {
            return;
        }
        super.keyTyped(event);
    }

    public void keyReleased(BKeyEvent event) {
        if (event.getKeyCode() == 10) {
            this.fireActionPerformed(new BWidgetEvent(2, this));
            if (this.consumeActionKeyEvent) {
                event.consume();
            }
        } else if (event.getKeyCode() == 27) {
            this.fireCancelled(new BWidgetEvent(2, this));
            if (this.consumeActionKeyEvent) {
                event.consume();
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

