/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BProgressBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.commands.ReflectCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.util.UiLexicon;

public class BProgressDialog
extends BDialog {
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$BProgressDialog == null ? (class$javax$baja$ui$BProgressDialog = BProgressDialog.class$("javax.baja.ui.BProgressDialog")) : class$javax$baja$ui$BProgressDialog));
    final UiLexicon lex = UiLexicon.bajaui();
    Worker worker;
    BLabel icon;
    BLabel message = new BLabel("");
    BProgressBar progress = new BProgressBar();
    BButton button = new BButton(new ReflectCommand((BWidget)this, this.lex.getText("dialog.cancel"), "cancel"));
    static /* synthetic */ Class class$javax$baja$ui$BProgressDialog;

    public Type getType() {
        return TYPE;
    }

    public static void open(BWidget owner, String title, Worker worker, BImage icon, int min, int max) {
        BProgressDialog dialog = new BProgressDialog(owner, title, worker, icon, min, max);
        dialog.setBoundsCenteredOnOwner();
        worker.dialog = dialog;
        worker.start();
        dialog.open();
    }

    public static void open(BWidget owner, String title, Worker worker, BImage icon) {
        BProgressDialog.open(owner, title, worker, icon, 0, 100);
    }

    public static void open(BWidget owner, String title, Worker worker) {
        BProgressDialog.open(owner, title, worker, BImage.NULL, 0, 100);
    }

    private BProgressDialog(BWidget owner, String title, Worker worker, BImage iconImage, double min, double max) {
        super(owner, title, true);
        this.worker = worker;
        this.icon = new BLabel(iconImage);
        this.message.setHalign(BHalign.left);
        this.progress.setMin(min);
        this.progress.setMax(max);
        this.add("icon", (BValue)this.icon);
        this.add("message", (BValue)this.message);
        this.add("progress", (BValue)this.progress);
        this.add("button", (BValue)this.button);
    }

    public BProgressDialog() {
    }

    public BLabel getMessageLabel() {
        return this.message;
    }

    public BProgressBar getProgressBar() {
        return this.progress;
    }

    public void computePreferredSize() {
        this.icon.computePreferredSize();
        this.message.computePreferredSize();
        this.progress.computePreferredSize();
        this.button.computePreferredSize();
        double iw = this.icon.getPreferredWidth();
        double ih = this.icon.getPreferredHeight();
        double mw = this.message.getPreferredWidth();
        double mh = this.message.getPreferredHeight();
        double pw = this.progress.getPreferredWidth();
        double ph = this.progress.getPreferredHeight();
        double bw = this.button.getPreferredWidth();
        double bh = this.button.getPreferredHeight();
        if (ih < 45.0) {
            ih = 45.0;
        }
        if (mh < 45.0) {
            mh = 18.0;
        }
        pw = 5.0 + iw + 5.0 + pw + 5.0;
        ph = 5.0 + Math.max(ih, mh + 5.0 + ph) + 5.0 + bh + 5.0;
        this.setPreferredSize(pw, ph);
    }

    public void doLayout(BWidget[] kids) {
        double w = this.getWidth();
        double h = this.getHeight();
        this.computePreferredSize();
        double iw = this.icon.getPreferredWidth();
        double ih = this.icon.getPreferredHeight();
        double mw = this.message.getPreferredWidth();
        double mh = this.message.getPreferredHeight();
        double pw = this.progress.getPreferredWidth();
        double ph = this.progress.getPreferredHeight();
        double bw = this.button.getPreferredWidth();
        double bh = this.button.getPreferredHeight();
        if (ih < 45.0) {
            ih = 45.0;
        }
        if (mh < 45.0) {
            mh = 18.0;
        }
        double ax = 5.0 + iw + 5.0;
        double ay = 5.0 + (ih - (mh + 5.0 + ph)) / 2.0;
        this.message.setBounds(ax, ay, w - ax - 5.0, mh);
        this.progress.setBounds(ax, ay + mh + 5.0, w - ax - 5.0, ph);
        this.icon.setBounds(5.0, 5.0, iw, ih);
        this.button.setBounds((w - bw) / 2.0, h - bh - 5.0, bw, bh);
    }

    public void windowClosing(BWindowEvent event) {
        this.cancel();
    }

    public void cancel() {
        if (!this.worker.done) {
            this.worker.cancel();
        }
        this.close();
    }

    public void paint(Graphics g) {
        if (this.worker.done) {
            this.close();
        }
        super.paint(g);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static abstract class Worker
    extends Thread {
        BProgressDialog dialog;
        boolean done = false;

        public Worker() {
            super("ProgressDialog.Worker");
        }

        public BProgressDialog getDialog() {
            return this.dialog;
        }

        public final void run() {
            try {
                this.doRun();
            }
            catch (Throwable e) {
                e.printStackTrace();
                BDialog.error(this.dialog, "Worker failed", e);
            }
            this.done = true;
            this.dialog.repaint();
        }

        public final void cancel() {
            try {
                this.doCancel();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.done = true;
            this.dialog.repaint();
        }

        public abstract void doRun() throws Exception;

        public abstract void doCancel() throws Exception;

        public void updateProgress(int progressValue, String message) {
            this.updateProgress(message);
            this.updateProgress(progressValue);
        }

        public void updateProgress(String message) {
            this.dialog.message.setText(message);
            this.dialog.message.relayout();
        }

        public void updateProgress(int progressValue) {
            this.dialog.progress.setValue(progressValue);
            this.dialog.repaint();
        }
    }
}

