/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.gx.awt.AwtGraphics;
import com.tridium.gx.awt.AwtImagePeer;
import com.tridium.gx.awt.ImageManager;
import java.awt.Graphics2D;
import javax.baja.gx.BImage;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.log.Log;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScaleMode;
import javax.baja.ui.enums.BValign;

public class BPicture
extends BWidget {
    public static final Property image = BPicture.newProperty((int)0, (BValue)BImage.NULL, null);
    public static final Property scale = BPicture.newProperty((int)0, (BValue)BScaleMode.none, null);
    public static final Property halign = BPicture.newProperty((int)0, (BValue)BHalign.center, null);
    public static final Property valign = BPicture.newProperty((int)0, (BValue)BValign.center, null);
    public static final Property animate = BPicture.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$BPicture == null ? (class$javax$baja$ui$BPicture = BPicture.class$("javax.baja.ui.BPicture")) : class$javax$baja$ui$BPicture));
    private static final BIcon icon = BIcon.std((String)"widgets/image.png");
    private static final Log LOG = Log.getLog((String)"bajaui");
    private BTransform.Scale transScale;
    protected double dx;
    protected double dy;
    private AwtImagePeer picturePeer;
    private boolean imageWasScaled = false;
    private BOrdList lastImageOrdList = null;
    static /* synthetic */ Class class$javax$baja$ui$BPicture;

    public BImage getImage() {
        return (BImage)this.get(image);
    }

    public void setImage(BImage v) {
        this.set(image, (BValue)v, null);
    }

    public BScaleMode getScale() {
        return (BScaleMode)this.get(scale);
    }

    public void setScale(BScaleMode v) {
        this.set(scale, (BValue)v, null);
    }

    public BHalign getHalign() {
        return (BHalign)this.get(halign);
    }

    public void setHalign(BHalign v) {
        this.set(halign, (BValue)v, null);
    }

    public BValign getValign() {
        return (BValign)this.get(valign);
    }

    public void setValign(BValign v) {
        this.set(valign, (BValue)v, null);
    }

    public boolean getAnimate() {
        return this.getBoolean(animate);
    }

    public void setAnimate(boolean v) {
        this.setBoolean(animate, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property prop, Context context) {
        this.picturePeer = null;
        this.relayout();
        super.changed(prop, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        this.wipePreviousPeer();
        BImage image = this.getImage();
        if (image.isNull() || !this.ensurePeer().isLoaded() || !this.isImageReadyToScale()) {
            return;
        }
        if (g instanceof AwtGraphics) {
            g.push();
            try {
                g.translate(this.dx, this.dy);
                Graphics2D g2d = ((AwtGraphics)g).getAwtGraphics();
                g2d.drawImage(this.ensurePeer().image(), 0, 0, null);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                g.pop();
            }
        } else {
            LOG.warning("cannot render " + image + " to graphics context " + g.getClass().getName());
        }
    }

    public void computePreferredSize() {
        BImage image = this.getImage();
        if (image.isNull() || !image.isLoaded()) {
            this.setPreferredSize(0.0, 0.0);
        } else {
            this.setPreferredSize(image.getWidth(), image.getHeight());
        }
    }

    public void doLayout(BWidget[] kids) {
        if (!this.wipePreviousPeer()) {
            BPicture.doScaleLayout(this);
        }
        this.ensurePeer();
    }

    public void animate() {
        if (!this.getAnimate()) {
            return;
        }
        BImage image = this.getImage();
        if (image.isNull() || !this.ensurePeer().isLoaded()) {
            return;
        }
        if (this.ensurePeer().animate()) {
            this.picturePeer = null;
            this.repaint();
        }
    }

    private boolean wipePreviousPeer() {
        BImage image = this.getImage();
        boolean wipePeer = false;
        if (this.lastImageOrdList != null && !this.lastImageOrdList.equals((Object)image.getOrdList())) {
            wipePeer = true;
        }
        this.lastImageOrdList = image.getOrdList();
        if (!this.imageWasScaled && this.isImageReadyToScale()) {
            wipePeer = true;
        }
        if (wipePeer) {
            this.picturePeer = null;
        }
        return wipePeer;
    }

    public boolean isImageReadyToScale() {
        BImage image = this.getImage();
        return !image.isNull() && image.isLoaded() && this.getWidth() > 0.0 && this.getHeight() > 0.0;
    }

    private static void doScaleLayout(BPicture pic) {
        double dy;
        double dx;
        BImage image = pic.getImage();
        BTransform.Scale transScale = null;
        pic.imageWasScaled = pic.isImageReadyToScale();
        if (!pic.imageWasScaled) {
            dx = 0.0;
            dy = 0.0;
            transScale = null;
        } else {
            double w = pic.getWidth();
            double h = pic.getHeight();
            double iw = image.getWidth();
            double ih = image.getHeight();
            double sx = 0.0;
            double sy = 0.0;
            BHalign halign = pic.getHalign();
            BValign valign = pic.getValign();
            BScaleMode picScale = pic.getScale();
            switch (picScale.getOrdinal()) {
                case 1: {
                    sx = w / iw;
                    sy = h / ih;
                    dy = 0.0;
                    dx = 0.0;
                    break;
                }
                case 2: {
                    sx = sy = Math.min(w / iw, h / ih);
                    if (sx == w / iw) {
                        dx = 0.0;
                        dy = BPicture.doValign(valign, h, ih * sx);
                        break;
                    }
                    dx = BPicture.doHalign(halign, w, iw * sx);
                    dy = 0.0;
                    break;
                }
                case 3: {
                    sx = w / iw;
                    sy = 1.0;
                    dx = 0.0;
                    dy = BPicture.doValign(valign, h, ih);
                    break;
                }
                case 4: {
                    sx = 1.0;
                    sy = h / ih;
                    dx = BPicture.doHalign(halign, w, iw);
                    dy = 0.0;
                    break;
                }
                case 0: {
                    dx = BPicture.doHalign(halign, w, iw);
                    dy = BPicture.doValign(valign, h, ih);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            dx = Math.floor(dx);
            dy = Math.floor(dy);
            transScale = picScale.equals((Object)BScaleMode.none) ? null : new BTransform.Scale(sx, sy);
        }
        pic.dx = dx;
        pic.dy = dy;
        pic.transScale = transScale;
    }

    public static AwtImagePeer createPeer(BPicture pic) {
        BPicture.doScaleLayout(pic);
        AwtImagePeer picturePeer = new AwtImagePeer(ImageManager.fetchImageData((BImage)pic.getImage(), (BTransform.Scale)pic.transScale));
        picturePeer.data.repaintOnLoad = true;
        return picturePeer;
    }

    protected AwtImagePeer ensurePeer() {
        if (this.picturePeer == null) {
            this.picturePeer = BPicture.createPeer(this);
        }
        return this.picturePeer;
    }

    private static double doHalign(BHalign halign, double w, double dw) {
        if (halign == BHalign.left) {
            return 0.0;
        }
        if (halign == BHalign.center) {
            return (w - dw) / 2.0;
        }
        return w - dw - 1.0;
    }

    private static double doValign(BValign valign, double h, double dh) {
        if (valign == BValign.top) {
            return 0.0;
        }
        if (valign == BValign.center) {
            return (h - dh) / 2.0;
        }
        return h - dh - 1.0;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

