/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.gx.parser.Parser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BLayout
extends BSimple {
    public static final int ABS = 0;
    public static final int PERCENT = 1;
    public static final int PREF = 2;
    public static final BLayout FILL;
    public static final BLayout DEFAULT;
    public static final Type TYPE;
    double x;
    double y;
    double w;
    double h;
    int xUnit;
    int yUnit;
    int wUnit;
    int hUnit;
    String string;
    static /* synthetic */ Class class$javax$baja$ui$BLayout;

    public static BLayout make(double x, int xUnit, double y, int yUnit, double w, int wUnit, double h, int hUnit) {
        if (!(BLayout.isXY(xUnit) && BLayout.isXY(yUnit) && BLayout.isWH(wUnit) && BLayout.isWH(hUnit))) {
            throw new IllegalArgumentException();
        }
        BLayout layout = new BLayout();
        layout.x = x;
        layout.y = y;
        layout.w = w;
        layout.h = h;
        layout.xUnit = xUnit;
        layout.yUnit = yUnit;
        layout.wUnit = wUnit;
        layout.hUnit = hUnit;
        return layout;
    }

    public static BLayout makeAbs(double x, double y, double w, double h) {
        return BLayout.make(x, 0, y, 0, w, 0, h, 0);
    }

    static boolean isXY(int unit) {
        return unit == 0 || unit == 1;
    }

    static boolean isWH(int unit) {
        return unit == 0 || unit == 1 || unit == 2;
    }

    public static BLayout make(String s) {
        try {
            Parser parser = new Parser(s);
            BLayout layout = new BLayout();
            if (parser.cur.id("fill")) {
                return FILL;
            }
            layout.x = parser.cur.num;
            if (parser.cur.num()) {
                layout.xUnit = 0;
            } else if (parser.cur.dimen("%")) {
                layout.xUnit = 1;
            } else {
                throw new Exception();
            }
            parser.consume();
            parser.match(2);
            layout.y = parser.cur.num;
            if (parser.cur.num()) {
                layout.yUnit = 0;
            } else if (parser.cur.dimen("%")) {
                layout.yUnit = 1;
            } else {
                throw new Exception();
            }
            parser.consume();
            parser.match(2);
            layout.w = parser.cur.num;
            if (parser.cur.num()) {
                layout.wUnit = 0;
            } else if (parser.cur.dimen("%")) {
                layout.wUnit = 1;
            } else if (parser.cur.id("pref")) {
                layout.wUnit = 2;
            } else {
                throw new Exception();
            }
            parser.consume();
            parser.match(2);
            layout.h = parser.cur.num;
            if (parser.cur.num()) {
                layout.hUnit = 0;
            } else if (parser.cur.dimen("%")) {
                layout.hUnit = 1;
            } else if (parser.cur.id("pref")) {
                layout.hUnit = 2;
            } else {
                throw new Exception();
            }
            return layout;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(s);
        }
    }

    private BLayout() {
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.w;
    }

    public double getHeight() {
        return this.h;
    }

    public int getXUnit() {
        return this.xUnit;
    }

    public int getYUnit() {
        return this.yUnit;
    }

    public int getWidthUnit() {
        return this.wUnit;
    }

    public int getHeightUnit() {
        return this.hUnit;
    }

    public int hashCode() {
        long hash = 23L + Double.doubleToRawLongBits(this.x);
        hash = hash * 37L + Double.doubleToRawLongBits(this.y);
        hash = hash * 37L + Double.doubleToRawLongBits(this.w);
        hash = hash * 37L + Double.doubleToRawLongBits(this.h);
        hash = hash * 37L + (long)this.xUnit;
        hash = hash * 37L + (long)this.yUnit;
        hash = hash * 37L + (long)this.wUnit;
        hash = hash * 37L + (long)this.hUnit;
        return (int)(hash >>> 32) ^ (int)hash;
    }

    public boolean equals(Object object) {
        if (object instanceof BLayout) {
            BLayout o = (BLayout)((Object)object);
            return this.x == o.x && this.y == o.y && this.w == o.w && this.h == o.h && this.xUnit == o.xUnit && this.yUnit == o.yUnit && this.wUnit == o.wUnit && this.hUnit == o.hUnit;
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return BLayout.make(in.readUTF());
    }

    public String encodeToString() {
        if (this.string == null) {
            if (this == FILL) {
                return "fill";
            }
            StringBuffer s = new StringBuffer();
            s.append(BDouble.encode((double)this.x));
            if (this.xUnit == 1) {
                s.append('%');
            }
            s.append(',');
            s.append(BDouble.encode((double)this.y));
            if (this.yUnit == 1) {
                s.append('%');
            }
            s.append(',');
            if (this.wUnit == 2) {
                s.append("pref");
            } else {
                s.append(BDouble.encode((double)this.w));
                if (this.wUnit == 1) {
                    s.append('%');
                }
            }
            s.append(',');
            if (this.hUnit == 2) {
                s.append("pref");
            } else {
                s.append(BDouble.encode((double)this.h));
                if (this.hUnit == 1) {
                    s.append('%');
                }
            }
            this.string = s.toString();
        }
        return this.string;
    }

    public BObject decodeFromString(String s) throws IOException {
        return BLayout.make(s);
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        DEFAULT = FILL = BLayout.make(0.0, 0, 0.0, 0, 100.0, 1, 100.0, 1);
        TYPE = Sys.loadType((Class)(class$javax$baja$ui$BLayout == null ? (class$javax$baja$ui$BLayout = BLayout.class$("javax.baja.ui.BLayout")) : class$javax$baja$ui$BLayout));
    }
}

