/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.theme.LabelTheme;
import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BAlign;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;

public class BLabel
extends BWidget {
    public static final Property text = BLabel.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Property image = BLabel.newProperty((int)0, (BValue)BImage.NULL, null);
    public static final Property font = BLabel.newProperty((int)0, (BValue)BFont.NULL, null);
    public static final Property foreground = BLabel.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Property background = BLabel.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Property halign = BLabel.newProperty((int)0, (BValue)BHalign.center, null);
    public static final Property valign = BLabel.newProperty((int)0, (BValue)BValign.center, null);
    public static final Property textToIconAlign = BLabel.newProperty((int)0, (BValue)BAlign.right, null);
    public static final Property textIconGap = BLabel.newProperty((int)0, (int)4, null);
    public static final Property blink = BLabel.newProperty((int)0, (boolean)false, null);
    public static final Property wordWrapEnabled = BLabel.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$BLabel == null ? (class$javax$baja$ui$BLabel = BLabel.class$("javax.baja.ui.BLabel")) : class$javax$baja$ui$BLabel));
    private static final BIcon icon = BIcon.std((String)"widgets/label.png");
    private static final BIcon imageIcon = BIcon.std((String)"widgets/image.png");
    BInsets padding = BInsets.NULL;
    Layout layout = this.createLayout();
    boolean forceLayout;
    int blinkFrame = 2;
    static /* synthetic */ Class class$javax$baja$ui$BLabel;

    public String getText() {
        return this.getString(text);
    }

    public void setText(String v) {
        this.setString(text, v, null);
    }

    public BImage getImage() {
        return (BImage)this.get(image);
    }

    public void setImage(BImage v) {
        this.set(image, (BValue)v, null);
    }

    public BFont getFont() {
        return (BFont)this.get(font);
    }

    public void setFont(BFont v) {
        this.set(font, (BValue)v, null);
    }

    public BBrush getForeground() {
        return (BBrush)this.get(foreground);
    }

    public void setForeground(BBrush v) {
        this.set(foreground, (BValue)v, null);
    }

    public BBrush getBackground() {
        return (BBrush)this.get(background);
    }

    public void setBackground(BBrush v) {
        this.set(background, (BValue)v, null);
    }

    public BHalign getHalign() {
        return (BHalign)this.get(halign);
    }

    public void setHalign(BHalign v) {
        this.set(halign, (BValue)v, null);
    }

    public BValign getValign() {
        return (BValign)this.get(valign);
    }

    public void setValign(BValign v) {
        this.set(valign, (BValue)v, null);
    }

    public BAlign getTextToIconAlign() {
        return (BAlign)this.get(textToIconAlign);
    }

    public void setTextToIconAlign(BAlign v) {
        this.set(textToIconAlign, (BValue)v, null);
    }

    public double getTextIconGap() {
        return this.getDouble(textIconGap);
    }

    public void setTextIconGap(double v) {
        this.setDouble(textIconGap, v, null);
    }

    public boolean getBlink() {
        return this.getBoolean(blink);
    }

    public void setBlink(boolean v) {
        this.setBoolean(blink, v, null);
    }

    public boolean getWordWrapEnabled() {
        return this.getBoolean(wordWrapEnabled);
    }

    public void setWordWrapEnabled(boolean v) {
        this.setBoolean(wordWrapEnabled, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BLabel(BImage image, String text) {
        if (image != null) {
            this.setImage(image);
        }
        this.setText(text);
    }

    public BLabel(String text) {
        this.setText(text);
    }

    public BLabel(BImage image) {
        if (image != null) {
            this.setImage(image);
        }
    }

    public BLabel(String text, BHalign hAlign) {
        this.setText(text);
        this.setHalign(hAlign);
    }

    public BLabel(String text, BValign vAlign) {
        this.setText(text);
        this.setValign(vAlign);
    }

    public BLabel(String text, BFont font) {
        this.setText(text);
        this.setFont(font);
    }

    public BLabel(BImage image, String text, BFont font) {
        if (image != null) {
            this.setImage(image);
        }
        this.setText(text);
        this.setFont(font);
    }

    public BLabel(BImage image, BHalign hAlign) {
        if (image != null) {
            this.setImage(image);
        }
        this.setHalign(hAlign);
    }

    public BLabel(BImage image, BValign vAlign) {
        if (image != null) {
            this.setImage(image);
        }
        this.setValign(vAlign);
    }

    public BLabel(String text, BFont font, BHalign hAlign) {
        this.setText(text);
        this.setFont(font);
        this.setHalign(hAlign);
    }

    public BLabel() {
    }

    public void setWordWrapEnabled(boolean enabled, double maxWidth) {
        this.setWordWrapEnabled(enabled);
        this.setSize(maxWidth, this.getHeight());
    }

    public void computePreferredSize() {
        Layout temp = this.createLayout();
        temp.computeBounds();
        BInsets padding = this.getPadding();
        temp.aw += padding.left + padding.right;
        temp.ah += padding.top + padding.bottom;
        this.setPreferredSize(temp.aw, temp.ah);
    }

    public void doLayout(BWidget[] kids) {
        this.forceLayout = false;
        double w = this.getWidth();
        double h = this.getHeight();
        BInsets padding = this.getPadding();
        this.layout.lines = null;
        this.layout.computeBounds();
        this.layout.computeAlignment(w -= padding.left + padding.right, h -= padding.top + padding.bottom);
        this.layout.xo += padding.left;
        this.layout.yo += padding.top;
    }

    public void changed(Property prop, Context context) {
        if (prop.equals(text)) {
            this.forceLayout = true;
            this.relayout();
        } else if (prop.equals(styleClasses)) {
            this.setImage(Theme.label().getIcon(this));
        }
        super.changed(prop, context);
    }

    public BInsets getPadding() {
        return this.padding;
    }

    public void setPadding(BInsets padding) {
        this.padding = padding;
    }

    public void paint(Graphics g) {
        String text;
        if (this.getBlink() && this.blinkFrame <= 1) {
            return;
        }
        if (this.forceLayout) {
            this.forceLayout = false;
            this.relayoutSync();
        }
        LabelTheme theme = this.theme();
        Layout q = this.layout;
        double tx = q.tx;
        double ty = q.ty;
        double tw = q.tw;
        double th = q.th;
        double ix = q.ix;
        double iy = q.iy;
        double xo = q.xo;
        double yo = q.yo;
        BFont font = this.getFont();
        if (font.isNull()) {
            font = this.theme().getTextFont(this);
        }
        BBrush background = this.getBackground();
        this.paintBackground(g, background);
        BImage image = theme.getIcon(this);
        if (this.layout.ipaint && !image.isNull()) {
            if (!this.isEnabled()) {
                image = image.getDisabledImage();
            }
            this.paintIcon(g, image, ix + xo, iy + yo);
        }
        if ((text = this.getText()).length() > 0 && q.lines != null) {
            BBrush brush = this.getForeground();
            if (brush.isNull()) {
                brush = theme.getTextBrush(this);
            }
            g.setBrush(brush);
            g.setFont(font);
            BHalign ha = this.getHalign();
            for (int i = 0; i < q.lines.length; ++i) {
                double ax = 0.0;
                if (ha == BHalign.center) {
                    ax = (tw - q.widths[i]) / 2.0;
                } else if (ha == BHalign.right) {
                    ax = tw - q.widths[i];
                }
                if (this.isEnabled()) {
                    this.paintText(g, q.lines[i], tx + xo + ax, ty + yo + (double)i * q.lineHeight);
                    continue;
                }
                theme.paintDisabledText(g, this, q.lines[i], tx + xo + ax, ty + yo + (double)i * q.lineHeight);
            }
        }
    }

    protected void paintIcon(Graphics g, BImage image, double x, double y) {
        g.drawImage(image, x, y);
    }

    protected void paintBackground(Graphics g, BBrush background) {
        if (!background.isNull() && !(this instanceof BAbstractButton)) {
            g.setBrush(background);
            g.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        }
    }

    protected void paintText(Graphics g, String text, double tx, double ty) {
        g.drawString(text, tx, ty);
    }

    public void animate() {
        BImage image = this.getImage();
        if (!image.isNull()) {
            if (!this.layout.iloaded && image.isLoaded()) {
                this.layout.iloaded = true;
                this.relayout();
            }
            if (image.animate()) {
                this.repaint();
            }
        }
        if (this.getBlink()) {
            this.blinkFrame = (this.blinkFrame + 1) % 8;
            if (this.blinkFrame == 0 || this.blinkFrame == 2) {
                this.repaint();
            }
        }
    }

    public String getStyleSelector() {
        return "label";
    }

    LabelTheme theme() {
        return Theme.label();
    }

    public BIcon getIcon() {
        return this.getImage().isNull() ? icon : imageIcon;
    }

    public boolean receiveInputEvents() {
        return this.hasBindings();
    }

    public String getDebugString() {
        return "\"" + this.getText() + "\"; ";
    }

    protected Layout createLayout() {
        return new Layout();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Layout {
        boolean valid;
        double tx;
        double ty;
        double tw;
        double th;
        double ix;
        double iy;
        double iw;
        double ih;
        double aw;
        double ah;
        double xo = 0.0;
        double yo = 0.0;
        boolean ipaint;
        boolean iloaded;
        double lineHeight;
        String[] lines = null;
        double[] widths = null;
        public static final String SOFT_DELIM = " \t";
        public static final String HARD_DELIM = "\n\r\f";
        public static final String ALL_DELIM = " \t\n\r\f";

        Layout() {
        }

        void computeAlignment(double w, double h) {
            switch (BLabel.this.getHalign().getOrdinal()) {
                case 0: {
                    this.xo = 0.0;
                    break;
                }
                case 1: {
                    this.xo = (w - this.aw) / 2.0;
                    break;
                }
                case 2: {
                    this.xo = w - this.aw;
                    break;
                }
                case 3: {
                    this.xo = (w - this.aw) / 2.0;
                }
            }
            switch (BLabel.this.getValign().getOrdinal()) {
                case 0: {
                    this.yo = 0.0;
                    break;
                }
                case 1: {
                    this.yo = (h - this.ah) / 2.0;
                    break;
                }
                case 2: {
                    this.yo = h - this.ah;
                    break;
                }
                case 3: {
                    this.yo = (h - this.ah) / 2.0;
                }
            }
        }

        void computeBounds() {
            this.computeImageBounds();
            this.computeTextBounds();
            if (this.tw > 0.0 && this.iw > 0.0) {
                this.computeCompoundLayout();
            } else {
                this.aw = Math.max(this.tw, this.iw);
                this.ah = Math.max(this.th, this.ih);
            }
        }

        private void computeTextBounds() {
            BFont font = BLabel.this.getFont();
            if (font.isNull()) {
                font = BLabel.this.theme().getTextFont(BLabel.this);
            }
            double fontHeight = font.getHeight();
            double fontDescent = font.getDescent();
            this.lineHeight = fontHeight;
            String text = BLabel.this.getText();
            if (text.length() == 0) {
                this.tw = 0.0;
                this.th = 0.0;
                return;
            }
            if (this.lines == null) {
                this.parse();
                this.widths = new double[this.lines.length];
            }
            this.tx = 0.0;
            this.ty = fontHeight - fontDescent;
            this.tw = 0.0;
            this.th = this.lineHeight * (double)this.lines.length;
            for (int i = 0; i < this.lines.length; ++i) {
                this.widths[i] = font.width(this.lines[i]);
                this.tw = Math.max(this.tw, this.widths[i]);
            }
        }

        private void computeImageBounds() {
            BImage image = BLabel.this.getImage();
            this.iy = 0.0;
            this.ix = 0.0;
            if (image.isNull() || !image.isLoaded()) {
                this.ipaint = false;
                this.iloaded = false;
            } else {
                this.ipaint = true;
                this.iloaded = true;
                this.iw = image.getWidth();
                this.ih = image.getHeight();
            }
        }

        private void computeCompoundLayout() {
            double gap = BLabel.this.getTextIconGap();
            this.aw = Math.max(this.tw, this.iw);
            this.ah = Math.max(this.th, this.ih);
            switch (BLabel.this.getTextToIconAlign().getOrdinal()) {
                case 0: {
                    this.tx += (this.aw - this.tw) / 2.0;
                    this.ix = (this.aw - this.iw) / 2.0;
                    this.iy = this.th + gap;
                    this.ah = this.th + gap + this.ih;
                    break;
                }
                case 2: {
                    this.tx += (this.aw - this.tw) / 2.0;
                    this.ix = (this.aw - this.iw) / 2.0;
                    this.ty += this.ih + gap;
                    this.ah = this.th + gap + this.ih;
                    break;
                }
                case 1: {
                    this.ty += (this.ah - this.th) / 2.0;
                    this.iy = (this.ah - this.ih) / 2.0;
                    this.ix = this.tw + gap;
                    this.aw = this.tw + gap + this.iw;
                    break;
                }
                case 3: {
                    this.ty += (this.ah - this.th) / 2.0;
                    this.iy = (this.ah - this.ih) / 2.0;
                    this.tx += this.iw + gap;
                    this.aw = this.tw + gap + this.iw;
                    break;
                }
                case 4: {
                    this.tx += (this.aw - this.tw) / 2.0;
                    this.ty += (this.ah - this.th) / 2.0;
                    this.ix = (this.aw - this.iw) / 2.0;
                    this.iy = (this.ah - this.ih) / 2.0;
                }
            }
        }

        protected void parse() {
            BFont font = BLabel.this.getFont();
            if (font.isNull()) {
                font = BLabel.this.theme().getTextFont(BLabel.this);
            }
            double w = BLabel.this.getWidth();
            boolean causedOverflow = false;
            if (this.iw > 0.0) {
                w = w - BLabel.this.getTextIconGap() - this.iw;
            }
            ArrayList<String> array = new ArrayList<String>();
            StringTokenizer st = BLabel.this.getWordWrapEnabled() ? new StringTokenizer(BLabel.this.getText(), ALL_DELIM, true) : new StringTokenizer(BLabel.this.getText(), HARD_DELIM, true);
            StringBuffer running = new StringBuffer();
            StringBuffer last = new StringBuffer();
            while (st.hasMoreTokens()) {
                String next = st.nextToken();
                if (BLabel.this.getWordWrapEnabled() && this.isSoftDelim(next)) {
                    last.append(next);
                    continue;
                }
                if (this.isHardDelim(next)) {
                    if (causedOverflow) continue;
                    array.add(running.toString());
                    last.setLength(0);
                    running.setLength(0);
                    continue;
                }
                double currentWidth = font.width(running.toString() + last + next);
                if (w > 0.0 && currentWidth > w) {
                    causedOverflow = true;
                    if (running.length() > 0) {
                        array.add(running.toString());
                    }
                    running.setLength(0);
                    if (font.width(next) > w) {
                        array.add(next);
                    } else if (next.length() > 0) {
                        running.append(next);
                    }
                } else {
                    causedOverflow = false;
                    running.append(last).append(next);
                }
                last.setLength(0);
            }
            if (running.length() > 0) {
                array.add(running.toString());
            }
            this.lines = array.toArray(new String[0]);
        }

        private boolean isSoftDelim(String text) {
            return SOFT_DELIM.indexOf(text) >= 0;
        }

        private boolean isHardDelim(String text) {
            return HARD_DELIM.indexOf(text) >= 0;
        }

        void dump() {
            System.out.println("  text:  " + this.tx + "," + this.ty + "," + this.tw + "," + this.th);
            System.out.println("  image: " + this.ix + "," + this.iy + "," + this.iw + "," + this.ih);
            System.out.println("  aggr:  " + this.aw + "," + this.ah);
            System.out.println("  off:   " + this.xo + "," + this.yo);
        }
    }
}

