/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.AbstractButtonTheme;
import com.tridium.ui.theme.LabelTheme;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IInsets;
import javax.baja.gx.IPoint;
import javax.baja.gx.Point;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;

public abstract class BAbstractButton
extends BLabel
implements BMenu.MenuCloseListener {
    public static final Property focusTraversable = BAbstractButton.newProperty((int)0, (boolean)true, null);
    public static final Property buttonStyle = BAbstractButton.newProperty((int)0, (BValue)BButtonStyle.normal, null);
    public static final Action invokeAction = BAbstractButton.newAction((int)0, null);
    public static final Topic actionPerformed = BAbstractButton.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$BAbstractButton == null ? (class$javax$baja$ui$BAbstractButton = BAbstractButton.class$("javax.baja.ui.BAbstractButton")) : class$javax$baja$ui$BAbstractButton));
    private boolean mouseOver = false;
    private boolean pressed = false;
    private boolean menuPressed = false;
    Command command;
    MenuController menuController;
    static /* synthetic */ Class class$javax$baja$ui$BAbstractButton;

    public boolean getFocusTraversable() {
        return this.getBoolean(focusTraversable);
    }

    public void setFocusTraversable(boolean v) {
        this.setBoolean(focusTraversable, v, null);
    }

    public BButtonStyle getButtonStyle() {
        return (BButtonStyle)this.get(buttonStyle);
    }

    public void setButtonStyle(BButtonStyle v) {
        this.set(buttonStyle, (BValue)v, null);
    }

    public void invokeAction() {
        this.invoke(invokeAction, null, null);
    }

    public void fireActionPerformed(BWidgetEvent event) {
        this.fire(actionPerformed, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BAbstractButton make(Command cmd, boolean useLabel, boolean useIcon) {
        if (cmd instanceof ToggleCommand) {
            return new BToggleButton((ToggleCommand)cmd, useLabel, useIcon);
        }
        return new BButton(cmd, useLabel, useIcon);
    }

    public static BAbstractButton make(Command cmd) {
        return BAbstractButton.make(cmd, true, true);
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public boolean isMenuPressed() {
        return this.menuPressed;
    }

    public IPoint getLabelOffset() {
        if (this.getButtonStyle() == BButtonStyle.hyperlink) {
            return new Point(0.0, 0.0);
        }
        return this.buttonTheme().getLabelOffset(this);
    }

    public double getMenuWidth() {
        if (this.getButtonStyle() == BButtonStyle.hyperlink) {
            return 0.0;
        }
        return this.buttonTheme().getMenuWidth();
    }

    public BInsets getPadding() {
        if (this.padding.isNull()) {
            if (this.getButtonStyle() == BButtonStyle.hyperlink) {
                return super.getPadding();
            }
            IInsets temp = this.buttonTheme().getPadding(this);
            return BInsets.make((IInsets)temp);
        }
        return this.padding;
    }

    public void paintBackground(Graphics g) {
        if (this.getButtonStyle() != BButtonStyle.none && this.getButtonStyle() != BButtonStyle.hyperlink) {
            this.buttonTheme().paintBackground(g, this);
        }
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command command, boolean useLabel, boolean useIcon) {
        if (this.command != null) {
            this.command.unregister(this);
        }
        if (command == null) {
            return;
        }
        if (useLabel && command.getLabel() != null) {
            this.setText(command.getLabel());
        }
        if (useIcon && command.getIcon() != null) {
            this.setImage(command.getIcon());
        }
        if (command.getKeyBase() != null) {
            this.setStyleId(command.getKeyBase().replace('.', '-'));
            this.setImage(Theme.button().getIcon(this));
        }
        this.command = command;
        command.register(this);
    }

    public MenuController getMenuController() {
        return this.menuController;
    }

    public void setMenuController(MenuController menuController) {
        this.menuController = menuController;
        this.relayout();
    }

    public void openMenu() {
        BMenu menu;
        if (this.menuController != null && (menu = this.menuController.getMenu(this)) != null) {
            this.openMenu(menu);
        }
    }

    public void openMenu(BMenu menu) {
        menu.open(this, 0.0, this.getHeight());
    }

    public void menuClosed(BMenu menu) {
        this.menuPressed = false;
        this.repaint();
    }

    public final void doInvokeAction() {
        this.doInvokeAction(null);
    }

    public void doInvokeAction(CommandEvent event) {
        this.fireActionPerformed(new BWidgetEvent(2, this));
        this.repaint();
    }

    public void computePreferredSize() {
        super.computePreferredSize();
        double pw = this.getPreferredWidth();
        double ph = this.getPreferredHeight();
        if (this.menuController != null) {
            pw += this.getMenuWidth();
        }
        this.setPreferredSize(pw, ph);
    }

    public void doLayout(BWidget[] children) {
        this.forceLayout = false;
        double w = this.getWidth();
        double h = this.getHeight();
        if (this.menuController != null) {
            w -= this.getMenuWidth();
        }
        BInsets padding = this.getPadding();
        this.layout.lines = null;
        this.layout.computeBounds();
        this.layout.computeAlignment(w -= padding.left() + padding.right(), h -= padding.top() + padding.bottom());
        this.layout.xo += padding.left();
        this.layout.yo += padding.top();
    }

    public void changed(Property prop, Context context) {
        if (prop == buttonStyle) {
            if (this.get(prop) == BButtonStyle.toolBar) {
                StyleUtils.addStyleClass(this, "toolbar");
                StyleUtils.removeStyleClass(this, "hyperlink");
            } else if (this.get(prop) == BButtonStyle.hyperlink) {
                StyleUtils.addStyleClass(this, "hyperlink");
                StyleUtils.removeStyleClass(this, "toolbar");
            } else {
                StyleUtils.removeStyleClass(this, "toolbar");
                StyleUtils.removeStyleClass(this, "hyperlink");
            }
        }
        super.changed(prop, context);
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        IPoint offset = this.getLabelOffset();
        g.translate(offset.x(), offset.y());
        super.paint(g);
    }

    public String getStyleSelector() {
        if (this.getButtonStyle() == BButtonStyle.hyperlink) {
            return "label";
        }
        return "button";
    }

    public boolean isFocusTraversable() {
        return this.getFocusTraversable();
    }

    public boolean receiveInputEvents() {
        return true;
    }

    public void keyPressed(BKeyEvent event) {
        if (event.getKeyCode() == 32) {
            event.consume();
            this.doInvokeAction(new CommandEvent(event));
        }
    }

    public void mousePressed(BMouseEvent event) {
        if (this.menuController != null && (!this.menuController.isMenuDistinct() || event.getX() > this.getWidth() - this.getMenuWidth())) {
            this.menuPressed = true;
            this.repaint();
            this.openMenu();
            return;
        }
        this.pressed = true;
        StyleUtils.addStyleClass(this, "pressed");
        this.repaint();
    }

    public void mouseReleased(BMouseEvent event) {
        if (this.mouseOver && !this.menuPressed) {
            this.doInvokeAction(new CommandEvent(event));
        }
        this.pressed = false;
        StyleUtils.removeStyleClass(this, "pressed");
        this.repaint();
    }

    public void mouseEntered(BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        String tip = this.getToolTip();
        if (shell != null && tip != null) {
            shell.showStatus(tip);
        }
        if (shell != null && this.getButtonStyle() == BButtonStyle.hyperlink) {
            this.setMouseCursor(MouseCursor.hand);
        }
        this.mouseOver = true;
        StyleUtils.addStyleClass(this, "hover");
        this.repaint();
    }

    public void mouseExited(BMouseEvent event) {
        UiEnv.get().closeBubbleHelp();
        BWidgetShell shell = this.getShell();
        if (shell != null) {
            shell.showStatus(null);
        }
        if (shell != null && this.getButtonStyle() == BButtonStyle.hyperlink) {
            this.setMouseCursor(MouseCursor.normal);
        }
        this.mouseOver = false;
        StyleUtils.removeStyleClass(this, "hover");
        this.repaint();
    }

    public void mouseHover(BMouseEvent event) {
        String text;
        if (this.getButtonStyle() == BButtonStyle.toolBar && this.command != null && (text = this.command.getLabel()) != null && text.length() > 0) {
            double x = event.getX();
            double y = event.getY();
            y = Math.max(this.getHeight() + 1.0, y + 16.0);
            UiEnv.get().openBubbleHelp(this, x, y, text);
        }
    }

    private String getToolTip() {
        String text;
        if (this.command != null) {
            String label = this.command.getLabel();
            String description = this.command.getDescription();
            if (label != null && label.length() > 0) {
                if (label.endsWith("...")) {
                    label = label.substring(0, label.length() - 3);
                }
                if (label.endsWith("..")) {
                    label = label.substring(0, label.length() - 2);
                }
                if (description != null && description.length() > 0) {
                    return label + ": " + description;
                }
                return label;
            }
            if (description != null && description.length() > 0) {
                return description;
            }
        }
        if ((text = this.getText()) != null && text.length() > 0) {
            return text;
        }
        return null;
    }

    LabelTheme theme() {
        return this.buttonTheme();
    }

    abstract AbstractButtonTheme buttonTheme();

    public String getDebugString() {
        return "\"" + this.getText() + "\"; ";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface MenuController {
        public boolean isMenuDistinct();

        public BMenu getMenu(BAbstractButton var1);
    }
}

