/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.wizard.step;

import com.tridium.ui.wizard.step.BWizardButtonMode;
import com.tridium.ui.wizard.step.CannotCancelException;
import com.tridium.ui.wizard.step.CannotCommitException;
import com.tridium.ui.wizard.step.ICommitLog;
import com.tridium.ui.wizard.step.IWizardView;
import com.tridium.ui.wizard.step.StepArtifact;
import com.tridium.ui.wizard.step.StepModel;
import java.util.ListIterator;
import javax.baja.nre.util.Array;
import javax.baja.sys.Context;
import javax.baja.util.CannotValidateException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WizardStep {
    public static final NullCommitLog nullCommitLog = new NullCommitLog();
    private Array validators;
    private Array commits;
    private IUiHandler uiHandler;
    private IRouter router;
    private IRouter endRouter;
    private IRouter lastEndRouter;
    private BWizardButtonMode overrideMode;
    private boolean runOnce;
    private boolean forceFinishStep;
    private ICommitLog commitLog;
    static /* synthetic */ Class class$com$tridium$ui$wizard$step$WizardStep$IValidator;
    static /* synthetic */ Class class$com$tridium$ui$wizard$step$WizardStep$ICommit;

    public final void addValidator(IValidator validator) {
        this.validators.add((Object)validator);
    }

    public final void remoteValidator(IValidator validator) {
        this.validators.remove((Object)validator);
    }

    public final IValidator[] getValidators() {
        return (IValidator[])this.validators.trim();
    }

    public final void addCommit(ICommit commit) {
        this.commits.add((Object)commit);
    }

    public final void removeCommit(ICommit commit) {
        this.commits.remove((Object)commit);
    }

    public final ICommit[] getCommits() {
        return (ICommit[])this.commits.trim();
    }

    public final void setUiHandler(IUiHandler uiHandler) {
        this.uiHandler = uiHandler;
    }

    public final IUiHandler getUiHandler() {
        return this.uiHandler;
    }

    public final void setRouter(IRouter router) {
        this.router = router;
    }

    public final IRouter getRouter() {
        return this.router;
    }

    public final void validate(StepArtifact artifact, StepModel model, IWizardView view, Context cx) throws CannotValidateException {
        ListIterator it = this.validators.iterator();
        while (it.hasNext()) {
            IValidator val = (IValidator)it.next();
            val.validate(artifact, model, view, cx);
        }
    }

    public final void commit(StepArtifact artifact, StepModel model, IWizardView view, Context cx) throws CannotCommitException {
        ListIterator it = this.commits.iterator();
        while (it.hasNext()) {
            ICommit c = (ICommit)it.next();
            c.commit(artifact, model, view, this.commitLog, cx);
        }
    }

    public void setCommitLog(ICommitLog commitLog) {
        this.commitLog = commitLog;
    }

    public final WizardStep next(StepArtifact artifact, StepModel model, IWizardView view, Context cx) {
        WizardStep nextStep = null;
        if (this.router != null) {
            nextStep = this.router.next(artifact, model, view, cx);
            while (nextStep != null && nextStep.skipStep(artifact, model, view, cx)) {
                nextStep = nextStep.next(artifact, model, view, cx);
            }
        }
        if (nextStep == null && this.lastEndRouter != null) {
            nextStep = this.lastEndRouter.next(artifact, model, view, cx);
            while (nextStep != null && nextStep.skipStep(artifact, model, view, cx)) {
                nextStep = nextStep.next(artifact, model, view, cx);
            }
            if (nextStep != null && nextStep.getEndRouter() == null) {
                nextStep.lastEndRouter = null;
            }
        } else if (nextStep != null && nextStep.getEndRouter() == null) {
            nextStep.lastEndRouter = this.lastEndRouter;
        }
        return nextStep;
    }

    public final WizardStep setNext(WizardStep step) {
        this.router = DefaultRouter.make(step);
        return step;
    }

    public void setEndRouter(IRouter endRouter) {
        this.endRouter = endRouter;
        this.lastEndRouter = endRouter;
    }

    public IRouter getEndRouter() {
        return this.endRouter;
    }

    public final WizardStep setEnd(WizardStep step) {
        this.setEndRouter(DefaultRouter.make(step));
        return step;
    }

    public final StepArtifact create(StepModel model, IWizardView view, Context cx) {
        if (this.uiHandler != null) {
            return this.uiHandler.create(this, model, view, cx);
        }
        return null;
    }

    public final void detach(StepArtifact artifact, StepModel model, IWizardView view, Context cx) {
        if (this.uiHandler != null) {
            this.uiHandler.detach(artifact, model, view, cx);
        }
    }

    public final StepArtifact updateStepArtifact(StepArtifact artifact, StepModel model, IWizardView view, Context cx) {
        if (this.uiHandler != null) {
            return this.uiHandler.updateStepArtifact(artifact, model, view, cx);
        }
        return null;
    }

    public final boolean restoreFromNext(StepArtifact artifact, StepModel model, IWizardView view, Context cx) {
        if (this.uiHandler != null) {
            return this.uiHandler.restoreFromNext(artifact, model, view, cx);
        }
        return false;
    }

    public final boolean restoreFromBack(StepArtifact artifact, StepModel model, IWizardView view, Context cx) {
        if (this.uiHandler != null) {
            return this.uiHandler.restoreFromBack(artifact, model, view, cx);
        }
        return false;
    }

    public void setOverrideMode(BWizardButtonMode overrideMode) {
        this.overrideMode = overrideMode;
    }

    public void clearOverrideMode() {
        this.overrideMode = null;
    }

    public BWizardButtonMode getOverrideMode() {
        return this.overrideMode;
    }

    public BWizardButtonMode getWizardButtonMode(StepArtifact artifact, StepModel model, IWizardView view, Context cx) {
        WizardStep backStep;
        if (this.overrideMode != null) {
            return this.overrideMode;
        }
        BWizardButtonMode mode = BWizardButtonMode.cancel;
        if (model.isFinished()) {
            return mode;
        }
        if (model.getStepArtifactHistory().isBackward() && !(backStep = model.getStepArtifactHistory().peekBackward().getStep()).isRunOnce() && !this.isRunOnce()) {
            mode = mode.merge(BWizardButtonMode.back);
        }
        mode = this.next(artifact, model, view, cx) != null && !this.isForceFinishStep() ? mode.merge(BWizardButtonMode.next) : mode.merge(BWizardButtonMode.finish);
        return mode;
    }

    public void setRunOnce(boolean runOnce) {
        this.runOnce = runOnce;
    }

    public boolean isRunOnce() {
        return this.runOnce;
    }

    public void setForceFinishStep(boolean forceFinishStep) {
        this.forceFinishStep = forceFinishStep;
    }

    public boolean isForceFinishStep() {
        return this.forceFinishStep;
    }

    public void back(StepArtifact artifact, StepModel model, IWizardView view, Context cx) {
    }

    public void cancel(StepArtifact artifact, StepModel model, IWizardView view, Context cx) throws CannotCancelException {
    }

    public boolean skipStep(StepArtifact artifact, StepModel model, IWizardView view, Context cx) {
        return false;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        Class clazz = class$com$tridium$ui$wizard$step$WizardStep$IValidator;
        if (clazz == null) {
            clazz = class$com$tridium$ui$wizard$step$WizardStep$IValidator = WizardStep.class("[Lcom.tridium.ui.wizard.step.WizardStep$IValidator;", false);
        }
        this.validators = new Array(clazz, 1);
        Class clazz2 = class$com$tridium$ui$wizard$step$WizardStep$ICommit;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$ui$wizard$step$WizardStep$ICommit = WizardStep.class("[Lcom.tridium.ui.wizard.step.WizardStep$ICommit;", false);
        }
        this.commits = new Array(clazz2, 1);
        this.overrideMode = null;
        this.runOnce = false;
        this.forceFinishStep = false;
        this.commitLog = nullCommitLog;
    }

    public WizardStep() {
        this.this();
    }

    public WizardStep(IUiHandler uiHandler) {
        this.this();
        this.setUiHandler(uiHandler);
    }

    public static interface IValidator {
        public void validate(StepArtifact var1, StepModel var2, IWizardView var3, Context var4) throws CannotValidateException;
    }

    public static interface ICommit {
        public void commit(StepArtifact var1, StepModel var2, IWizardView var3, ICommitLog var4, Context var5) throws CannotCommitException;
    }

    public static interface IRouter {
        public WizardStep next(StepArtifact var1, StepModel var2, IWizardView var3, Context var4);
    }

    public static final class DefaultRouter
    implements IRouter {
        private WizardStep next;

        public static final DefaultRouter make(WizardStep next) {
            return new DefaultRouter(next);
        }

        public final WizardStep next(StepArtifact artifact, StepModel model, IWizardView view, Context cx) {
            return this.next;
        }

        public DefaultRouter(WizardStep next) {
            this.next = next;
        }
    }

    public static interface IUiHandler {
        public StepArtifact create(WizardStep var1, StepModel var2, IWizardView var3, Context var4);

        public void detach(StepArtifact var1, StepModel var2, IWizardView var3, Context var4);

        public StepArtifact updateStepArtifact(StepArtifact var1, StepModel var2, IWizardView var3, Context var4);

        public boolean restoreFromNext(StepArtifact var1, StepModel var2, IWizardView var3, Context var4);

        public boolean restoreFromBack(StepArtifact var1, StepModel var2, IWizardView var3, Context var4);
    }

    private static final class NullCommitLog
    implements ICommitLog {
        public final void log(String str) {
        }

        private NullCommitLog() {
        }
    }
}

