/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.wizard.step;

import com.tridium.ui.wizard.step.BWizardButtonMode;
import com.tridium.ui.wizard.step.CannotCancelException;
import com.tridium.ui.wizard.step.IWizardView;
import com.tridium.ui.wizard.step.StepArtifact;
import com.tridium.ui.wizard.step.StepArtifactHistory;
import com.tridium.ui.wizard.step.WizardStep;
import javax.baja.sys.Context;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class StepModel {
    private StepArtifactHistory stepHistory;
    private WizardStep currentStep;
    private WizardStep firstStep;
    private volatile boolean finished;

    public static final StepModel make(WizardStep step) {
        return new StepModel(step);
    }

    public final void init(IWizardView view) {
        if (this.finished) {
            return;
        }
        this.stepHistory.clear();
        this.currentStep = null;
        this.loadNextStep(this.firstStep, view, view.getWizardContext());
    }

    public final void deactivated(IWizardView view) {
        if (this.currentStep != null) {
            this.stepHistory.updateCurrent(this.currentStep.updateStepArtifact(this.stepHistory.getCurrent(), this, view, view.getWizardContext()));
            this.currentStep.detach(this.stepHistory.getCurrent(), this, view, view.getWizardContext());
        }
    }

    public final void back(IWizardView view) {
        if (!this.finished && this.currentStep != null) {
            this.loadBackStep(view, view.getWizardContext());
        }
    }

    public final void next(IWizardView view) {
        if (!this.finished && this.currentStep != null) {
            this.loadNextStep(this.currentStep.next(this.stepHistory.getCurrent(), this, view, view.getWizardContext()), view, view.getWizardContext());
        }
    }

    public final boolean finish(IWizardView view) {
        if (!this.finished && this.currentStep != null) {
            if (this.hasNext(view)) {
                this.next(view);
            } else {
                try {
                    this.stepHistory.updateCurrent(this.currentStep.updateStepArtifact(this.stepHistory.getCurrent(), this, view, view.getWizardContext()));
                    this.currentStep.validate(this.stepHistory.getCurrent(), this, view, view.getWizardContext());
                    this.currentStep.commit(this.stepHistory.getCurrent(), this, view, view.getWizardContext());
                    this.setFinished();
                }
                catch (Exception e) {
                    view.handleError(e);
                }
                this.update(view);
            }
        }
        return this.finished;
    }

    public final boolean cancel(IWizardView view) {
        if (this.currentStep != null) {
            try {
                this.stepHistory.updateCurrent(this.currentStep.updateStepArtifact(this.stepHistory.getCurrent(), this, view, view.getWizardContext()));
                this.currentStep.cancel(this.stepHistory.getCurrent(), this, view, view.getWizardContext());
                return true;
            }
            catch (CannotCancelException e) {
                view.handleError((Throwable)((Object)e));
                return false;
            }
        }
        return false;
    }

    private final void loadNextStep(WizardStep step, IWizardView view, Context cx) {
        if (this.finished) {
            return;
        }
        if (step == null) {
            return;
        }
        if (this.currentStep != null) {
            this.stepHistory.updateCurrent(this.currentStep.updateStepArtifact(this.stepHistory.getCurrent(), this, view, cx));
            try {
                this.currentStep.validate(this.stepHistory.getCurrent(), this, view, cx);
                this.currentStep.commit(this.stepHistory.getCurrent(), this, view, cx);
            }
            catch (Exception e) {
                view.handleError(e);
                return;
            }
            this.currentStep.detach(this.stepHistory.getCurrent(), this, view, cx);
        }
        this.currentStep = step;
        boolean restored = false;
        if (this.stepHistory.isForward()) {
            StepArtifact forwardArt = this.stepHistory.forward();
            if (forwardArt.getStep().equals(this.currentStep)) {
                restored = this.currentStep.restoreFromNext(forwardArt, this, view, cx);
            }
            if (!restored) {
                this.stepHistory.removeCurrent();
            }
        }
        if (!restored) {
            this.stepHistory.add(this.currentStep.create(this, view, cx));
        }
        this.update(view);
    }

    private final void loadBackStep(IWizardView view, Context cx) {
        if (this.finished) {
            return;
        }
        if (this.currentStep == null) {
            return;
        }
        if (!this.stepHistory.isBackward()) {
            return;
        }
        this.stepHistory.updateCurrent(this.currentStep.updateStepArtifact(this.stepHistory.getCurrent(), this, view, cx));
        this.currentStep.back(this.stepHistory.getCurrent(), this, view, cx);
        this.currentStep.detach(this.stepHistory.getCurrent(), this, view, cx);
        StepArtifact artifact = this.stepHistory.backward();
        if (artifact == null) {
            return;
        }
        this.currentStep = artifact.getStep();
        if (!this.currentStep.restoreFromBack(artifact, this, view, cx)) {
            this.stepHistory.removeCurrent();
            this.stepHistory.add(this.currentStep.create(this, view, cx));
        }
        this.update(view);
    }

    public final void update(IWizardView view) {
        if (this.currentStep != null) {
            this.update(this.currentStep.getWizardButtonMode(this.stepHistory.getCurrent(), this, view, view.getWizardContext()), view);
        }
    }

    private final void update(BWizardButtonMode mode, IWizardView view) {
        view.update(mode);
    }

    public final StepArtifactHistory getStepArtifactHistory() {
        return this.stepHistory;
    }

    public final WizardStep getFirstStep() {
        return this.firstStep;
    }

    public final boolean isFinished() {
        return this.finished;
    }

    public final void setFinished() {
        this.finished = true;
    }

    public final boolean hasNext(IWizardView view) {
        if (this.currentStep == null) {
            return false;
        }
        boolean bl = false;
        if (this.currentStep.next(this.stepHistory.getCurrent(), this, view, view.getWizardContext()) != null) {
            bl = true;
        }
        return bl;
    }

    public final WizardStep getCurrentStep() {
        return this.currentStep;
    }

    private final /* synthetic */ void this() {
        this.stepHistory = new StepArtifactHistory();
        this.finished = false;
    }

    private StepModel(WizardStep step) {
        this.this();
        this.firstStep = step;
    }
}

