/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.util;

import java.text.AttributedCharacterIterator;
import javax.baja.ui.event.BInputMethodEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.text.TextController;

public abstract class ValidatingTextController
extends TextController {
    public void keyPressed(BKeyEvent event) {
        int start;
        int keyCode = event.getKeyCode();
        int end = start = this.getEditor().getCaretPosition().column;
        if (!this.getEditor().getSelection().isEmpty()) {
            start = this.getEditor().getSelection().getStart().column;
            end = this.getEditor().getSelection().getEnd().column;
        }
        String modelText = this.getEditor().getModel().getText();
        StringBuffer updatedText = new StringBuffer();
        if (keyCode == 127) {
            if (start == end) {
                if (end == modelText.length()) {
                    return;
                }
                ++end;
            }
            if (start > 0) {
                updatedText.append(modelText.substring(0, start));
            }
            if (end < modelText.length()) {
                updatedText.append(modelText.substring(end));
            }
        } else if (keyCode == 8) {
            if (start == end) {
                if (start == 0) {
                    return;
                }
                --start;
            }
            if (start > 0) {
                updatedText.append(modelText.substring(0, start));
            }
            if (end < modelText.length()) {
                updatedText.append(modelText.substring(end));
            }
        }
        if (updatedText.length() > 0 && !this.valid(updatedText.toString())) {
            return;
        }
        super.keyPressed(event);
    }

    public void keyTyped(BKeyEvent event) {
        int start = this.getEditor().getCaretPosition().column;
        int overtyped = 0;
        if (!this.getEditor().getSelection().isEmpty()) {
            start = this.getEditor().getSelection().getStart().column;
            overtyped = this.getEditor().getSelection().getEnd().column - start;
        }
        char key = event.getKeyChar();
        String modelText = this.getEditor().getModel().getText();
        StringBuffer updatedText = new StringBuffer();
        if (start > 0) {
            updatedText.append(modelText.substring(0, start));
        }
        updatedText.append(key);
        updatedText.append(modelText.substring(start + overtyped));
        if (this.valid(updatedText.toString())) {
            super.keyTyped(event);
        }
    }

    public void imTextChanged(BInputMethodEvent event) {
        AttributedCharacterIterator eventText = event.getText();
        String eventTextString = this.getText(eventText);
        String existingTextString = this.getModel().getText();
        if (!this.valid(existingTextString + eventTextString)) {
            return;
        }
        super.imTextChanged(event);
    }

    protected abstract boolean valid(String var1);
}

