/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.palladium;

import com.tridium.ui.theme.TreeTableTheme;
import com.tridium.ui.theme.palladium.PalladiumTableTheme;
import com.tridium.ui.theme.palladium.PalladiumTreeTheme;
import javax.baja.gx.BBrush;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;

public class PalladiumTreeTableTheme
extends PalladiumTableTheme
implements TreeTableTheme {
    static final double EXPANDER_WIDTH = 9.0;
    static final double EXPANDER_HEIGHT = 9.0;
    static final double INDENT = 15.0;

    public BBrush getGroupBackground() {
        return PalladiumTableTheme.gridBrush;
    }

    public double getIndent(int depth) {
        return (double)3 + 15.0 * (double)depth;
    }

    public double getExpanderWidth() {
        return 9.0;
    }

    public double getExpanderHeight() {
        return 9.0;
    }

    public void paintExpander(Graphics g, double x, double y, boolean selected, int state, boolean group) {
        BBrush origBrush = g.getBrush();
        if (selected) {
            g.setBrush(this.getSelectionForeground());
        } else if (group) {
            g.setBrush(PalladiumTreeTheme.expanderBrush);
        } else {
            g.setBrush(PalladiumTreeTheme.connectingBrush);
        }
        g.strokeLine(x, y, x + 9.0 - 1.0, y);
        g.strokeLine(x, y, x, y + 9.0 - 1.0);
        g.strokeLine(x + 9.0 - 1.0, y, x + 9.0 - 1.0, y + 9.0 - 1.0);
        g.strokeLine(x, y + 9.0 - 1.0, x + 9.0 - 1.0, y + 9.0 - 1.0);
        g.setBrush(selected ? this.getSelectionForeground() : PalladiumTreeTheme.expanderBrush);
        if (state != 0) {
            g.strokeLine(x + (double)2, y + (double)4, x + 6.0, y + (double)4);
        }
        if (state == 1) {
            g.strokeLine(x + (double)4, y + (double)2, x + (double)4, y + 6.0);
        }
        g.setBrush(origBrush);
    }

    public void paintGroupBackground(Graphics g, RectGeom bounds) {
        g.setBrush(this.getControlBackground());
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
    }
}

