/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.palladium;

import com.tridium.ui.theme.SpinnerButtonTheme;
import com.tridium.ui.theme.palladium.PalladiumWidgetTheme;
import javax.baja.gx.Graphics;
import javax.baja.gx.IPoint;
import javax.baja.gx.Point;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BToggleButton;

public class PalladiumSpinnerButtonTheme
extends PalladiumWidgetTheme
implements SpinnerButtonTheme {
    static Point noOffset = new Point(0.0, 0.0);
    static Point pressedOffset = new Point(1.0, 1.0);
    private static final double SPINNER_WIDTH = 13.0;

    public double getSpinnerWidth() {
        return 13.0;
    }

    public boolean isStacked() {
        return true;
    }

    public IPoint getLabelOffset(BAbstractButton b) {
        BAbstractButton.MenuController c = b.getMenuController();
        if (c != null && !c.isMenuDistinct() && b.isMenuPressed()) {
            return pressedOffset;
        }
        if (b.isPressed() && b.isMouseOver()) {
            return pressedOffset;
        }
        if (b instanceof BToggleButton && ((BToggleButton)b).isSelected()) {
            return pressedOffset;
        }
        return noOffset;
    }

    public void paintArrows(Graphics g, BAbstractButton up, BAbstractButton down, boolean translateUp, boolean translateDown) {
        IPoint offset = this.getLabelOffset(up);
        if (translateUp) {
            g.translate(offset.x(), offset.y());
        }
        int width = (int)up.getWidth();
        int height = (int)up.getHeight();
        int centerX = width / 2 + 1;
        int centerY = height / 2 + 1;
        if (centerY + 1 < height - 3) {
            g.strokeLine((double)centerX, (double)(centerY - 1), (double)centerX, (double)(centerY - 1));
            g.strokeLine((double)(centerX - 1), (double)centerY, (double)(centerX + 1), (double)centerY);
            g.strokeLine((double)(centerX - 2), (double)(centerY + 1), (double)(centerX + 2), (double)(centerY + 1));
        } else {
            g.strokeLine((double)centerX, (double)(centerY - 1), (double)centerX, (double)(centerY - 1));
            g.strokeLine((double)(centerX - 1), (double)centerY, (double)(centerX + 1), (double)centerY);
        }
        if (translateUp) {
            g.translate(-offset.x(), -offset.y());
        }
        offset = this.getLabelOffset(down);
        if (translateDown) {
            g.translate(offset.x(), offset.y());
        }
        double yOffset = up.getHeight() - 1.0;
        width = (int)down.getWidth();
        height = (int)down.getHeight();
        centerX = width / 2 + 1;
        centerY = height / 2 + 1;
        if (centerY + 1 < height - 3) {
            g.strokeLine((double)centerX, (double)(centerY + 1) + yOffset, (double)centerX, (double)(centerY + 1) + yOffset);
            g.strokeLine((double)(centerX - 1), (double)centerY + yOffset, (double)(centerX + 1), (double)centerY + yOffset);
            g.strokeLine((double)(centerX - 2), (double)(centerY - 1) + yOffset, (double)(centerX + 2), (double)(centerY - 1) + yOffset);
        } else {
            g.strokeLine((double)centerX, (double)centerY + yOffset, (double)centerX, (double)centerY + yOffset);
            g.strokeLine((double)(centerX - 1), (double)(centerY - 1) + yOffset, (double)(centerX + 1), (double)(centerY - 1) + yOffset);
        }
        if (translateDown) {
            g.translate(-offset.x(), -offset.y());
        }
    }
}

