/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.palladium;

import com.tridium.ui.theme.RadioButtonTheme;
import com.tridium.ui.theme.palladium.PalladiumToggleButtonTheme;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IInsets;
import javax.baja.gx.IPoint;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BToggleButton;

public class PalladiumRadioButtonTheme
extends PalladiumToggleButtonTheme
implements RadioButtonTheme {
    static BInsets padding = BInsets.make((double)2, (double)2, (double)2, (double)18.0);

    public IInsets getPadding(BAbstractButton b) {
        return padding;
    }

    public BFont getTextFont() {
        return this.getPlainText();
    }

    public IPoint getLabelOffset(BAbstractButton button) {
        return noOffset;
    }

    public void paintBackground(Graphics g, BAbstractButton b) {
        boolean mouseOver = b.isMouseOver();
        boolean pressed = b.isPressed();
        boolean enabled = b.getEnabled();
        boolean selected = ((BToggleButton)b).isSelected();
        double x = 0.0;
        double y = b.getHeight() / (double)2 - 6.0;
        double w = 12.0;
        double h = 12.0;
        if (enabled) {
            g.setBrush(this.getControlForeground());
        } else {
            g.setBrush(this.getControlShadow());
        }
        g.strokeLine(x, y + h / (double)2, x + w / (double)2, y);
        g.strokeLine(x + w / (double)2, y, x + w, y + h / (double)2);
        g.strokeLine(x + w, y + h / (double)2, x + w / (double)2, y + h);
        g.strokeLine(x + w / (double)2, y + h, x, y + h / (double)2);
        if (pressed && mouseOver) {
            g.setBrush(this.getControlShadow());
        } else {
            g.setBrush(this.getControlHighlight());
        }
        g.strokeLine(x + 1.0, y + h / (double)2, x + w / (double)2, y + 1.0);
        if (enabled) {
            g.setBrush(this.getControlShadow());
        } else {
            g.setBrush(this.getControlAuxiliary());
        }
        g.strokeLine(x + w - 1.0, y + h / (double)2, x + w / (double)2, y + h - 1.0);
        g.strokeLine(x + w - (double)2, y + h / (double)2, x + w / (double)2, y + h - (double)2);
        if (selected) {
            if (enabled) {
                g.setBrush(this.getControlForeground());
            } else {
                g.setBrush(this.getControlShadow());
            }
            g.strokeLine(x + (double)4, y + h / (double)2, x + w / (double)2, y + (double)4);
            g.strokeLine(x + (double)5, y + h / (double)2 + 1.0, x + w / (double)2 + 1.0, y + (double)5);
            g.strokeLine(x + 6.0, y + h / (double)2 + (double)2, x + w / (double)2 + (double)2, y + 6.0);
            g.strokeLine(x + (double)5, y + h / (double)2, x + w / (double)2, y + (double)5);
            g.strokeLine(x + 6.0, y + h / (double)2 + 1.0, x + w / (double)2 + 1.0, y + 6.0);
        }
        if (b.hasFocus() && b.isFocusTraversable()) {
            x = PalladiumRadioButtonTheme.padding.left - (double)2;
            y = PalladiumRadioButtonTheme.padding.top;
            w = b.getWidth() - (x + PalladiumRadioButtonTheme.padding.right);
            h = b.getHeight() - (y + PalladiumRadioButtonTheme.padding.bottom);
            this.paintFocus(g, new RectGeom(x, y, w, h));
        }
    }
}

