/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom.nss;

import com.tridium.gx.GxEnv;
import com.tridium.ui.theme.custom.nss.NSS;
import com.tridium.ui.theme.custom.nss.NSSDefaults;
import com.tridium.ui.theme.custom.nss.NSSException;
import com.tridium.ui.theme.custom.nss.NSSUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.baja.file.BIFile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NSSReader {
    private Stack stack;
    private String currentTagName;
    private Object currentValue;
    private Map definitions;
    private StreamTokenizer tokenizer;
    private String token;
    private int tagNumber;
    private NSS nss;
    private NSS parentNSS;
    private boolean fontsOverridden;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSS readFromFile(BIFile file) throws IOException {
        NSS nSS;
        block2: {
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader(file.getInputStream());
                nSS = NSSReader.doRead(reader);
                Object var3_3 = null;
                if (reader == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var3_4 = null;
                    if (reader == null) break block3;
                    ((Reader)reader).close();
                }
                throw throwable;
            }
            ((Reader)reader).close();
        }
        return nSS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSS readFromString(String s) throws IOException {
        NSS nSS;
        block2: {
            StringReader reader = null;
            try {
                reader = new StringReader(s);
                nSS = NSSReader.doRead(reader);
                Object var3_3 = null;
                if (reader == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var3_4 = null;
                    if (reader == null) break block3;
                    ((Reader)reader).close();
                }
                throw throwable;
            }
            ((Reader)reader).close();
        }
        return nSS;
    }

    private static final NSS doRead(Reader reader) throws IOException {
        NSSReader nssReader = new NSSReader(reader);
        nssReader.read();
        nssReader.finish();
        NSS defaults = new NSS();
        NSSDefaults.setPalladiumDefaults(defaults);
        NSSReader.overrideNSS(nssReader.nss, defaults);
        return defaults;
    }

    private static final void overrideNSS(NSS donor, NSS recipient) {
        Iterator it = donor.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object otherValue = recipient.get(key);
            if (value instanceof NSS && otherValue instanceof NSS) {
                NSSReader.overrideNSS((NSS)value, (NSS)otherValue);
                continue;
            }
            recipient.put(key, value);
        }
    }

    private final void read() throws IOException {
        NSS root = new NSS();
        this.stack.push(root);
        while ((this.token = this.getNextToken()) != null) {
            if (this.token.equals("{")) {
                this.startNewNode();
                continue;
            }
            if (this.token.equals("}")) {
                this.closeCurrentNode();
                continue;
            }
            if (this.token.equals(";")) {
                this.closeTag();
                continue;
            }
            if (this.token.equals(":")) {
                this.verifyTagStarted();
                continue;
            }
            this.handleValueToken();
        }
        if (this.parentNSS != null) {
            NSSReader.overrideNSS(root, this.parentNSS);
            this.nss = this.parentNSS;
        } else {
            this.nss = root;
        }
    }

    private final String getNextToken() throws IOException {
        if (this.tokenizer.nextToken() == -1) {
            return null;
        }
        switch (this.tokenizer.ttype) {
            case 10: {
                return "";
            }
            case -3: 
            case 34: 
            case 39: {
                return this.tokenizer.sval;
            }
        }
        return new String(new char[]{(char)this.tokenizer.ttype});
    }

    private final void startNewNode() {
        if (this.currentTagName == null) {
            throw new NSSException("unexpected symbol '{' on line " + this.tokenizer.lineno() + " (did you omit a name?)");
        }
        NSS newNode = new NSS((NSS)this.stack.peek(), this.currentTagName);
        this.addToHead(this.currentTagName, newNode);
        this.stack.push(newNode);
        this.reset();
    }

    private final void closeCurrentNode() {
        if (this.stack.size() == 1) {
            throw new NSSException("unexpected symbol '}' on line " + this.tokenizer.lineno() + " (you've tried to close  a block with '}' but missed the opening '{')");
        }
        NSS nss = (NSS)this.stack.pop();
        if (nss.getName().equals("font-families")) {
            this.applyFontOverrides(nss);
        }
        this.reset();
    }

    private final void applyFontOverrides(NSS nss) {
        if (this.fontsOverridden) {
            throw new NSSException("Duplicate font-families tag detected - only one font-families tag allowed per NSS file");
        }
        if (nss.has("serif")) {
            NSSReader.doFontOverride("serif", (String)nss.get("serif"));
        }
        if (nss.has("sansserif")) {
            NSSReader.doFontOverride("sansserif", (String)nss.get("sansserif"));
        }
        if (nss.has("monospaced")) {
            NSSReader.doFontOverride("monospaced", (String)nss.get("monospaced"));
        }
        if (nss.has("dialog")) {
            NSSReader.doFontOverride("dialog", (String)nss.get("dialog"));
        }
        if (nss.has("dialoginput")) {
            NSSReader.doFontOverride("dialoginput", (String)nss.get("dialoginput"));
        }
        this.fontsOverridden = true;
    }

    private static final void doFontOverride(String fontFamily, String newFonts) {
        GxEnv.get().overrideFontFamily(fontFamily, newFonts);
    }

    private final void handleValueToken() {
        if (this.token.length() > 0) {
            if (this.currentTagName == null) {
                this.startTag(this.token);
            } else {
                this.appendValue(this.token);
            }
        }
    }

    private final void startTag(String tagName) {
        this.currentTagName = tagName;
    }

    private final void appendValue(String value) {
        this.currentValue = this.currentValue instanceof String ? this.currentValue + ' ' + value : value;
    }

    private final void closeTag() {
        if (this.currentTagName == null || this.currentValue == null) {
            throw new NSSException("Unexpected symbol ';' at line " + this.tokenizer.lineno() + " (did you omit a property?)");
        }
        this.addToHead(this.currentTagName, this.currentValue);
        this.reset();
    }

    private final void verifyTagStarted() {
        if (this.currentTagName == null || this.currentValue != null) {
            throw new NSSException("Unexpected symbol ':' on line " + this.tokenizer.lineno() + ": ':' is optional but must always separate tag name and value");
        }
    }

    private final void reset() {
        this.currentTagName = null;
        this.currentValue = null;
    }

    private final void addToHead(String name, Object value) {
        ++this.tagNumber;
        NSS parentNode = (NSS)this.stack.peek();
        if (value instanceof NSS) {
            this.addChildNode(parentNode, name, (NSS)value);
        } else if (value instanceof String) {
            String s = (String)value;
            if (name.equals("#define")) {
                this.addDefinition(s);
            } else if (name.equals("#extends")) {
                this.processExtends(s);
            } else {
                this.addChildString(parentNode, name, s);
            }
        }
    }

    private final void addChildNode(NSS parentNode, String tagName, NSS childNode) {
        parentNode.put(tagName, childNode);
    }

    private final void addChildString(NSS parentNode, String tagName, String value) {
        parentNode.put(tagName, value);
    }

    private final void addDefinition(String definition) {
        StringTokenizer tok = new StringTokenizer(definition, " \t\n\r\f=");
        Definition def = null;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (def == null) {
                def = new Definition(token, this.tokenizer.lineno());
                continue;
            }
            def.append(token);
        }
        if (def != null && def.value != null) {
            this.definitions.put(def.tagName, def);
        }
    }

    private final boolean isDefinition(String token) {
        return token.startsWith("$");
    }

    private final Definition getDefinition(String definition) {
        Definition def = (Definition)this.definitions.get(definition.substring(1));
        if (def == null) {
            throw new NSSException("No definition available for reference '" + definition + '\'');
        }
        return def;
    }

    private final void finish() {
        this.finalizeNSS(this.nss);
    }

    private final void finalizeNSS(NSS nss) {
        Iterator it = nss.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String tagName = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                String s = (String)value;
                if (this.isDefinition(s)) {
                    Definition def = this.getDefinition(s);
                    try {
                        entry.setValue(NSSUtils.makeValueByTag(tagName, def.value));
                        continue;
                    }
                    catch (Exception e) {
                        throw new NSSException("Could not successfully parse defined value '" + def.value + "' defined by '" + s + "' at line " + def.lineNumber);
                    }
                }
                try {
                    entry.setValue(NSSUtils.makeValueByTag(tagName, s));
                    continue;
                }
                catch (Exception e) {
                    throw new NSSException("Could not successfully parse value '" + value + "'.");
                }
            }
            if (!(value instanceof NSS)) continue;
            this.finalizeNSS((NSS)value);
        }
    }

    /*
     * Exception decompiling
     */
    private final void processExtends(String parentNSSPath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 153->157)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final StreamTokenizer makeStreamTokenizer(Reader reader) {
        BufferedReader br = new BufferedReader(reader);
        StreamTokenizer st = new StreamTokenizer(br);
        st.eolIsSignificant(true);
        st.ordinaryChars(48, 57);
        st.ordinaryChar(46);
        st.wordChars(33, 41);
        st.wordChars(43, 46);
        st.wordChars(48, 57);
        st.wordChars(95, 95);
        st.ordinaryChar(92);
        st.wordChars(92, 92);
        st.quoteChar(39);
        st.quoteChar(34);
        st.slashSlashComments(true);
        st.slashStarComments(true);
        st.ordinaryChar(59);
        st.ordinaryChar(58);
        return st;
    }

    private final /* synthetic */ void this() {
        this.stack = new Stack();
        this.currentTagName = null;
        this.currentValue = null;
        this.definitions = new HashMap();
        this.token = "";
        this.tagNumber = 0;
        this.fontsOverridden = false;
    }

    private NSSReader(Reader reader) {
        this.this();
        this.tokenizer = NSSReader.makeStreamTokenizer(reader);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Definition {
        String tagName;
        String value;
        int lineNumber;

        public void append(String value) {
            this.value = this.value == null ? value : this.value + ' ' + value;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Definition)) {
                return false;
            }
            return this.tagName.equals(((Definition)o).tagName);
        }

        public int hashCode() {
            return this.tagName.hashCode();
        }

        public String toString() {
            return this.tagName;
        }

        public Definition(String tagName, int lineNumber) {
            this.tagName = tagName;
            this.lineNumber = lineNumber;
        }
    }
}

