/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom.nss;

import com.tridium.ui.theme.custom.nss.NSSException;
import com.tridium.ui.theme.custom.nss.NSSUtils;
import com.tridium.ui.theme.custom.nss.selector.NSSPath;
import com.tridium.ui.theme.custom.nss.selector.NSSSelector;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.baja.ui.style.IStylable;

public class NSS
extends TreeMap {
    private static final long serialVersionUID = 1L;
    private String selector;
    private String name;
    private NSS parent;

    public Object select(String selector) {
        return new NSSSelector(selector).select(this);
    }

    public Object selectStrict(String selector) {
        return new NSSSelector(selector).selectStrict(this);
    }

    public NSS selectNode(String selector) throws NSSException {
        return new NSSSelector(selector).selectNode(this);
    }

    public Object selectProperty(String selector) throws NSSException {
        return new NSSSelector(selector).selectProperty(this);
    }

    public Object select(IStylable widget, String widgetPath, String propertyPath) {
        return new NSSSelector(widget, widgetPath, propertyPath).select(this);
    }

    public Object selectStrict(IStylable widget, String widgetPath, String propertyPath) {
        return new NSSSelector(widget, widgetPath, propertyPath).selectStrict(this);
    }

    public Object selectProperty(IStylable widget, String widgetPath, String propertyPath) throws NSSException {
        return new NSSSelector(widget, widgetPath, propertyPath).select(this);
    }

    public NSS selectNode(IStylable widget, String widgetPath, String propertyPath) throws NSSException {
        return new NSSSelector(widget, widgetPath, propertyPath).selectNode(this);
    }

    public boolean ensure(String selector, String value) {
        if (this.selectStrict(selector) == null) {
            this.setBySelector(selector, value);
            return true;
        }
        return false;
    }

    public boolean has(String selector) {
        boolean bl = false;
        if (this.select(selector) != null) {
            bl = true;
        }
        return bl;
    }

    public Object setBySelector(String selector, String value) throws NSSException {
        StringTokenizer tok = new StringTokenizer(selector);
        NSS obj = this;
        Object retrieved = null;
        String token = null;
        while (tok.hasMoreTokens()) {
            token = tok.nextToken();
            if (!tok.hasMoreTokens()) break;
            if (obj instanceof NSS) {
                NSS nss = obj;
                retrieved = nss.get(token);
                if (retrieved == null) {
                    NSS newNSS = new NSS(nss, token);
                    nss.put(token, newNSS);
                    obj = newNSS;
                    continue;
                }
                obj = retrieved;
                continue;
            }
            if (obj == null) continue;
            throw new NSSException("selector '" + token + "' was used as a selector but was already set to value '" + obj + '\'');
        }
        if (obj instanceof NSS) {
            obj.put(token, NSSUtils.makeValueByTag(token, value));
            return value;
        }
        return null;
    }

    public String toString() {
        return this.toString(0);
    }

    private final String toString(int depth) {
        if (this.isEmpty()) {
            return "{}";
        }
        Iterator it = this.entrySet().iterator();
        StringBuffer ret = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < depth) {
            sb.append("\t");
            ++i;
        }
        String indent = sb.toString();
        ret.append("{\n");
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            String className = value.getClass().getName();
            className = className.substring(className.lastIndexOf(46) + 1);
            ret.append(indent).append("\t").append(name).append(": ");
            if (value instanceof NSS) {
                NSS map = (NSS)value;
                value = map.toString(depth + 1);
            }
            ret.append(className + ' ' + value).append("\n");
        }
        ret.append(indent).append("}");
        return ret.toString();
    }

    public String getSelector() {
        return this.selector;
    }

    public String getName() {
        return this.name;
    }

    public NSS getParent() {
        return this.parent;
    }

    public Object put(Object key, Object value) {
        if (value instanceof NSS) {
            ((NSS)value).parent = this;
        }
        return super.put(key, value);
    }

    public NSS(NSS parent, String selector) {
        this.parent = parent;
        this.selector = parent != null && parent.getSelector() != null && parent.getSelector().length() > 0 ? parent.getSelector() + ' ' + selector : selector;
        this.name = new NSSPath(this.selector).getName();
    }

    NSS() {
        this(null, "");
    }
}

