/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.TreeTheme;
import com.tridium.ui.theme.custom.CustomWidgetTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.ui.BWidget;

public class CustomTreeTheme
extends CustomWidgetTheme
implements TreeTheme {
    private double expanderWidth;
    private double expanderHeight;
    private BInsets insets;

    String getNSSSelector() {
        return "tree";
    }

    public BFont getFont(BWidget tree) {
        return this.getTextFont(tree);
    }

    public BBrush getForeground(BWidget tree) {
        return this.getTextBrush(tree);
    }

    public BBrush getBackground(BWidget tree) {
        return this.getControlBackground(tree);
    }

    public BBrush getConnectingBrush(BWidget tree) {
        BBrush brush = (BBrush)this.select(tree, "connector-color");
        if (brush == null) {
            return this.getWindowForeground(tree);
        }
        return brush;
    }

    public BBrush getExpanderBrush(BWidget tree) {
        return (BBrush)this.select(tree, "expander color");
    }

    public BInsets getInsets() {
        return this.insets;
    }

    public void setInsets(BInsets insets) {
        this.insets = insets;
    }

    public BInsets getInsets(BWidget widget) {
        return (BInsets)this.select(widget, "padding");
    }

    public double getExpanderHeight() {
        return this.expanderHeight;
    }

    public void setExpanderHeight(double eh) {
        this.expanderHeight = eh;
    }

    public double getExpanderWidth() {
        return this.expanderWidth;
    }

    public void setExpanderWidth(double ew) {
        this.expanderWidth = ew;
    }

    public boolean inExpander(double expX, double expY, double x, double y) {
        boolean bl = false;
        if (x >= expX && x <= expX + this.expanderWidth && y >= expY && y <= expY + this.expanderHeight) {
            bl = true;
        }
        return bl;
    }

    public void paintExpander(Graphics g, BWidget tree, double x, double y, boolean expanded) {
        BBrush origBrush = g.getBrush();
        double midx = x + (double)((int)(this.expanderWidth / (double)2));
        double midy = y + (double)((int)(this.expanderHeight / (double)2));
        g.setBrush(this.getConnectingBrush(tree));
        g.strokeLine(x, y, x + this.expanderWidth - 1.0, y);
        g.strokeLine(x, y, x, y + this.expanderHeight - 1.0);
        g.strokeLine(x + this.expanderWidth - 1.0, y, x + this.expanderWidth - 1.0, y + this.expanderHeight - 1.0);
        g.strokeLine(x, y + this.expanderHeight - 1.0, x + this.expanderWidth - 1.0, y + this.expanderHeight - 1.0);
        g.setBrush(this.getExpanderBrush(tree));
        g.strokeLine(x + (double)2, midy, x + this.expanderWidth - (double)3, midy);
        if (!expanded) {
            g.strokeLine(midx, y + (double)2, midx, y + this.expanderHeight - (double)3);
        }
        g.setBrush(origBrush);
    }

    public void paintExpander(Graphics g, BWidget tree, double x, double y, boolean isExpandable, boolean isExpanded) {
        this.paintExpander(g, tree, x, y, isExpanded);
    }

    public CustomTreeTheme() {
        NSS nss = CustomTreeTheme.getNSS();
        NSS tree = nss.selectNode("tree");
        this.regFallbackValue(tree, "insets", "padding", "2 4");
        NSS expander = tree.selectNode("expander");
        this.regFallbackValue(expander, "expanderWidth", "width", "9");
        this.regFallbackValue(expander, "expanderHeight", "height", "9");
    }
}

