/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.TreeTableTheme;
import com.tridium.ui.theme.custom.CustomTableTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CustomTreeTableTheme
extends CustomTableTheme
implements TreeTableTheme {
    private BBrush expanderBrush;
    private BBrush connectingBrush;
    private double expanderWidth;
    private double expanderHeight;
    private double indent;

    String getNSSSelector() {
        return "table tree-table";
    }

    public BBrush getGroupBackground() {
        return this.getGridBrush();
    }

    public BBrush getConnectingBrush() {
        return this.connectingBrush;
    }

    public void setConnectingBrush(BBrush cb) {
        this.connectingBrush = cb;
    }

    public BBrush getExpanderBrush() {
        return this.expanderBrush;
    }

    public void setExpanderBrush(BBrush eb) {
        this.expanderBrush = eb;
    }

    public double getIndent(int depth) {
        return (double)3 + this.indent * (double)depth;
    }

    public double getExpanderHeight() {
        return this.expanderHeight;
    }

    public void setExpanderHeight(double eh) {
        this.expanderHeight = eh;
    }

    public double getExpanderWidth() {
        return this.expanderWidth;
    }

    public void setExpanderWidth(double ew) {
        this.expanderWidth = ew;
    }

    public void paintExpander(Graphics g, double x, double y, boolean selected, int state, boolean group) {
        BBrush origBrush = g.getBrush();
        if (selected) {
            g.setBrush(this.getSelectionForeground());
        } else if (group) {
            g.setBrush(this.expanderBrush);
        } else {
            g.setBrush(this.connectingBrush);
        }
        g.strokeLine(x, y, x + this.expanderWidth - 1.0, y);
        g.strokeLine(x, y, x, y + this.expanderHeight - 1.0);
        g.strokeLine(x + this.expanderWidth - 1.0, y, x + this.expanderWidth - 1.0, y + this.expanderHeight - 1.0);
        g.strokeLine(x, y + this.expanderHeight - 1.0, x + this.expanderWidth - 1.0, y + this.expanderHeight - 1.0);
        g.setBrush(selected ? this.getSelectionForeground() : this.expanderBrush);
        if (state != 0) {
            g.strokeLine(x + (double)2, y + (double)4, x + 6.0, y + (double)4);
        }
        if (state == 1) {
            g.strokeLine(x + (double)4, y + (double)2, x + (double)4, y + 6.0);
        }
        g.setBrush(origBrush);
    }

    public void paintGroupBackground(Graphics g, RectGeom bounds) {
        g.setBrush(this.getControlBackground());
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    private final /* synthetic */ void this() {
        this.expanderBrush = BColor.black.toBrush();
        this.connectingBrush = BColor.make((int)192, (int)192, (int)192).toBrush();
        this.expanderWidth = 17.0;
        this.expanderHeight = 17.0;
        this.indent = this.expanderWidth + 6.0;
    }

    public CustomTreeTableTheme() {
        this.this();
        NSS nss = CustomTreeTableTheme.getNSS();
        NSS treeTable = nss.selectNode("table tree-table");
        NSS expander = treeTable.selectNode("expander");
        this.regFallbackValue(expander, "expanderBrush", "color", "#000");
        this.regFallbackValue(expander, "expanderWidth", "width", "9");
        this.regFallbackValue(expander, "expanderHeight", "height", "9");
        this.regFallbackValue(treeTable, "connectingBrush", "connector-color", "#ccc");
    }
}

