/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import java.util.Collections;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BObject;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;

public class CustomThemeModuleManager {
    private static Log logger = Log.getLog((String)"com.tridium.ui.theme.custom");
    private static BEnumRange themeModules = CustomThemeModuleManager.initializeThemeModules();
    private static final String[] DEFAULT_THEMES = new String[]{"Lucid", "Palladium"};

    private static final BEnumRange initializeThemeModules() {
        String[] themeNames = Sys.getRegistry().getDefs("themeName");
        ArrayList<String> themes = new ArrayList<String>();
        int i = 0;
        while (i < themeNames.length) {
            String themeName = themeNames[i];
            BDirectory dir = CustomThemeModuleManager.getNSSDirectory(themeName);
            if (dir != null) {
                BIFile[] files = dir.listFiles();
                int j = 0;
                while (j < files.length) {
                    String nssPath = CustomThemeModuleManager.getDisplayNSSPath(themeName, files[j]);
                    if (nssPath != null) {
                        themes.add(nssPath);
                    }
                    ++j;
                }
            }
            ++i;
        }
        Collections.sort(themes);
        return BEnumRange.make((String[])themes.toArray(new String[themes.size()]));
    }

    private static final BDirectory getNSSDirectory(String themeModuleName) {
        BOrd ord = BOrd.make((String)("module://" + themeModuleName + "/nss"));
        try {
            BObject obj = ord.get();
            if (obj instanceof BDirectory && !obj.isNull()) {
                return (BDirectory)obj;
            }
            return null;
        }
        catch (ModuleNotFoundException mnfe) {
            mnfe.printStackTrace();
            return null;
        }
    }

    private static final String getDisplayNSSPath(String themeModuleName, BIFile file) {
        String nssPath = file.getFilePath().toString();
        if (!nssPath.endsWith(".nss")) {
            return null;
        }
        if (nssPath.startsWith("zip:/")) {
            nssPath = nssPath.substring(5);
        }
        if (nssPath.startsWith("nss/")) {
            nssPath = nssPath.substring(4);
        }
        if (nssPath.endsWith(".nss")) {
            nssPath = nssPath.substring(0, nssPath.indexOf(".nss"));
        }
        if ((nssPath = nssPath.equals("theme") ? themeModuleName : themeModuleName + '/' + nssPath).startsWith("theme")) {
            nssPath = nssPath.substring(5);
        }
        nssPath = SlotPath.escape((String)nssPath);
        return nssPath;
    }

    public static BDynamicEnum getModuleEnumForTag(String tag) {
        try {
            BEnum e = themeModules.get(tag);
            return BDynamicEnum.make((BEnum)e);
        }
        catch (InvalidEnumException e) {
            return CustomThemeModuleManager.getDefaultThemeEnum();
        }
    }

    public static BDynamicEnum getDefaultThemeEnum() {
        int[] ordinals;
        BEnum defaultThemeEnum = null;
        int i = 0;
        while (i < DEFAULT_THEMES.length) {
            String themeName = DEFAULT_THEMES[i];
            try {
                defaultThemeEnum = themeModules.get(SlotPath.escape((String)themeName));
                return BDynamicEnum.make((BEnum)defaultThemeEnum);
            }
            catch (InvalidEnumException invalidEnumException) {
                ++i;
            }
        }
        if (defaultThemeEnum == null && (ordinals = themeModules.getOrdinals()).length > 0) {
            return BDynamicEnum.make((BEnum)themeModules.get(ordinals[0]));
        }
        return BDynamicEnum.DEFAULT;
    }

    public static void installFromEnum(BDynamicEnum themeEnum) {
        String activeTheme = themeEnum.getTag();
        if (activeTheme == null || activeTheme.equals("0")) {
            logger.warning("Default theme module could not be loaded. Using default.");
            Theme.installDefaultTheme();
        } else {
            Theme.installCustomTheme(null, activeTheme);
        }
    }
}

