/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.TableTheme;
import com.tridium.ui.theme.custom.CustomWidgetTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.ui.BWidget;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.table.TableHeaderRenderer;
import javax.baja.ui.util.UiLexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CustomTableTheme
extends CustomWidgetTheme
implements TableTheme {
    private BFont cellFont;
    private BFont headerFont;
    private BBrush headerBrush;
    private double cellHeight;

    String getNSSSelector() {
        return "table";
    }

    public BFont getHeaderFont() {
        return this.headerFont;
    }

    public void setHeaderFont(BFont headerFont) {
        this.headerFont = headerFont;
    }

    public BBrush getHeaderTextBrush() {
        return this.headerBrush;
    }

    public void setHeaderTextBrush(BBrush hb) {
        this.headerBrush = hb;
    }

    public double getCellHeight() {
        return this.cellHeight;
    }

    public void setCellHeight(double cellHeight) {
        this.cellHeight = cellHeight;
    }

    public BFont getCellFont() {
        return this.cellFont;
    }

    public void setCellFont(BFont cellFont) {
        this.cellFont = cellFont;
    }

    public BFont getCellFont(IStylable widget) {
        return this.getTextFont(widget);
    }

    public BBrush getCellTextBrush() {
        return this.getTextBrush();
    }

    public void paintBackground(Graphics g, BWidget w) {
        g.setBrush(this.getControlBackground(w));
        g.fillRect(0.0, 0.0, w.getWidth(), w.getHeight());
    }

    public void paintHeaderBackground(Graphics g, TableHeaderRenderer.Header header, BBrush bg) {
        NSS headerNode = CustomTableTheme.getNSS().selectNode("table header");
        double x = 0.0;
        double y = 0.0;
        double w = header.width;
        double h = header.height;
        if (bg != null) {
            g.setBrush(bg);
        } else {
            g.setBrush((BBrush)headerNode.select("background-color"));
        }
        g.fillRect(x, y, w, h);
        g.setBrush((BBrush)headerNode.select("highlight"));
        g.strokeLine(x + 1.0, y + 1.0, x + w - (double)2, y + 1.0);
        g.strokeLine(x + 1.0, y + 1.0, x + 1.0, y + h - (double)2);
        g.setBrush((BBrush)headerNode.select("shadow"));
        g.strokeLine(x + w - 1.0, y + 1.0, x + w - 1.0, y + h - 1.0);
        g.strokeLine(x + 1.0, y + h - (double)2, x + w - 1.0, y + h - (double)2);
        g.setBrush((BBrush)headerNode.select("outline"));
        g.strokeRect(x, y, w, h - 1.0);
    }

    public double getSortIconWidth() {
        return 8.0;
    }

    public void paintSortIcon(Graphics g, TableHeaderRenderer.Header header, boolean ascending) {
        int c = 3;
        double mid = header.width - 8.0;
        double tip = (header.height - (double)c) / (double)2;
        g.setBrush(this.getControlShadow());
        int i = 0;
        while (i <= c) {
            if (ascending) {
                g.strokeLine(mid - (double)i, tip + (double)i, mid + (double)i, tip + (double)i);
            } else {
                g.strokeLine(mid - (double)i, tip + (double)c - (double)i, mid + (double)i, tip + (double)c - (double)i);
            }
            ++i;
        }
    }

    public BBrush getGridBrush() {
        return (BBrush)this.select("grid-color");
    }

    public BBrush getGridBrush(IStylable widget) {
        return (BBrush)this.select(widget, "grid-color");
    }

    public BBrush getBandBrush() {
        return (BBrush)this.select("band-color");
    }

    public BBrush getBandBrush(IStylable widget) {
        return (BBrush)this.select(widget, "band-color");
    }

    private final /* synthetic */ void this() {
        UiLexicon lex = UiLexicon.bajaui;
        this.cellHeight = lex.get("palladium.table.cellheight") != null ? Double.parseDouble(lex.get("palladium.table.cellheight")) : this.getPlainText().getHeight() + (double)3;
    }

    public CustomTableTheme() {
        this.this();
        NSS nss = CustomTableTheme.getNSS();
        this.reg(nss, "headerTextBrush", "table header color");
        this.reg(nss, "headerFont", "table header font");
        this.reg(nss, "cellFont", "table font");
        this.cellHeight = this.getCellFont().getHeight() + (double)3;
    }
}

