/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.SliderTheme;
import com.tridium.ui.theme.custom.CustomWidgetTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import javax.baja.gx.BBrush;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.PolygonGeom;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BSlider;
import javax.baja.ui.enums.BOrientation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CustomSliderTheme
extends CustomWidgetTheme
implements SliderTheme {
    private double fixedWidth;
    private double thumbWidth;

    String getNSSSelector() {
        return "slider";
    }

    public double getFixedWidth(BSlider s) {
        return this.getFixedWidth();
    }

    public double getThumbWidth(BSlider s) {
        return this.getThumbWidth();
    }

    public double getFixedWidth() {
        return this.fixedWidth;
    }

    public void setFixedWidth(double fw) {
        this.fixedWidth = fw;
    }

    public double getThumbWidth() {
        return this.thumbWidth;
    }

    public void setThumbWidth(double tw) {
        this.thumbWidth = tw;
    }

    public void paintTrack(Graphics g, BSlider s, RectGeom r) {
        BBrush brush = s.getTrackBrush();
        if (brush.isNull()) {
            brush = this.getControlBackground(s);
        }
        g.setBrush(brush);
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setBrush(this.getControlForeground(s));
        g.strokeRect(r.x, r.y, r.width, r.height);
        g.setBrush(this.getControlShadow(s));
        g.strokeLine(r.x + 1.0, r.y + 1.0, r.x + r.width - 1.0, r.y + 1.0);
        g.strokeLine(r.x + 1.0, r.y + 1.0, r.x + 1.0, r.y + r.height - 1.0);
        g.setBrush(this.getControlHighlight(s));
        g.strokeLine(r.x + (double)2, r.y + r.height - 1.0, r.x + r.width - 1.0, r.y + r.height - 1.0);
        g.strokeLine(r.x + r.width - 1.0, r.y + r.height - 1.0, r.x + r.width - 1.0, r.y + (double)2);
    }

    public void paintThumb(Graphics g, BSlider s, RectGeom r) {
        if (s.getOrientation() == BOrientation.horizontal) {
            this.paintThumbHoriz(g, s, r);
        } else {
            this.paintThumbVert(g, s, r);
        }
    }

    private final void paintThumbHoriz(Graphics g, BSlider s, RectGeom r) {
        double rx = r.x;
        double ry = r.y;
        double rw = r.width;
        double rh = r.height;
        double[] tx = new double[5];
        double[] ty = new double[5];
        tx[0] = rx;
        ty[0] = ry;
        tx[1] = rx;
        ty[1] = ry + rh - 6.0;
        tx[2] = rx + (rw - 1.0) / (double)2;
        ty[2] = ry + rh - 1.0;
        tx[3] = rx + rw - 1.0;
        ty[3] = ry + rh - 6.0;
        tx[4] = rx + rw - 1.0;
        ty[4] = ry;
        PolygonGeom thumb = new PolygonGeom(tx, ty, 5);
        BBrush brush = s.getThumbBrush();
        if (brush.isNull()) {
            brush = (BBrush)this.select(s, "thumb background-color");
        }
        g.setBrush(brush);
        g.fill((IGeom)thumb);
        g.setBrush((BBrush)this.select(s, "thumb outline"));
        g.stroke((IGeom)thumb);
        g.setBrush((BBrush)this.select(s, "thumb highlight"));
        g.strokeLine(r.x + 1.0, r.y + 1.0, r.x + r.width - (double)3, r.y + 1.0);
        g.strokeLine(r.x + 1.0, r.y + 1.0, r.x + 1.0, r.y + r.height - 6.0);
        g.setBrush((BBrush)this.select(s, "thumb shadow"));
        g.strokeLine(rx + rw - (double)2, ry + 1.0, rx + rw - (double)2, ry + rh - 6.0);
        g.strokeLine(rx + (rw - 1.0) / (double)2, ry + rh - (double)2, rx + rw - (double)2, ry + rh - 6.0);
        double x = rx + (double)4;
        double y = ry + (double)4;
        g.setBrush((BBrush)this.select(s, "thumb highlight"));
        g.strokeLine(x, y + 1.0, x + (double)2, y + 1.0);
        g.strokeLine(x, y + (double)5, x + (double)2, y + (double)5);
        g.setBrush((BBrush)this.select(s, "thumb shadow"));
        g.strokeLine(x, y, x, y + 1.0);
        g.strokeLine(x, y + (double)4, x, y + (double)5);
        g.strokeLine(x, y, x + (double)2, y);
        g.strokeLine(x, y + (double)4, x + (double)2, y + (double)4);
    }

    private final void paintThumbVert(Graphics g, BSlider s, RectGeom r) {
        double rx = r.x;
        double ry = r.y;
        double rw = r.width;
        double rh = r.height;
        double[] tx = new double[5];
        double[] ty = new double[5];
        tx[0] = rx;
        ty[0] = ry;
        tx[1] = rx + rw - 6.0;
        ty[1] = ry;
        tx[2] = rx + rw - 1.0;
        ty[2] = ry + (rh - 1.0) / (double)2;
        tx[3] = rx + rw - 6.0;
        ty[3] = ry + rh - 1.0;
        tx[4] = rx;
        ty[4] = ry + rh - 1.0;
        PolygonGeom thumb = new PolygonGeom(tx, ty, 5);
        BBrush brush = s.getThumbBrush();
        if (brush.isNull()) {
            brush = (BBrush)this.select(s, "thumb background-color");
        }
        g.setBrush(brush);
        g.fill((IGeom)thumb);
        g.setBrush((BBrush)this.select(s, "thumb outline"));
        g.stroke((IGeom)thumb);
        g.setBrush((BBrush)this.select(s, "thumb highlight"));
        g.strokeLine(rx + 1.0, ry + 1.0, rx + rw - 6.0, ry + 1.0);
        g.strokeLine(rx + 1.0, ry + 1.0, rx + 1.0, ry + rh - (double)3);
        g.setBrush((BBrush)this.select(s, "thumb shadow"));
        g.strokeLine(rx + 1.0, ry + rh - (double)2, rx + rw - 6.0, ry + rh - (double)2);
        g.strokeLine(rx + rw - (double)2, ry + (rh - 1.0) / (double)2, rx + rw - 6.0, ry + rh - (double)2);
        double x = rx + (double)4;
        double y = ry + (double)4;
        g.setBrush((BBrush)this.select(s, "thumb highlight"));
        g.strokeLine(x + 1.0, y, x + 1.0, y + (double)2);
        g.strokeLine(x + (double)5, y, x + (double)5, y + (double)2);
        g.setBrush((BBrush)this.select(s, "thumb shadow"));
        g.strokeLine(x, y, x + 1.0, y);
        g.strokeLine(x + (double)4, y, x + (double)5, y);
        g.strokeLine(x, y, x, y + (double)2);
        g.strokeLine(x + (double)4, y, x + (double)4, y + (double)2);
    }

    private final /* synthetic */ void this() {
        this.fixedWidth = 17.0;
        this.thumbWidth = 11.0;
    }

    public CustomSliderTheme() {
        this.this();
        NSS nss = CustomSliderTheme.getNSS();
        NSS slider = nss.selectNode("slider");
        this.reg(slider, "fixedWidth", "track width");
        this.reg(slider, "thumbWidth", "thumb width");
    }
}

