/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.PropertySheetTreeTheme;
import com.tridium.ui.theme.custom.CustomTreeTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import javax.baja.gx.BBrush;
import javax.baja.gx.Graphics;
import javax.baja.ui.BWidget;
import javax.baja.ui.style.IStylable;

public class CustomPropertySheetTreeTheme
extends CustomTreeTheme
implements PropertySheetTreeTheme {
    String getNSSSelector() {
        return "tree property-sheet";
    }

    public void paintExpander(Graphics g, BWidget propEntry, double x, double y, boolean isExpandable, boolean isExpanded) {
        double height = this.getExpanderHeight();
        double width = this.getExpanderWidth();
        g.setBrush(this.getControlHighlight(propEntry));
        g.strokeLine(x, y, x + width - 1.0, y);
        g.strokeLine(x, y, x, y + height - 1.0);
        g.setBrush(this.getControlShadow(propEntry));
        g.strokeLine(x + width - 1.0, y, x + width - 1.0, y + height - 1.0);
        g.strokeLine(x, y + height - 1.0, x + width - 1.0, y + height - 1.0);
        if (isExpandable) {
            g.setBrush(this.getExpanderBrush(propEntry));
            double midx = x + (double)((int)(width / (double)2));
            double midy = y + (double)((int)(height / (double)2));
            g.strokeLine(x + (double)2, midy, x + width - (double)3, midy);
            if (!isExpanded) {
                g.strokeLine(midx, y + (double)2, midx, y + height - (double)3);
            }
        }
    }

    public BBrush getDividerColor(IStylable widget) {
        return (BBrush)this.select(widget, "divider color");
    }

    public BBrush getHeaderColor(IStylable widget) {
        return (BBrush)this.select(widget, "header color");
    }

    public BBrush getHeaderBackground(IStylable widget) {
        return (BBrush)this.select(widget, "header background-color");
    }

    public CustomPropertySheetTreeTheme() {
        NSS nss = CustomPropertySheetTreeTheme.getNSS();
        NSS tree = nss.selectNode("tree property-sheet");
        NSS expander = tree.selectNode("expander");
        this.reg(expander, "expanderWidth", "width");
        this.reg(expander, "expanderHeight", "height");
    }
}

