/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.MenuItemTheme;
import com.tridium.ui.theme.custom.CustomWidgetTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.ui.BCheckBoxMenuItem;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BRadioButtonMenuItem;
import javax.baja.ui.style.IStylable;

public class CustomMenuItemTheme
extends CustomWidgetTheme
implements MenuItemTheme {
    private BInsets insets;
    private BFont acceleratorFont;
    private BBrush acceleratorBrush;
    private double iconIndent;

    String getNSSSelector() {
        return "menu-item";
    }

    public BInsets getInsets() {
        return this.insets;
    }

    public void setInsets(BInsets i) {
        this.insets = i;
    }

    public double getIconIndent() {
        return this.iconIndent;
    }

    public void setIconIndent(double iconIndent) {
        this.iconIndent = iconIndent;
    }

    public BFont getAcceleratorFont() {
        return this.acceleratorFont;
    }

    public void setAcceleratorFont(BFont af) {
        this.acceleratorFont = af;
    }

    public BBrush getAcceleratorBrush() {
        return this.acceleratorBrush;
    }

    public void setAcceleratorBrush(BBrush ab) {
        this.acceleratorBrush = ab;
    }

    public void paintDisabledText(Graphics g, IStylable widget, String s, double x, double y) {
        g.setBrush(this.getControlHighlight(widget));
        g.drawString(s, x + 1.0, y + 1.0);
        g.setBrush(this.getControlShadow(widget));
        g.drawString(s, x, y);
    }

    public void paintBackground(Graphics g, BMenuItem m, boolean selected) {
        if (selected) {
            g.setBrush(this.getSelectionBackground(m));
        } else {
            g.setBrush(this.getControlBackground(m));
        }
        g.fillRect(0.0, 0.0, m.getWidth(), m.getHeight());
    }

    public void paintSubMenuArrow(Graphics g, BMenuItem m, boolean selected) {
        double w = m.getWidth();
        double h = m.getHeight();
        double mid = h / (double)2;
        double x = w - (double)4;
        if (m.getEnabled()) {
            if (selected) {
                g.setBrush(this.getSelectionForeground());
            } else {
                g.setBrush(this.getControlForeground());
            }
        } else {
            g.setBrush(this.getTextDisabled());
        }
        g.strokeLine(x, mid, x, mid + 0.0);
        g.strokeLine(x -= 1.0, mid - 1.0, x, mid + 1.0);
        g.strokeLine(x -= 1.0, mid - (double)2, x, mid + (double)2);
        g.strokeLine(x -= 1.0, mid - (double)3, x, mid + (double)3);
        g.strokeLine(x -= 1.0, mid - (double)4, x, mid + (double)4);
        x -= 1.0;
    }

    public void paintCheckBox(Graphics g, BCheckBoxMenuItem m, boolean selected) {
        if (m.getSelected()) {
            double h = m.getHeight();
            double x = this.insets.left / (double)2 - (double)4;
            double y = h / (double)2 + (double)2;
            if (m.getEnabled()) {
                g.setBrush(this.getControlForeground());
            } else {
                g.setBrush(this.getControlShadow());
            }
            g.strokeLine(x, y, x + 1.0, y - 1.0);
            g.strokeLine(x + 1.0, y + 1.0, x + 6.0, y - (double)4);
            g.strokeLine(x + (double)2, y + (double)2, x + 7.0, y - (double)3);
            g.strokeLine(x + 1.0, y, x + (double)2, y + 1.0);
            g.strokeLine(x + (double)2, y + 1.0, x + 6.0, y - (double)3);
        }
    }

    public void paintRadioBox(Graphics g, BRadioButtonMenuItem m, boolean selected) {
        if (m.getSelected()) {
            double w = 4;
            double h = 4;
            double x = this.insets.left / (double)2 - w / (double)2;
            double y = m.getHeight() / (double)2 - h / (double)2 + 1.0;
            if (m.getEnabled()) {
                g.setBrush(this.getControlForeground());
            } else {
                g.setBrush(this.getControlShadow());
            }
            g.strokeLine(x, y + h / (double)2, x + w / (double)2, y);
            g.strokeLine(x + 1.0, y + h / (double)2 + 1.0, x + w / (double)2 + 1.0, y + 1.0);
            g.strokeLine(x + (double)2, y + h / (double)2 + (double)2, x + w / (double)2 + (double)2, y + (double)2);
            g.strokeLine(x + 1.0, y + h / (double)2, x + w / (double)2, y + 1.0);
            g.strokeLine(x + (double)2, y + h / (double)2 + 1.0, x + w / (double)2 + 1.0, y + (double)2);
        }
    }

    public CustomMenuItemTheme() {
        NSS nss = CustomMenuItemTheme.getNSS();
        NSS menuItem = nss.selectNode("menu-item");
        this.regFallbackValue(menuItem, "insets", "padding", "2 14 2 22");
        this.regFallbackValue(menuItem, "iconIndent", "icon-indent", "2");
        this.regFallbackSelector(nss, "acceleratorBrush", "menu-item accelerator color", "selection-background-color");
        BFont acceleratorFont = (BFont)menuItem.selectProperty("accelerator font");
        if (acceleratorFont == null) {
            BFont font = this.getTextFont();
            acceleratorFont = BFont.make((String)font.getName(), (double)(font.getSize() - 1.0), (int)font.getStyle());
        }
        this.setAcceleratorFont(acceleratorFont);
    }
}

