/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.DropDownTheme;
import com.tridium.ui.theme.custom.CustomThemeUtils;
import com.tridium.ui.theme.custom.CustomWidgetTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BWidget;

public class CustomDropDownTheme
extends CustomWidgetTheme
implements DropDownTheme {
    private BInsets insets;

    String getNSSSelector() {
        return "drop-down";
    }

    public BInsets getBorderInsets() {
        return this.insets;
    }

    public void setBorderInsets(BInsets insets) {
        this.insets = insets;
    }

    public void paintBorder(Graphics g, BWidget widget) {
        this.paintBorder(g, widget, 0.0, 0.0, widget.getWidth(), widget.getHeight());
    }

    public void paintBorder(Graphics g, BWidget widget, double x, double y, double w, double h) {
        if (x != 0.0 || y != 0.0) {
            g.translate(x, y);
        }
        g.setBrush(this.getControlForeground(widget));
        g.strokeRect(1.0, 1.0, w - (double)3, h - (double)3);
        g.setBrush(this.getControlShadow(widget));
        g.strokeLine(0.0, 0.0, w - 1.0, 0.0);
        g.strokeLine(0.0, 0.0, 0.0, h - 1.0);
        g.setBrush(this.getControlHighlight(widget));
        g.strokeLine(w - 1.0, 1.0, w - 1.0, h - 1.0);
        g.strokeLine(1.0, h - 1.0, w - 1.0, h - 1.0);
        if (x != 0.0 || y != 0.0) {
            g.translate(-x, -y);
        }
    }

    public void paintButton(Graphics g, BWidget widget, RectGeom r, boolean isDepressed) {
        double x = r.x - 1.0;
        double y = r.y - 1.0;
        double w = r.width + 1.0;
        double h = r.height + 1.0;
        g.setBrush((BBrush)this.select(widget, "button background-color"));
        g.fillRect(x, y, w, h);
        g.setBrush((BBrush)this.select(widget, "button outline"));
        g.strokeRect(x, y, w, h);
        if (isDepressed) {
            g.setBrush((BBrush)this.select(widget, "button shadow"));
        } else {
            g.setBrush((BBrush)this.select(widget, "button highlight"));
        }
        g.strokeLine(x + 1.0, y + 1.0, x + w - (double)2, y + 1.0);
        g.strokeLine(x + 1.0, y + 1.0, x + 1.0, y + h - 1.0);
        g.setBrush((BBrush)this.select(widget, "button shadow"));
        g.strokeLine(x + w - 1.0, y + 1.0, x + w - 1.0, y + h - 1.0);
        g.strokeLine(x + 1.0, y + h - 1.0, x + w - 1.0, y + h - 1.0);
        g.setBrush((BBrush)this.select(widget, "button color"));
        boolean off = isDepressed;
        int dir = 1;
        CustomThemeUtils.paintArrow(g, dir, x + (double)off, y + (double)off, w, h);
    }

    public void paintBackground(Graphics g, BWidget w) {
        g.setBrush(this.getControlBackground(w));
        g.fillRect(0.0, 0.0, w.getWidth(), w.getHeight());
    }

    public BBrush getDisabledBackgroundBrush(BWidget w) {
        return this.getControlBackground(w);
    }

    public CustomDropDownTheme() {
        NSS nss = CustomDropDownTheme.getNSS();
        this.regFallbackValue(nss, "borderInsets", "drop-down padding", "2");
    }
}

