/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.CheckBoxTheme;
import com.tridium.ui.theme.custom.CustomToggleButtonTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IPoint;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BToggleButton;

public class CustomCheckBoxTheme
extends CustomToggleButtonTheme
implements CheckBoxTheme {
    private int checkBoxSize;

    String getNSSSelector() {
        return "button checkbox";
    }

    public BFont getTextFont() {
        return this.getPlainText();
    }

    public IPoint getLabelOffset(BAbstractButton button) {
        return this.noOffset;
    }

    public int getCheckBoxSize() {
        return this.checkBoxSize;
    }

    public void setCheckBoxSize(int checkBoxSize) {
        this.checkBoxSize = checkBoxSize;
    }

    public void paintBackground(Graphics g, BAbstractButton b) {
        boolean mouseOver = b.isMouseOver();
        boolean pressed = b.isPressed();
        boolean selected = ((BToggleButton)b).isSelected();
        BBrush bg = b.getBackground();
        if (!bg.isNull()) {
            g.setBrush(bg);
            g.fillRect(0.0, 0.0, b.getWidth(), b.getHeight());
        }
        double x = 0.0;
        double y = b.getHeight() / (double)2 - (double)(this.checkBoxSize / 2);
        double w = this.checkBoxSize - 1;
        double h = this.checkBoxSize - 1;
        g.setBrush(this.getControlBackground(b));
        g.fillRect(x, y, w, h);
        g.setBrush(this.getControlForeground(b));
        g.strokeRect(x, y, w, h);
        if (pressed && mouseOver) {
            g.setBrush(this.getControlShadow(b));
        } else {
            g.setBrush(this.getControlHighlight(b));
        }
        g.strokeLine(x + 1.0, y + 1.0, x + w - (double)2, y + 1.0);
        g.strokeLine(x + 1.0, y + 1.0, x + 1.0, y + h - (double)2);
        g.setBrush(this.getControlShadow(b));
        g.strokeLine(x + w - 1.0, y + 1.0, x + w - 1.0, y + h - 1.0);
        g.strokeLine(x + 1.0, y + h - 1.0, x + w - 1.0, y + h - 1.0);
        if (selected) {
            x = w / (double)2 - (double)4;
            y = b.getHeight() / (double)2;
            g.setBrush(this.getControlForeground(b));
            g.strokeLine(x, y, x + 1.0, y - 1.0);
            g.strokeLine(x + 1.0, y + 1.0, x + 6.0, y - (double)4);
            g.strokeLine(x + (double)2, y + (double)2, x + 7.0, y - (double)3);
            g.strokeLine(x + 1.0, y, x + (double)2, y + 1.0);
            g.strokeLine(x + (double)2, y + 1.0, x + 6.0, y - (double)3);
            g.setBrush(this.getControlShadow(b));
            g.strokeLine(x + (double)3, y + (double)2, x + 7.0, y - (double)2);
            g.strokeLine(x + (double)3, y + (double)3, x + 8.0, y - (double)2);
        }
        if (b.hasFocus() && b.isFocusTraversable() && b.getText() != null && b.getText().length() > 0) {
            BInsets padding = this.getNormalPadding();
            x = padding.left - (double)2;
            y = padding.top;
            w = b.getWidth() - (x + padding.right);
            h = b.getHeight() - (y + padding.bottom);
            this.paintFocus(g, new RectGeom(x, y, w, h));
        }
    }

    public CustomCheckBoxTheme() {
        NSS nss = CustomCheckBoxTheme.getNSS();
        NSS checkBox = nss.selectNode("button checkbox");
        this.regFallbackValue(checkBox, "normalPadding", "padding", "2 2 2 18");
        this.regFallbackValue(checkBox, "checkBoxSize", "size", "13");
    }
}

