/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.AbstractButtonTheme;
import com.tridium.ui.theme.custom.CustomLabelTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IInsets;
import javax.baja.gx.IPoint;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.style.IStylable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class CustomAbstractButtonTheme
extends CustomLabelTheme
implements AbstractButtonTheme {
    private BInsets normalPadding;
    private BInsets toolbarPadding;
    private double menuWidth;
    Point noOffset;
    Point pressedOffset;

    String getNSSSelector() {
        return "button";
    }

    public IInsets getPadding(BAbstractButton b) {
        if (b.getButtonStyle() == BButtonStyle.toolBar) {
            return this.toolbarPadding;
        }
        return this.normalPadding;
    }

    public BInsets getNormalPadding() {
        return this.normalPadding;
    }

    public void setNormalPadding(BInsets np) {
        this.normalPadding = np;
    }

    public BInsets getToolbarPadding() {
        return this.toolbarPadding;
    }

    public void setToolbarPadding(BInsets tp) {
        this.toolbarPadding = tp;
    }

    public IPoint getLabelOffset(BAbstractButton b) {
        BAbstractButton.MenuController c = b.getMenuController();
        if (c != null && !c.isMenuDistinct() && b.isMenuPressed()) {
            return this.pressedOffset;
        }
        if (b.isPressed() && b.isMouseOver()) {
            return this.pressedOffset;
        }
        if (b instanceof BToggleButton && ((BToggleButton)b).isSelected()) {
            return this.pressedOffset;
        }
        return this.noOffset;
    }

    public double getMenuWidth() {
        return this.menuWidth;
    }

    public void setMenuWidth(double menuWidth) {
        this.menuWidth = menuWidth;
    }

    public void paintDisabledText(Graphics g, IStylable widget, String s, double x, double y) {
        g.setBrush(this.getControlHighlight(widget));
        g.drawString(s, x + 1.0, y + 1.0);
        g.setBrush(this.getTextBrush(widget));
        g.drawString(s, x, y);
    }

    public void paintBackground(Graphics g, BAbstractButton b) {
        boolean enabled = b.getEnabled();
        boolean mouseOver = b.isMouseOver();
        boolean pressed = b.isPressed();
        boolean menuPressed = b.isMenuPressed();
        boolean bl = false;
        if (b.getMenuController() != null) {
            bl = true;
        }
        boolean hasMenu = bl;
        boolean bl2 = false;
        if (hasMenu) {
            bl2 = b.getMenuController().isMenuDistinct();
        }
        boolean distinct = bl2;
        boolean selected = false;
        if (b instanceof BToggleButton) {
            selected = ((BToggleButton)b).isSelected();
        }
        double w = b.getWidth();
        double h = b.getHeight();
        double mw = this.getMenuWidth();
        if (hasMenu) {
            w -= this.getMenuWidth();
        }
        boolean drawOutline = true;
        boolean drawShading = true;
        if (!hasMenu) {
            distinct = true;
        }
        if (!(b.getButtonStyle() != BButtonStyle.toolBar || mouseOver && enabled || menuPressed)) {
            drawOutline = false;
            if (!selected) {
                drawShading = false;
            }
        }
        BBrush bg = this.getBackground(b, pressed, selected);
        g.setBrush(bg);
        g.fillRect(1.0, 1.0, w - (double)2 + (hasMenu ? this.getMenuWidth() : 0.0), h - (double)2);
        if (drawOutline) {
            g.setBrush(this.getControlForeground(b));
            g.strokeRect(0.0, 0.0, !distinct ? w - 1.0 + mw : w - 1.0, h - 1.0);
            if (hasMenu && distinct) {
                g.strokeRect(w - 1.0, 0.0, mw, h - 1.0);
            }
        }
        if (drawShading) {
            if (menuPressed && !distinct || !menuPressed && pressed && mouseOver || selected) {
                g.setBrush(this.getControlShadow(b));
            } else {
                g.setBrush(this.getControlHighlight(b));
            }
            double tempw = w + (!distinct ? mw : 0.0);
            g.strokeLine(1.0, 1.0, tempw - (double)3, 1.0);
            g.strokeLine(1.0, 1.0, 1.0, h - (double)3);
            if (hasMenu && distinct && (b.getButtonStyle() != BButtonStyle.toolBar || pressed || mouseOver)) {
                if (menuPressed) {
                    g.setBrush(this.getControlShadow(b));
                } else {
                    g.setBrush(this.getControlHighlight(b));
                }
                g.strokeLine(w, 1.0, w + mw - (double)3, 1.0);
                g.strokeLine(w, 1.0, w, h - (double)3);
            }
            g.setBrush(this.getControlShadow(b));
            g.strokeLine(tempw - (double)2, 1.0, tempw - (double)2, h - (double)2);
            g.strokeLine(1.0, h - (double)2, tempw - (double)2, h - (double)2);
            if (hasMenu && distinct && (b.getButtonStyle() != BButtonStyle.toolBar || pressed || mouseOver)) {
                g.strokeLine(w + mw - (double)2, 1.0, w + mw - (double)2, h - (double)2);
                g.strokeLine(w, h - (double)2, w + mw - (double)2, h - (double)2);
            }
        }
        if (hasMenu) {
            g.setBrush(this.getTextBrush(b));
            int arrowWidth = 3;
            int mid = (int)w + (int)this.getMenuWidth() - arrowWidth - 4;
            if (!distinct && b.getButtonStyle() != BButtonStyle.toolBar) {
                mid -= 3;
            }
            int bottom = arrowWidth + ((int)h - arrowWidth) / 2 - 1;
            if (menuPressed) {
                mid = (int)((double)mid + this.pressedOffset.x);
                bottom = (int)((double)bottom + this.pressedOffset.y);
            }
            int i = 0;
            while (i < arrowWidth) {
                g.strokeLine((double)(mid - i), (double)(bottom - i), (double)(mid + i), (double)(bottom - i));
                ++i;
            }
        }
        if (b.hasFocus() && b.getButtonStyle() != BButtonStyle.toolBar) {
            this.paintFocus(g, new RectGeom((double)3, (double)3, w - 7.0, h - 7.0));
        }
        this.paintDefaultBorder(g, b, pressed);
    }

    protected BBrush getBackground(BAbstractButton b, boolean isDepressed, boolean isSelected) {
        return b.getBackground().isNull() ? this.getControlBackground(b) : b.getBackground();
    }

    protected void paintDefaultBorder(Graphics g, BAbstractButton b, boolean isDepressed) {
    }

    private final /* synthetic */ void this() {
        this.noOffset = new Point(0.0, 0.0);
        this.pressedOffset = new Point(1.0, 1.0);
    }

    public CustomAbstractButtonTheme() {
        this.this();
        NSS nss = CustomAbstractButtonTheme.getNSS();
        NSS button = nss.selectNode("button");
        this.regFallbackValue(button, "normalPadding", "padding", "5 13");
        this.regFallbackValue(button, "toolbarPadding", "toolbar-padding", "3");
        this.regFallbackValue(button, "menuWidth", "menu-width", "11");
    }
}

