/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.curium;

import com.tridium.ui.theme.TreeTheme;
import com.tridium.ui.theme.curium.CuriumWidgetTheme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.ui.BWidget;

public class CuriumTreeTheme
extends CuriumWidgetTheme
implements TreeTheme {
    static final double ICON_WIDTH = 16.0;
    static final double ICON_HEIGHT = 16.0;
    static final double EXPANDER_WIDTH = 25.0;
    static final double EXPANDER_HEIGHT = 25.0;
    static final BInsets insets = BInsets.make((double)2, (double)4, (double)2, (double)4);
    static final BBrush expanderBrush = BColor.black.toBrush();
    static final BBrush connectingBrush = BColor.make((int)192, (int)192, (int)192).toBrush();

    public BFont getFont(BWidget tree) {
        return plainText;
    }

    public BBrush getForeground(BWidget tree) {
        return windowForeground;
    }

    public BBrush getBackground(BWidget tree) {
        return windowBackground;
    }

    public BBrush getSelectionForeground() {
        return selectionForeground;
    }

    public BBrush getSelectionBackground() {
        return selectionBackground;
    }

    public BBrush getConnectingBrush(BWidget tree) {
        return connectingBrush;
    }

    public double getExpanderHeight() {
        return 25.0;
    }

    public double getExpanderWidth() {
        return 25.0;
    }

    public boolean inExpander(double expX, double expY, double x, double y) {
        boolean bl = false;
        if (x >= expX && x <= expX + 25.0 && y >= expY && y <= expY + 25.0) {
            bl = true;
        }
        return bl;
    }

    public void paintExpander(Graphics g, BWidget tree, double x, double y, boolean expanded) {
        BBrush origBrush = g.getBrush();
        double w = 24.0;
        double h = 24.0;
        g.setBrush(connectingBrush);
        g.strokeLine(x, y, x + w, y);
        g.strokeLine(x, y, x, y + h);
        g.strokeLine(x + w, y, x + w, y + h);
        g.strokeLine(x, y + h, x + w, y + h);
        g.setBrush(expanderBrush);
        double pad = Math.max(8.0, (double)2);
        g.strokeLine(x + pad, y + 12.0, x + (24.0 - pad), y + 12.0);
        if (!expanded) {
            g.strokeLine(x + 12.0, y + pad, x + 12.0, y + (24.0 - pad));
        }
        g.setBrush(origBrush);
    }

    public void paintExpander(Graphics g, BWidget tree, double x, double y, boolean isExpandable, boolean isExpanded) {
        this.paintExpander(g, tree, x, y, isExpanded);
    }

    public BInsets getInsets() {
        return insets;
    }

    public BInsets getInsets(BWidget widget) {
        return insets;
    }
}

