/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.curium;

import com.tridium.ui.theme.WidgetTheme;
import com.tridium.ui.theme.curium.CuriumWidgetTheme;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.ui.enums.BOrientation;

public class CuriumThemeUtils {
    public static final int UP = 0;
    public static final int DOWN = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;

    public static void paintThumb(WidgetTheme theme, Graphics g, BOrientation orientation, RectGeom r) {
        block11: {
            double sz;
            double ib;
            double numi;
            double is;
            double ih;
            double iw;
            double iy;
            double ix;
            double h;
            double w;
            double y;
            double x;
            block10: {
                if (orientation == BOrientation.vertical) {
                    x = r.x + 1.0;
                    y = r.y;
                    w = r.width - (double)3;
                    h = r.height - 1.0;
                } else {
                    x = r.x;
                    y = r.y + 1.0;
                    w = r.width - 1.0;
                    h = r.height - (double)3;
                }
                if (w <= 0.0 || h <= 0.0) {
                    return;
                }
                g.setBrush(theme.getControlForeground());
                if (orientation == BOrientation.vertical) {
                    g.strokeRect(r.x, r.y - 1.0, r.width - 1.0, r.height + 1.0);
                } else {
                    g.strokeRect(r.x - 1.0, r.y, r.width + 1.0, r.height - 1.0);
                }
                g.setBrush(theme.getControlBackground());
                g.fillRect(x + 1.0, y + 1.0, w - 1.0, h - 1.0);
                g.setBrush(theme.getControlHighlight());
                g.strokeLine(x, y, x + w, y);
                g.strokeLine(x, y, x, y + h);
                g.setBrush(theme.getControlShadow());
                g.strokeLine(x + w, y, x + w, y + h);
                g.strokeLine(x, y + h, x + w, y + h);
                ix = 0.0;
                iy = 0.0;
                iw = 0.0;
                ih = 0.0;
                is = 2;
                numi = 3;
                ib = 3;
                sz = 0.0;
                if (orientation != BOrientation.vertical) break block10;
                iw = (int)(w * 0.625);
                ih = 2;
                sz = ih * numi + is * (numi - 1.0) + ib + ib;
                while (sz > h && numi != 0.0) {
                    sz = (numi -= 1.0) == 1.0 ? ih * numi + ib + ib : ih * numi + is * (numi - 1.0) + ib + ib;
                }
                if (!(numi > 0.0)) break block11;
                ix = x + (w - iw) / (double)2 + 1.0;
                iy = y + ib + (h - sz) / (double)2 + 1.0;
                int j = 0;
                while ((double)j < numi) {
                    g.setBrush(theme.getControlShadow());
                    g.strokeLine(ix, iy, ix + iw - (double)2, iy);
                    g.strokeLine(ix, iy, ix, iy + ih - 1.0);
                    g.setBrush(theme.getControlHighlight());
                    g.strokeLine(ix + iw - 1.0, iy, ix + iw - 1.0, iy + ih - 1.0);
                    g.strokeLine(ix + iw - 1.0, iy + ih - 1.0, ix + 1.0, iy + ih - 1.0);
                    iy += ih + is;
                    ++j;
                }
                break block11;
            }
            iw = 2;
            ih = h * 0.625;
            sz = iw * numi + is * (numi - 1.0) + ib + ib;
            while (sz > w && numi != 0.0) {
                sz = (numi -= 1.0) == 1.0 ? iw * numi + ib + ib : iw * numi + is * (numi - 1.0) + ib + ib;
            }
            if (numi > 0.0) {
                ix = x + ib + (w - sz) / (double)2 + 1.0;
                iy = y + (h - ih) / (double)2 + 1.0;
                int j = 0;
                while ((double)j < numi) {
                    g.setBrush(theme.getControlShadow());
                    g.strokeLine(ix, iy, ix + iw - 1.0, iy);
                    g.strokeLine(ix, iy, ix, iy + ih - 1.0);
                    g.setBrush(theme.getControlHighlight());
                    g.strokeLine(ix + iw - 1.0, iy + 1.0, ix + iw - 1.0, iy + ih - 1.0);
                    g.strokeLine(ix + iw - 1.0, iy + ih - 1.0, ix, iy + ih - 1.0);
                    ix += iw + is;
                    ++j;
                }
            }
        }
    }

    public static void paintArrow(Graphics g, int dir, RectGeom r) {
        CuriumThemeUtils.paintArrow(g, dir, (int)r.x, (int)r.y, (int)r.width, (int)r.height);
    }

    public static void paintArrow(Graphics g, int dir, double x, double y, double w, double h) {
        double aw = 7.0;
        double ah = 4;
        switch (dir) {
            case 0: {
                x += (double)Math.round((w - aw) / (double)2);
                y += (double)Math.round((h - ah) / (double)2) + ah / (double)2;
                int i = 0;
                while ((double)i < ah) {
                    g.strokeLine(x + (double)i, y - (double)i, x + aw - (double)i - 1.0, y - (double)i);
                    ++i;
                }
                break;
            }
            case 1: {
                x += (double)Math.round((w - aw) / (double)2);
                y += (double)Math.round((h - ah) / (double)2);
                int i = 0;
                while ((double)i < ah) {
                    g.strokeLine(x + (double)i, y + (double)i, x + aw - (double)i - 1.0, y + (double)i);
                    ++i;
                }
                break;
            }
            case 2: {
                x += (double)Math.round((w - ah) / (double)2) + ah / (double)2;
                y += (double)Math.round((h - aw) / (double)2);
                int i = 0;
                while ((double)i < ah) {
                    g.strokeLine(x - (double)i, y + (double)i, x - (double)i, y + aw - (double)i - 1.0);
                    ++i;
                }
                break;
            }
            case 3: {
                x += (double)Math.round((w - ah) / (double)2);
                y += (double)Math.round((h - aw) / (double)2);
                int i = 0;
                while ((double)i < ah) {
                    g.strokeLine(x + (double)i, y + (double)i, x + (double)i, y + aw - (double)i - 1.0);
                    ++i;
                }
                break;
            }
        }
    }

    public static BInsets calcTextBoxInsets() {
        double MIN_TB_INSET = 3;
        double DESIRED_HEIGHT = 35.0;
        double fh = CuriumWidgetTheme.fixedWidth.getHeight();
        double tb = (35.0 - fh) / (double)2;
        tb = Math.max((double)3, tb);
        return BInsets.make((double)tb, (double)3, (double)tb, (double)3);
    }
}

