/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.curium;

import com.tridium.ui.theme.ScrollBarTheme;
import com.tridium.ui.theme.curium.CuriumThemeUtils;
import com.tridium.ui.theme.curium.CuriumWidgetTheme;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.enums.BOrientation;

public class CuriumScrollBarTheme
extends CuriumWidgetTheme
implements ScrollBarTheme {
    public static final int UP = 0;
    public static final int DOWN = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;

    public double getFixedWidth() {
        return 30.0;
    }

    public void paintButton(Graphics g, BScrollBar sb, RectGeom r, int dir, boolean isPressed) {
        g.setBrush(this.getControlForeground());
        g.strokeRect(r.x, r.y, r.width - 1.0, r.height - 1.0);
        g.setBrush(this.getControlBackground());
        g.fillRect(r.x + (double)2, r.y + (double)2, r.width - (double)4, r.height - (double)4);
        if (isPressed) {
            g.setBrush(this.getControlShadow());
        } else {
            g.setBrush(this.getControlHighlight());
        }
        g.strokeLine(r.x + 1.0, r.y + 1.0, r.x + r.width - (double)3, r.y + 1.0);
        g.strokeLine(r.x + 1.0, r.y + 1.0, r.x + 1.0, r.y + r.height - (double)3);
        if (sb.getEnabled()) {
            g.setBrush(this.getControlShadow());
        } else {
            g.setBrush(this.getControlAuxiliary());
        }
        g.strokeLine(r.x + r.width - (double)2, r.y + 1.0, r.x + r.width - (double)2, r.y + r.height - (double)2);
        g.strokeLine(r.x + 1.0, r.y + r.height - (double)2, r.x + r.width - (double)2, r.y + r.height - (double)2);
        if (sb.getEnabled()) {
            g.setBrush(this.getControlForeground());
        } else {
            g.setBrush(this.getControlShadow());
        }
        int n = isPressed;
        CuriumThemeUtils.paintArrow(g, dir, (int)r.x + n, (int)r.y + n, (int)r.width, (int)r.height);
    }

    public void paintTrack(Graphics g, BScrollBar sb, RectGeom r) {
        int ay2;
        int by2;
        int ay1;
        int by1;
        int bx1;
        int bx2;
        int ax1;
        int ax2;
        if (sb.getOrientation() == BOrientation.vertical) {
            ax1 = ax2 = (int)r.x;
            bx1 = bx2 = (int)r.x + (int)r.width - 1;
            ay1 = by1 = (int)r.y;
            ay2 = by2 = (int)r.y + (int)r.height - 1;
        } else {
            ax1 = bx1 = (int)r.x;
            ax2 = bx2 = (int)r.x + (int)r.width - 1;
            ay1 = ay2 = (int)r.y;
            by1 = by2 = (int)r.y + (int)r.height - 1;
        }
        g.setBrush(this.getControlAuxiliary());
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setBrush(this.getControlForeground());
        g.strokeLine((double)ax1, (double)ay1, (double)ax2, (double)ay2);
        g.strokeLine((double)bx1, (double)by1, (double)bx2, (double)by2);
        if (sb.getOrientation() == BOrientation.vertical) {
            ++ax1;
            ++ax2;
            --bx1;
            --bx2;
        } else {
            ++ay1;
            ++ay2;
            --by1;
            --by2;
        }
        g.setBrush(this.getControlBackground());
        g.strokeLine((double)bx1, (double)by1, (double)bx2, (double)by2);
        g.strokeLine((double)ax2, (double)ay2, (double)bx2, (double)by2);
        g.setBrush(this.getControlShadow());
        g.strokeLine((double)ax1, (double)ay1, (double)ax2, (double)ay2);
        g.strokeLine((double)bx1, (double)by1, (double)ax1, (double)ay1);
    }

    public void paintThumb(Graphics g, BScrollBar sb, RectGeom r) {
        if (sb.getEnabled()) {
            CuriumThemeUtils.paintThumb(this, g, sb.getOrientation(), r);
        }
    }
}

