/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.curium;

import com.tridium.ui.theme.MenuItemTheme;
import com.tridium.ui.theme.curium.CuriumWidgetTheme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.ui.BCheckBoxMenuItem;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BRadioButtonMenuItem;
import javax.baja.ui.util.UiLexicon;

public class CuriumMenuItemTheme
extends CuriumWidgetTheme
implements MenuItemTheme {
    static BInsets insets = null;
    static BFont textFont = null;
    static BFont acceleratorFont = null;
    static BBrush acceleratorBrush = CuriumWidgetTheme.selectionBackground;

    public BInsets getInsets() {
        return insets;
    }

    public double getIconIndent() {
        return 2;
    }

    public BFont getTextFont() {
        return textFont;
    }

    public BBrush getTextBrush() {
        return this.getControlForeground();
    }

    public BFont getAcceleratorFont() {
        return acceleratorFont;
    }

    public BBrush getAcceleratorBrush() {
        return acceleratorBrush;
    }

    public void paintDisabledText(Graphics g, String s, double x, double y) {
        g.setBrush(this.getControlHighlight());
        g.drawString(s, x + 1.0, y + 1.0);
        g.setBrush(this.getControlShadow());
        g.drawString(s, x, y);
    }

    public void paintBackground(Graphics g, BMenuItem m, boolean selected) {
        if (selected) {
            g.setBrush(this.getSelectionBackground());
        } else {
            g.setBrush(this.getControlBackground());
        }
        g.fillRect(0.0, 0.0, m.getWidth(), m.getHeight());
    }

    public void paintSubMenuArrow(Graphics g, BMenuItem m, boolean selected) {
        double w = m.getWidth();
        double h = m.getHeight();
        double mid = h / (double)2;
        double x = w - (double)4;
        if (m.getEnabled()) {
            if (selected) {
                g.setBrush(this.getSelectionForeground());
            } else {
                g.setBrush(this.getControlForeground());
            }
        } else {
            g.setBrush(this.getTextDisabled());
        }
        g.strokeLine(x, mid, x, mid + 0.0);
        g.strokeLine(x -= 1.0, mid - 1.0, x, mid + 1.0);
        g.strokeLine(x -= 1.0, mid - (double)2, x, mid + (double)2);
        g.strokeLine(x -= 1.0, mid - (double)3, x, mid + (double)3);
        g.strokeLine(x -= 1.0, mid - (double)4, x, mid + (double)4);
        x -= 1.0;
    }

    public void paintCheckBox(Graphics g, BCheckBoxMenuItem m, boolean selected) {
        if (m.getSelected()) {
            double h = m.getHeight();
            double x = CuriumMenuItemTheme.insets.left / (double)2 - (double)4;
            double y = h / (double)2 + (double)2;
            if (m.getEnabled()) {
                g.setBrush(this.getControlForeground());
            } else {
                g.setBrush(this.getControlShadow());
            }
            g.strokeLine(x, y, x + 1.0, y - 1.0);
            g.strokeLine(x + 1.0, y + 1.0, x + 6.0, y - (double)4);
            g.strokeLine(x + (double)2, y + (double)2, x + 7.0, y - (double)3);
            g.strokeLine(x + 1.0, y, x + (double)2, y + 1.0);
            g.strokeLine(x + (double)2, y + 1.0, x + 6.0, y - (double)3);
        }
    }

    public void paintRadioBox(Graphics g, BRadioButtonMenuItem m, boolean selected) {
        if (m.getSelected()) {
            double w = 4;
            double h = 4;
            double x = CuriumMenuItemTheme.insets.left / (double)2 - w / (double)2;
            double y = m.getHeight() / (double)2 - h / (double)2 + 1.0;
            if (m.getEnabled()) {
                g.setBrush(this.getControlForeground());
            } else {
                g.setBrush(this.getControlShadow());
            }
            g.strokeLine(x, y + h / (double)2, x + w / (double)2, y);
            g.strokeLine(x + 1.0, y + h / (double)2 + 1.0, x + w / (double)2 + 1.0, y + 1.0);
            g.strokeLine(x + (double)2, y + h / (double)2 + (double)2, x + w / (double)2 + (double)2, y + (double)2);
            g.strokeLine(x + 1.0, y + h / (double)2, x + w / (double)2, y + 1.0);
            g.strokeLine(x + (double)2, y + h / (double)2 + 1.0, x + w / (double)2 + 1.0, y + (double)2);
        }
    }

    static {
        String menuitemFont = "curium.menuitem.font";
        UiLexicon lex = UiLexicon.bajaui;
        textFont = lex.get("curium.menuitem.font") != null ? BFont.make((String)lex.get("curium.menuitem.font")) : CuriumWidgetTheme.plainText;
        acceleratorFont = BFont.make((String)textFont.getName(), (double)(textFont.getSize() - 1.0), (int)textFont.getStyle());
        double ICON_SIZE = 16.0;
        double MAX_TB_INSET = 12.0;
        double MIN_TB_INSET = 2;
        double MIN_MI_HEIGHT = 40.0;
        double fh = textFont.getHeight();
        double tb = Math.min(12.0, (40.0 - Math.max(16.0, fh)) / (double)2);
        tb = Math.max(tb, (double)2);
        insets = BInsets.make((double)tb, (double)14.0, (double)tb, (double)22.0);
    }
}

