/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.curium;

import com.tridium.ui.theme.DropDownTheme;
import com.tridium.ui.theme.curium.CuriumThemeUtils;
import com.tridium.ui.theme.curium.CuriumWidgetTheme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BWidget;

public class CuriumDropDownTheme
extends CuriumWidgetTheme
implements DropDownTheme {
    static BInsets insets = BInsets.make((double)2, (double)2, (double)2, (double)2);

    public BInsets getBorderInsets() {
        return insets;
    }

    public void paintBorder(Graphics g, BWidget widget) {
        this.paintBorder(g, widget, 0.0, 0.0, widget.getWidth(), widget.getHeight());
    }

    public void paintBorder(Graphics g, BWidget widget, double x, double y, double w, double h) {
        boolean enabled;
        if (x != 0.0 || y != 0.0) {
            g.translate(x, y);
        }
        boolean bl = false;
        if (widget.isEnabled() && widget.getParentWidget().isEnabled()) {
            bl = true;
        }
        if (enabled = bl) {
            g.setBrush(this.getControlForeground());
        } else {
            g.setBrush(this.getControlShadow());
        }
        g.strokeRect(1.0, 1.0, w - (double)3, h - (double)3);
        if (enabled) {
            g.setBrush(this.getControlShadow());
        } else {
            g.setBrush(this.getControlAuxiliary());
        }
        g.strokeLine(0.0, 0.0, w - 1.0, 0.0);
        g.strokeLine(0.0, 0.0, 0.0, h - 1.0);
        g.setBrush(this.getControlHighlight());
        g.strokeLine(w - 1.0, 1.0, w - 1.0, h - 1.0);
        g.strokeLine(1.0, h - 1.0, w - 1.0, h - 1.0);
        if (x != 0.0 || y != 0.0) {
            g.translate(-x, -y);
        }
    }

    public void paintButton(Graphics g, BWidget widget, RectGeom r, boolean isDepressed) {
        double x = r.x - 1.0;
        double y = r.y - 1.0;
        double w = r.width + 1.0;
        double h = r.height + 1.0;
        g.setBrush(this.getControlBackground());
        g.fillRect(x, y, w, h);
        if (widget.getEnabled()) {
            g.setBrush(this.getControlForeground());
        } else {
            g.setBrush(this.getControlShadow());
        }
        g.strokeRect(x, y, w, h);
        if (isDepressed) {
            g.setBrush(this.getControlShadow());
        } else {
            g.setBrush(this.getControlHighlight());
        }
        g.strokeLine(x + 1.0, y + 1.0, x + w - (double)2, y + 1.0);
        g.strokeLine(x + 1.0, y + 1.0, x + 1.0, y + h - 1.0);
        if (widget.getEnabled()) {
            g.setBrush(this.getControlShadow());
        } else {
            g.setBrush(this.getControlAuxiliary());
        }
        g.strokeLine(x + w - 1.0, y + 1.0, x + w - 1.0, y + h - 1.0);
        g.strokeLine(x + 1.0, y + h - 1.0, x + w - 1.0, y + h - 1.0);
        if (widget.getEnabled()) {
            g.setBrush(this.getControlForeground());
        } else {
            g.setBrush(this.getControlShadow());
        }
        boolean off = isDepressed;
        int dir = 1;
        CuriumThemeUtils.paintArrow(g, dir, x + (double)off, y + (double)off, w, h);
    }

    public void paintBackground(Graphics g, BWidget w) {
        g.setBrush(this.getWindowBackground());
        g.fillRect(0.0, 0.0, w.getWidth(), w.getHeight());
    }

    public BBrush getDisabledBackgroundBrush(BWidget w) {
        return this.getControlBackground();
    }
}

