/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.curium;

import com.tridium.ui.theme.CheckBoxTheme;
import com.tridium.ui.theme.curium.CuriumToggleButtonTheme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IInsets;
import javax.baja.gx.IPoint;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BToggleButton;

public class CuriumCheckBoxTheme
extends CuriumToggleButtonTheme
implements CheckBoxTheme {
    static final int CB_SIZE = 20;
    static BInsets padding = BInsets.make((double)6.0, (double)2, (double)6.0, (double)25.0);

    public IInsets getPadding(BAbstractButton b) {
        return padding;
    }

    public BFont getTextFont() {
        return this.getPlainText();
    }

    public IPoint getLabelOffset(BAbstractButton button) {
        return noOffset;
    }

    public int getCheckBoxSize() {
        return 20;
    }

    public void paintBackground(Graphics g, BAbstractButton b) {
        boolean mouseOver = b.isMouseOver();
        boolean pressed = b.isPressed();
        boolean enabled = b.getEnabled();
        boolean selected = ((BToggleButton)b).isSelected();
        BBrush bg = b.getBackground();
        if (!bg.isNull()) {
            g.setBrush(bg);
            g.fillRect(0.0, 0.0, b.getWidth(), b.getHeight());
        }
        double x = 0.0;
        double y = b.getHeight() / (double)2 - 10.0;
        double w = 19.0;
        double h = 19.0;
        g.setBrush(this.getControlBackground());
        g.fillRect(x, y, w, h);
        if (enabled) {
            g.setBrush(this.getControlForeground());
        } else {
            g.setBrush(this.getControlShadow());
        }
        g.strokeRect(x, y, w, h);
        if (pressed && mouseOver) {
            g.setBrush(this.getControlShadow());
        } else {
            g.setBrush(this.getControlHighlight());
        }
        g.strokeLine(x + 1.0, y + 1.0, x + w - (double)2, y + 1.0);
        g.strokeLine(x + 1.0, y + 1.0, x + 1.0, y + h - (double)2);
        if (enabled) {
            g.setBrush(this.getControlShadow());
        } else {
            g.setBrush(this.getControlAuxiliary());
        }
        g.strokeLine(x + w - 1.0, y + 1.0, x + w - 1.0, y + h - 1.0);
        g.strokeLine(x + 1.0, y + h - 1.0, x + w - 1.0, y + h - 1.0);
        if (selected) {
            x = w / (double)2 - (double)4;
            y = b.getHeight() / (double)2;
            if (enabled) {
                g.setBrush(this.getControlForeground());
            } else {
                g.setBrush(this.getControlShadow());
            }
            g.strokeLine(x, y, x + 1.0, y - 1.0);
            g.strokeLine(x + 1.0, y + 1.0, x + 6.0, y - (double)4);
            g.strokeLine(x + (double)2, y + (double)2, x + 7.0, y - (double)3);
            g.strokeLine(x + 1.0, y, x + (double)2, y + 1.0);
            g.strokeLine(x + (double)2, y + 1.0, x + 6.0, y - (double)3);
            g.setBrush(this.getControlAuxiliary());
            g.strokeLine(x + (double)3, y + (double)2, x + 7.0, y - (double)2);
            g.strokeLine(x + (double)3, y + (double)3, x + 8.0, y - (double)2);
        }
        if (b.hasFocus() && b.isFocusTraversable() && b.getText() != null && b.getText().length() > 0) {
            x = CuriumCheckBoxTheme.padding.left - (double)2;
            y = CuriumCheckBoxTheme.padding.top;
            w = b.getWidth() - (x + CuriumCheckBoxTheme.padding.right);
            h = b.getHeight() - (y + CuriumCheckBoxTheme.padding.bottom);
            this.paintFocus(g, new RectGeom(x, y, w, h));
        }
    }
}

