/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme;

import com.tridium.gx.awt.AwtEnv;
import com.tridium.gx.awt.ImageManager;
import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.BorderPaneTheme;
import com.tridium.ui.theme.ButtonTheme;
import com.tridium.ui.theme.CheckBoxTheme;
import com.tridium.ui.theme.DropDownTheme;
import com.tridium.ui.theme.ExpandablePaneTheme;
import com.tridium.ui.theme.GridPaneTheme;
import com.tridium.ui.theme.LabelTheme;
import com.tridium.ui.theme.MenuBarTheme;
import com.tridium.ui.theme.MenuItemTheme;
import com.tridium.ui.theme.MenuTheme;
import com.tridium.ui.theme.PaneTheme;
import com.tridium.ui.theme.PathBarTheme;
import com.tridium.ui.theme.ProgressBarTheme;
import com.tridium.ui.theme.PropertySheetTreeTheme;
import com.tridium.ui.theme.RadioButtonTheme;
import com.tridium.ui.theme.ScrollBarTheme;
import com.tridium.ui.theme.ScrollPaneTheme;
import com.tridium.ui.theme.SeparatorTheme;
import com.tridium.ui.theme.SliderTheme;
import com.tridium.ui.theme.SpinnerButtonTheme;
import com.tridium.ui.theme.SplitPaneTheme;
import com.tridium.ui.theme.TabbedPaneTheme;
import com.tridium.ui.theme.TableTheme;
import com.tridium.ui.theme.TextEditorPaneTheme;
import com.tridium.ui.theme.TextEditorTheme;
import com.tridium.ui.theme.TextFieldTheme;
import com.tridium.ui.theme.TitlePaneTheme;
import com.tridium.ui.theme.ToggleButtonTheme;
import com.tridium.ui.theme.ToolBarTheme;
import com.tridium.ui.theme.ToolPaneTheme;
import com.tridium.ui.theme.TreeTableTheme;
import com.tridium.ui.theme.TreeTheme;
import com.tridium.ui.theme.WidgetTheme;
import com.tridium.ui.theme.WiresheetTheme;
import com.tridium.ui.theme.custom.CustomWidgetTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import com.tridium.ui.theme.custom.nss.NSSException;
import com.tridium.ui.theme.custom.nss.NSSReader;
import java.lang.reflect.Constructor;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BModule;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Theme {
    private static Log logger = Log.getLog((String)"com.tridium.ui.theme");
    private static BorderPaneTheme borderPane;
    private static ButtonTheme button;
    private static CheckBoxTheme checkBox;
    private static DropDownTheme dropDown;
    private static ExpandablePaneTheme expandablePane;
    private static GridPaneTheme gridPane;
    private static LabelTheme label;
    private static MenuTheme menu;
    private static MenuBarTheme menuBar;
    private static MenuItemTheme menuItem;
    private static PaneTheme pane;
    private static PathBarTheme pathBar;
    private static ProgressBarTheme progressBar;
    private static RadioButtonTheme radioButton;
    private static SeparatorTheme separator;
    private static ScrollBarTheme scrollBar;
    private static ScrollPaneTheme scrollPane;
    private static SliderTheme slider;
    private static SpinnerButtonTheme spinner;
    private static SplitPaneTheme splitPane;
    private static TabbedPaneTheme tabbedPane;
    private static TableTheme table;
    private static TextEditorTheme textEditor;
    private static TextFieldTheme textField;
    private static TextEditorPaneTheme textEditorPane;
    private static TitlePaneTheme titlePane;
    private static ToggleButtonTheme toggleButton;
    private static ToolBarTheme toolBar;
    private static ToolPaneTheme toolPane;
    private static TreeTheme tree;
    private static PropertySheetTreeTheme propSheetTree;
    private static TreeTableTheme treeTable;
    private static WidgetTheme widget;
    private static WiresheetTheme wiresheet;
    static /* synthetic */ Class class$com$tridium$ui$theme$Theme;

    public static BorderPaneTheme borderPane() {
        return borderPane;
    }

    public static ButtonTheme button() {
        return button;
    }

    public static CheckBoxTheme checkBox() {
        return checkBox;
    }

    public static DropDownTheme dropDown() {
        return dropDown;
    }

    public static ExpandablePaneTheme expandablePane() {
        return expandablePane;
    }

    public static GridPaneTheme gridPane() {
        return gridPane;
    }

    public static LabelTheme label() {
        return label;
    }

    public static MenuTheme menu() {
        return menu;
    }

    public static MenuBarTheme menuBar() {
        return menuBar;
    }

    public static MenuItemTheme menuItem() {
        return menuItem;
    }

    public static PaneTheme pane() {
        return pane;
    }

    public static PathBarTheme pathBar() {
        return pathBar;
    }

    public static ProgressBarTheme progressBar() {
        return progressBar;
    }

    public static RadioButtonTheme radioButton() {
        return radioButton;
    }

    public static ScrollBarTheme scrollBar() {
        return scrollBar;
    }

    public static ScrollPaneTheme scrollPane() {
        return scrollPane;
    }

    public static SeparatorTheme separator() {
        return separator;
    }

    public static SliderTheme slider() {
        return slider;
    }

    public static SpinnerButtonTheme spinner() {
        return spinner;
    }

    public static SplitPaneTheme splitPane() {
        return splitPane;
    }

    public static TabbedPaneTheme tabbedPane() {
        return tabbedPane;
    }

    public static TableTheme table() {
        return table;
    }

    public static TextEditorTheme textEditor() {
        return textEditor;
    }

    public static TextFieldTheme textField() {
        return textField;
    }

    public static TextEditorPaneTheme textEditorPane() {
        return textEditorPane;
    }

    public static TitlePaneTheme titlePane() {
        return titlePane;
    }

    public static ToggleButtonTheme toggleButton() {
        return toggleButton;
    }

    public static ToolBarTheme toolBar() {
        return toolBar;
    }

    public static ToolPaneTheme toolPane() {
        return toolPane;
    }

    public static TreeTheme tree() {
        return tree;
    }

    public static PropertySheetTreeTheme propertySheetTree() {
        return propSheetTree;
    }

    public static TreeTableTheme treeTable() {
        return treeTable;
    }

    public static WidgetTheme widget() {
        return widget;
    }

    public static WiresheetTheme wiresheet() {
        return wiresheet;
    }

    public static void installTheme(BModule m, String packageName) {
        if (m == null) {
            Class clazz = class$com$tridium$ui$theme$Theme;
            if (clazz == null) {
                clazz = class$com$tridium$ui$theme$Theme = Theme.class("[Lcom.tridium.ui.theme.Theme;", false);
            }
            m = Sys.getModuleForClass((Class)clazz);
        }
        String name = packageName.substring(packageName.lastIndexOf(46) + 1);
        name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        String base = packageName + '.' + name;
        borderPane = (BorderPaneTheme)Theme.install(m, base, "BorderPaneTheme");
        button = (ButtonTheme)Theme.install(m, base, "ButtonTheme");
        checkBox = (CheckBoxTheme)Theme.install(m, base, "CheckBoxTheme");
        dropDown = (DropDownTheme)Theme.install(m, base, "DropDownTheme");
        expandablePane = (ExpandablePaneTheme)Theme.install(m, base, "ExpandablePaneTheme");
        gridPane = (GridPaneTheme)Theme.install(m, base, "GridPaneTheme");
        label = (LabelTheme)Theme.install(m, base, "LabelTheme");
        menu = (MenuTheme)Theme.install(m, base, "MenuTheme");
        menuBar = (MenuBarTheme)Theme.install(m, base, "MenuBarTheme");
        menuItem = (MenuItemTheme)Theme.install(m, base, "MenuItemTheme");
        pane = (PaneTheme)Theme.install(m, base, "PaneTheme");
        pathBar = (PathBarTheme)Theme.install(m, base, "PathBarTheme");
        progressBar = (ProgressBarTheme)Theme.install(m, base, "ProgressBarTheme");
        radioButton = (RadioButtonTheme)Theme.install(m, base, "RadioButtonTheme");
        scrollBar = (ScrollBarTheme)Theme.install(m, base, "ScrollBarTheme");
        scrollPane = (ScrollPaneTheme)Theme.install(m, base, "ScrollPaneTheme");
        separator = (SeparatorTheme)Theme.install(m, base, "SeparatorTheme");
        slider = (SliderTheme)Theme.install(m, base, "SliderTheme");
        spinner = (SpinnerButtonTheme)Theme.install(m, base, "SpinnerButtonTheme");
        splitPane = (SplitPaneTheme)Theme.install(m, base, "SplitPaneTheme");
        tabbedPane = (TabbedPaneTheme)Theme.install(m, base, "TabbedPaneTheme");
        table = (TableTheme)Theme.install(m, base, "TableTheme");
        textEditor = (TextEditorTheme)Theme.install(m, base, "TextEditorTheme");
        textField = (TextFieldTheme)Theme.install(m, base, "TextFieldTheme");
        textEditorPane = (TextEditorPaneTheme)Theme.install(m, base, "TextEditorPaneTheme");
        titlePane = (TitlePaneTheme)Theme.install(m, base, "TitlePaneTheme");
        toggleButton = (ToggleButtonTheme)Theme.install(m, base, "ToggleButtonTheme");
        toolBar = (ToolBarTheme)Theme.install(m, base, "ToolBarTheme");
        toolPane = (ToolPaneTheme)Theme.install(m, base, "ToolPaneTheme");
        tree = (TreeTheme)Theme.install(m, base, "TreeTheme");
        propSheetTree = (PropertySheetTreeTheme)Theme.install(m, base, "PropertySheetTreeTheme");
        treeTable = (TreeTableTheme)Theme.install(m, base, "TreeTableTheme");
        widget = Theme.install(m, base, "WidgetTheme");
        wiresheet = (WiresheetTheme)((Object)Theme.install(m, base, "WiresheetTheme"));
    }

    public static void installCustomTheme(BModule m, String themeName) {
        if (themeName != null && !themeName.equals("none")) {
            String nssFileName;
            String moduleName;
            if ((themeName = SlotPath.unescape((String)themeName)).indexOf(47) >= 0) {
                moduleName = themeName.substring(0, themeName.indexOf(47));
                nssFileName = themeName.substring(themeName.indexOf(47) + 1);
            } else {
                moduleName = themeName;
                nssFileName = "theme";
            }
            moduleName = Theme.resolveThemeName(moduleName);
            try {
                String fontPath = "module://" + moduleName + "/fonts";
                BOrd ord = BOrd.make((String)fontPath);
                BIDirectory dir = (BIDirectory)ord.get();
                BIFile[] fonts = dir.listFiles();
                int i = 0;
                while (i < fonts.length) {
                    BIFile file = fonts[i];
                    if (file.getExtension().equalsIgnoreCase("ttf")) {
                        ((AwtEnv)AwtEnv.get()).loadFont(file.getInputStream());
                    }
                    ++i;
                }
            }
            catch (Throwable fullPath) {
                // empty catch block
            }
            String fullPath = "module://" + moduleName + "/nss/" + nssFileName + ".nss";
            try {
                Theme.doInstallCustomTheme(m, fullPath);
                ImageManager.setActiveTheme((String)moduleName);
            }
            catch (Throwable th) {
                logger.warning("Could not load custom theme module " + themeName + ". Reverting to default.", th);
                Theme.installDefaultTheme();
            }
        } else {
            Theme.installDefaultTheme();
        }
    }

    private static final String resolveThemeName(String themeName) {
        try {
            Sys.getRegistry().getModule(themeName);
            return themeName;
        }
        catch (ModuleNotFoundException e) {
            return "theme" + themeName;
        }
    }

    private static final void doInstallCustomTheme(BModule m, String themePath) throws Exception {
        NSS nss;
        BOrd ord = BOrd.make((String)themePath);
        BIFile file = (BIFile)ord.get();
        try {
            nss = NSSReader.readFromFile(file);
        }
        catch (NSSException e) {
            logger.error("Exception parsing NSS file. " + e.getMessage());
            throw e;
        }
        if (m == null) {
            Class clazz = class$com$tridium$ui$theme$Theme;
            if (clazz == null) {
                clazz = class$com$tridium$ui$theme$Theme = Theme.class("[Lcom.tridium.ui.theme.Theme;", false);
            }
            m = Sys.getModuleForClass((Class)clazz);
        }
        CustomWidgetTheme.setNSS(nss);
        borderPane = (BorderPaneTheme)Theme.installCustom(m, "BorderPaneTheme");
        button = (ButtonTheme)Theme.installCustom(m, "ButtonTheme");
        checkBox = (CheckBoxTheme)Theme.installCustom(m, "CheckBoxTheme");
        dropDown = (DropDownTheme)Theme.installCustom(m, "DropDownTheme");
        expandablePane = (ExpandablePaneTheme)Theme.installCustom(m, "ExpandablePaneTheme");
        gridPane = (GridPaneTheme)Theme.installCustom(m, "GridPaneTheme");
        label = (LabelTheme)Theme.installCustom(m, "LabelTheme");
        menu = (MenuTheme)Theme.installCustom(m, "MenuTheme");
        menuBar = (MenuBarTheme)Theme.installCustom(m, "MenuBarTheme");
        menuItem = (MenuItemTheme)Theme.installCustom(m, "MenuItemTheme");
        pane = (PaneTheme)Theme.installCustom(m, "PaneTheme");
        pathBar = (PathBarTheme)Theme.installCustom(m, "PathBarTheme");
        progressBar = (ProgressBarTheme)Theme.installCustom(m, "ProgressBarTheme");
        radioButton = (RadioButtonTheme)Theme.installCustom(m, "RadioButtonTheme");
        scrollBar = (ScrollBarTheme)Theme.installCustom(m, "ScrollBarTheme");
        scrollPane = (ScrollPaneTheme)Theme.installCustom(m, "ScrollPaneTheme");
        separator = (SeparatorTheme)Theme.installCustom(m, "SeparatorTheme");
        slider = (SliderTheme)Theme.installCustom(m, "SliderTheme");
        spinner = (SpinnerButtonTheme)Theme.installCustom(m, "SpinnerButtonTheme");
        splitPane = (SplitPaneTheme)Theme.installCustom(m, "SplitPaneTheme");
        tabbedPane = (TabbedPaneTheme)Theme.installCustom(m, "TabbedPaneTheme");
        table = (TableTheme)Theme.installCustom(m, "TableTheme");
        textEditor = (TextEditorTheme)Theme.installCustom(m, "TextEditorTheme");
        textField = (TextFieldTheme)Theme.installCustom(m, "TextFieldTheme");
        textEditorPane = (TextEditorPaneTheme)Theme.installCustom(m, "TextEditorPaneTheme");
        titlePane = (TitlePaneTheme)Theme.installCustom(m, "TitlePaneTheme");
        toggleButton = (ToggleButtonTheme)Theme.installCustom(m, "ToggleButtonTheme");
        toolBar = (ToolBarTheme)Theme.installCustom(m, "ToolBarTheme");
        toolPane = (ToolPaneTheme)Theme.installCustom(m, "ToolPaneTheme");
        tree = (TreeTheme)Theme.installCustom(m, "TreeTheme");
        propSheetTree = (PropertySheetTreeTheme)Theme.installCustom(m, "PropertySheetTreeTheme");
        treeTable = (TreeTableTheme)Theme.installCustom(m, "TreeTableTheme");
        widget = Theme.installCustom(m, "WidgetTheme");
        wiresheet = (WiresheetTheme)((Object)Theme.installCustom(m, "WiresheetTheme"));
    }

    private static final WidgetTheme installCustom(BModule m, String name) throws Exception {
        String className = "com.tridium.ui.theme.custom.Custom" + name;
        try {
            Class cls = m.loadClass(className);
            Constructor c = cls.getConstructor(new Class[0]);
            return (WidgetTheme)c.newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.error("Cannot install theme: " + className, (Throwable)e);
            throw e;
        }
    }

    private static final WidgetTheme install(BModule m, String base, String name) {
        String className = base + name;
        try {
            Class cls = m.loadClass(base + name);
            return (WidgetTheme)cls.newInstance();
        }
        catch (Throwable e) {
            System.out.println("Cannot install theme: " + className);
            e.printStackTrace();
            return null;
        }
    }

    public static void installDefaultTheme() {
        if (UiEnv.get().hasTouchscreen()) {
            Theme.installTheme(null, "com.tridium.ui.theme.curium");
        } else {
            Theme.installTheme(null, "com.tridium.ui.theme.palladium");
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Theme.installDefaultTheme();
    }
}

