/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.table;

import javax.baja.gx.BImage;
import javax.baja.sys.BObject;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableModel;

public class PagedTableModel
extends DynamicTableModel {
    private int currentPage;
    private int minRowsPerPage;
    private TableModel root;

    public int getRowCount() {
        int visibleRows = this.getVisibleRows();
        return Math.min(this.root.getRowCount() - visibleRows * (this.currentPage - 1), visibleRows);
    }

    public Object getValueAt(int row, int col) {
        return this.root.getValueAt(this.translateRow(row), col);
    }

    public Object getSubject(int row) {
        return this.root.getSubject(this.translateRow(row));
    }

    public BImage getRowIcon(int row) {
        return this.root.getRowIcon(this.translateRow(row));
    }

    public Object[] getRowValues(int row) {
        return this.root.getRowValues(this.translateRow(row));
    }

    public BObject export(int row, int col) {
        return this.root.export(this.translateRow(row), col);
    }

    public void sortByColumn(int col, boolean ascending) {
        this.root.sortByColumn(col, ascending);
        this.gotoPage(1);
    }

    private final int translateRow(int row) {
        return (this.currentPage - 1) * this.getVisibleRows() + row;
    }

    private final int getVisibleRows() {
        int visRows = Math.max(0, this.root.getTable().getVisibleRowCount());
        return this.minRowsPerPage > 0 ? Math.max(visRows, this.minRowsPerPage) : visRows;
    }

    public int getPageCount() {
        int maxRowsPerPage = Math.min(this.root.getRowCount(), this.getVisibleRows());
        if (maxRowsPerPage == 0) {
            return 1;
        }
        return (this.root.getRowCount() - 1) / maxRowsPerPage + 1;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void gotoPage(int pageNum) {
        this.currentPage = pageNum < 1 ? 1 : (pageNum > this.getPageCount() ? this.getPageCount() : pageNum);
        this.root.getSelection().deselectAll();
        this.updateTable();
    }

    public void flipPages(int numPages) {
        this.gotoPage(this.currentPage + numPages);
    }

    public int[] getRowRange() {
        if (this.root.getRowCount() == 0) {
            return new int[2];
        }
        int visible = this.getVisibleRows();
        int first = (this.currentPage - 1) * visible + 1;
        int last = first + this.getRowCount() - 1;
        return new int[]{first, last};
    }

    public PagedTableModel(TableModel root) {
        this(root, -1);
    }

    public PagedTableModel(TableModel root, int minRowsPerPage) {
        super(root);
        this.root = root;
        this.currentPage = 1;
        this.minRowsPerPage = minRowsPerPage;
    }
}

