/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.file;

import java.util.ArrayList;
import java.util.Vector;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.nav.BINavNode;
import javax.baja.space.BSpace;
import javax.baja.sys.BModule;
import javax.baja.sys.BModuleSpace;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileChooserModel {
    private BSpace space;
    private BINavNode directory;
    private IFileFilter filter;
    private Vector selection;
    Support support;

    public void setSupport(Support support) {
        this.support = support;
    }

    public BSpace getSpace() {
        return this.space;
    }

    public void setSpace(BSpace space) {
        if (this.space != space) {
            this.space = space;
            this.directory = null;
        }
    }

    public BINavNode getDirectory() {
        return this.directory;
    }

    public void setDirectory(BINavNode dir) {
        this.directory = dir;
        this.support.pathModified();
    }

    public BINavNode[] getChildren() {
        ArrayList<BINavNode> list = new ArrayList<BINavNode>();
        if (this.directory == null) {
            BINavNode[] nav = this.space.getNavChildren();
            int i = 0;
            while (i < nav.length) {
                if (nav[i] instanceof BIFile) {
                    if (nav[i] instanceof BIDirectory || this.filter.accept((BIFile)nav[i])) {
                        list.add(nav[i]);
                    }
                } else {
                    list.add(nav[i]);
                }
                ++i;
            }
        } else {
            BINavNode[] kids = this.directory.getNavChildren();
            int i = 0;
            while (i < kids.length) {
                if (kids[i] instanceof BIFile) {
                    if (kids[i] instanceof BIDirectory || this.filter.accept((BIFile)kids[i])) {
                        list.add(kids[i]);
                    }
                } else {
                    list.add(kids[i]);
                }
                ++i;
            }
        }
        BINavNode[] temp = new BINavNode[list.size()];
        return list.toArray(temp);
    }

    public void moveUpDirectory() {
        if (this.directory != null) {
            BINavNode node = this.directory.getNavParent();
            if (node instanceof BIFile) {
                this.setDirectory((BINavNode)((BIFile)node));
            } else if (node == null && this.space instanceof BModule) {
                this.setSpace((BSpace)BModuleSpace.INSTANCE);
                this.setDirectory(null);
            } else {
                this.setDirectory(null);
            }
        }
    }

    public BINavNode[] getPath() {
        ArrayList<BINavNode> path = new ArrayList<BINavNode>();
        Object parent = this.directory;
        while (parent != null) {
            path.add((BINavNode)parent);
            BINavNode node = parent.getNavParent();
            parent = node instanceof BIFile ? (BIFile)node : null;
        }
        BINavNode[] reverse = new BINavNode[path.size()];
        int i = 0;
        while (i < path.size()) {
            reverse[path.size() - 1 - i] = (BINavNode)path.get(i);
            ++i;
        }
        return reverse;
    }

    public IFileFilter getFilter() {
        return this.filter;
    }

    public void setFilter(IFileFilter filter) {
        if (filter != null) {
            this.filter = filter;
            this.support.pathModified();
        }
    }

    public boolean isSelected(BIFile file) {
        int i = 0;
        while (i < this.selection.size()) {
            BIFile x = (BIFile)this.selection.elementAt(i);
            if (x.getNavName().equals(file.getNavName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void select(BIFile file) {
        if (!this.isSelected(file)) {
            this.selection.add(file);
        }
        this.support.selectionModified();
    }

    public void deselect(BIFile file) {
        int i = 0;
        while (i < this.selection.size()) {
            BIFile x = (BIFile)this.selection.elementAt(i);
            if (x.getNavName().equals(file.getNavName())) {
                this.selection.remove(i);
                break;
            }
            ++i;
        }
        this.support.selectionModified();
    }

    public void deselectAll() {
        this.selection.clear();
        this.support.selectionModified();
    }

    public BIFile[] getSelectedFiles() {
        BIFile[] n = new BIFile[this.selection.size()];
        return this.selection.toArray(n);
    }

    public final void chooseSelectedFiles() {
        this.support.chooseSelectedFiles();
    }

    private final /* synthetic */ void this() {
        this.filter = IFileFilter.all;
        this.selection = new Vector();
    }

    public FileChooserModel(BSpace space) {
        this.this();
        this.space = space;
        this.setSupport(new Support());
    }

    public static class Support {
        public void pathModified() {
        }

        public void selectionModified() {
        }

        public void chooseSelectedFiles() {
        }
    }
}

