/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.file;

import com.tridium.ui.file.BFilePathBar;
import com.tridium.ui.file.BFilePreview;
import com.tridium.ui.file.BFileSpaceList;
import com.tridium.ui.file.BListView;
import com.tridium.ui.file.FileChooserModel;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Stack;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Point;
import javax.baja.gx.Size;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.space.BSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BModuleSpace;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BFrame;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.bookmark.BBookmark;
import javax.baja.ui.bookmark.BBookmarkFolder;
import javax.baja.ui.bookmark.BBookmarkItem;
import javax.baja.ui.bookmark.BBookmarkOptions;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.options.BMruButton;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BToolPane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.util.UiLexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNFileChooser
extends BFileChooser {
    public static final Action changeFilter = BNFileChooser.newAction((int)0, null);
    public static final Action actionPerformed = BNFileChooser.newAction((int)0, null);
    public static final Type TYPE;
    BOrd tempOrd;
    final UiLexicon lex;
    FileChooserModel model;
    boolean confirmOverwrite;
    boolean createOnSave;
    BOrd savedFileOrd;
    BEdgePane content;
    BListView listView;
    BFilePreview preview;
    BFilePathBar pathBar;
    BTextField filename;
    BListDropDown filterList;
    BFileSpaceList spaceList;
    Hashtable filterMap;
    ConfirmCommand confirmCommand;
    CancelCommand cancelCommand;
    Stack history;
    BackCommand backCommand;
    UpLevelCommand upLevelCommand;
    CreateDirCommand createDirCommand;
    HomeCommand homeCommand;
    ListCommand listCommand;
    DetailsCommand detailsCommand;
    TogglePreviewCommand togglePreviewCommand;
    BookmarkCommand bookmarkCommand;
    BTree bookmarks;
    BMruButton recentDirs;
    Size lastSize;
    Point lastLocation;
    static /* synthetic */ Class class$com$tridium$ui$file$BNFileChooser;

    public void changeFilter() {
        this.invoke(changeFilter, null, null);
    }

    public void actionPerformed() {
        this.invoke(actionPerformed, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BFileChooser makeOpen(BWidget parent) {
        return new BNFileChooser(parent, UiLexicon.bajaui().getText("fileChooser.open"));
    }

    public static BFileChooser makeSave(BWidget parent) {
        return new BNFileChooser(parent, UiLexicon.bajaui().getText("fileChooser.save"), false);
    }

    public static BOrd showOpen(BWidget parent) {
        BFileChooser chooser = BNFileChooser.makeOpen(parent);
        return chooser.show();
    }

    public static BOrd showSave(BWidget parent) {
        BFileChooser chooser = BNFileChooser.makeSave(parent);
        return chooser.show();
    }

    private final BWidget buildPreview() {
        BSplitPane split = new BSplitPane();
        split.setDividerPosition(55.0);
        split.setWidget1(new BBorderPane((BWidget)this.listView, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        split.setWidget2(new BBorderPane((BWidget)this.preview, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        return split;
    }

    private final BWidget buildNoPreview() {
        return new BBorderPane((BWidget)this.listView, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
    }

    public BOrd[] show(boolean multipleSelection) {
        this.bookmarks.setModel(new BookmarkModel());
        this.bookmarks.relayout();
        this.model.setDirectory(this.model.getDirectory());
        if (this.tempOrd != null) {
            try {
                this.xSetCurrentDirectory(this.tempOrd);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.tempOrd = null;
        }
        if (this.lastLocation == null) {
            this.setBoundsCenteredOnOwner();
        } else {
            this.setScreenBounds(this.lastLocation.x, this.lastLocation.y, this.lastSize.width, this.lastSize.height);
        }
        if (!this.getCurrentSpace().isMounted()) {
            this.setCurrentSpace((BSpace)BFileSystem.INSTANCE);
            this.setCurrentNavDirectory(null);
        }
        this.listView.setMultipleSelection(multipleSelection);
        this.open();
        if (!this.createOnSave) {
            return new BOrd[]{this.savedFileOrd};
        }
        BIFile[] files = this.model.getSelectedFiles();
        BOrd[] ords = new BOrd[files.length];
        int i = 0;
        while (i < files.length) {
            ords[i] = files[i].getAbsoluteOrd();
            ++i;
        }
        return ords;
    }

    public BOrd getCurrentDirectory() {
        BINavNode dir = this.model.getDirectory();
        return dir == null ? null : dir.getNavOrd();
    }

    public void setCurrentDirectory(BOrd ord) {
        this.tempOrd = ord;
    }

    void xSetCurrentDirectory(BOrd ord) {
        if (ord.isNull()) {
            return;
        }
        BINavNode node = (BINavNode)ord.resolve((BObject)this.spaceList.getSpaces()[0]).get();
        if (node instanceof BIDirectory) {
            this.model.setSpace(BOrd.toSpace((BObject)((BObject)node)));
            this.model.setDirectory(node);
        } else if (node instanceof BIFile) {
            this.model.setSpace(BOrd.toSpace((BObject)((BObject)node)));
            this.model.setDirectory(node.getNavParent());
            this.model.select((BIFile)node);
        } else {
            this.model.setSpace(this.spaceList.getSpaces()[0]);
            this.model.setDirectory(null);
        }
    }

    public void setDefaultFileName(String fname) {
        this.filename.setText(fname);
    }

    public void setCreateFileOnSave(boolean create) {
        this.createOnSave = create;
    }

    public void setConfirmOverwrite(boolean confirm) {
        this.confirmOverwrite = confirm;
    }

    public void addFilter(IFileFilter filter) {
        String name = filter.getDescription(null);
        this.filterList.getList().addItem(name);
        this.filterMap.put(name, filter);
        this.setCurrentFilter(filter);
    }

    public void addFilters(IFileFilter[] filters) {
        int i = 0;
        while (i < filters.length) {
            this.addFilter(filters[i]);
            ++i;
        }
    }

    public BSpace[] getSpaces() {
        return this.spaceList.getSpaces();
    }

    public void setSpaces(BSpace[] spaces) {
        this.spaceList.setSpaces(spaces);
    }

    public FileChooserModel getModel() {
        return this.model;
    }

    public BSpace getCurrentSpace() {
        return this.model.getSpace();
    }

    public void setCurrentSpace(BSpace space) {
        this.model.setSpace(space);
    }

    public BINavNode getCurrentNavDirectory() {
        return this.model.getDirectory();
    }

    public void setCurrentNavDirectory(BINavNode dir) {
        this.model.setDirectory(dir);
    }

    public void setCurrentDirectory(File dir) {
        BIFile bdir = (BIFile)BFileSystem.INSTANCE.localFileToOrd(dir).get();
        this.model.setDirectory((BINavNode)bdir);
    }

    public IFileFilter getCurrentFilter() {
        return this.model.getFilter();
    }

    public void setCurrentFilter(IFileFilter filter) {
        String name = filter.getDescription(null);
        if (this.filterMap.get(name) == null) {
            this.addFilter(filter);
        }
        int index = this.filterList.getList().indexOfItem(name);
        this.filterList.getList().setSelectedIndex(index);
        this.doChangeFilter();
    }

    public void computePreferredSize() {
        this.setPreferredSize(this.lastSize.width, this.lastSize.height);
    }

    public void paint(Graphics g) {
        super.paint(g);
        try {
            if (this.lastLocation == null) {
                this.lastLocation = new Point(0.0, 0.0);
            }
            IRectGeom r = this.getScreenBounds();
            this.lastLocation.x = r.x();
            this.lastLocation.y = r.y();
            this.lastSize.width = r.width();
            this.lastSize.height = r.height();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void windowClosing(BWindowEvent event) {
        this.cancelCommand.invoke();
    }

    public void doChangeFilter() {
        String filterName = (String)this.filterList.getList().getSelectedItem();
        if (filterName != null) {
            this.model.setFilter((IFileFilter)this.filterMap.get(filterName));
        }
    }

    public void doActionPerformed() {
        this.getModel().chooseSelectedFiles();
    }

    void openBookmark(BBookmark bm) {
        try {
            BINavNode dir = (BINavNode)bm.getBookmarkOrd().resolve().get();
            BSpace space = BOrd.toSpace((BObject)((BObject)dir));
            if (!(space instanceof BFileSpace)) {
                throw new Exception("Space not instance of BFileSpace");
            }
            this.model.setSpace(space);
            this.model.setDirectory(dir);
        }
        catch (Exception e) {
            BDialog.error((BWidget)this, this.lex.getText("fileChooser.error"), (Object)this.lex.getText("fileChooser.bookmarkResolveError"), e);
        }
    }

    BBookmark makeForCurrentContext() {
        BSpace space = this.model.getSpace();
        BINavNode dir = this.model.getDirectory();
        String name = dir.getNavDisplayName(null);
        if (space instanceof BModule && dir.getNavParent() == null) {
            name = ((BModule)space).getModuleName();
            space = BModuleSpace.INSTANCE;
            dir = ((BModuleSpace)space).getNavChild(name);
        }
        return new BBookmark(name, dir.getNavOrd(), dir.getNavIcon());
    }

    static BBookmarkFolder getFileBookmarks() {
        BBookmarkOptions options = BBookmarkOptions.make();
        BBookmarkFolder folder = (BBookmarkFolder)options.getRootFolder().get("file");
        if (folder == null) {
            folder = new BBookmarkFolder("File");
            options.getRootFolder().add("file", (BValue)folder);
        }
        return folder;
    }

    public static void main(String[] args) {
        BFrame frame = new BFrame();
        ExtFileFilter images = new ExtFileFilter("Image files (*.gif, *.jpeg, *.png)", "gif,jpg,png");
        IFileFilter[] filterList = new IFileFilter[]{new ExtFileFilter("Print files (*.print)", "print"), new ExtFileFilter("XML files (*.xml, *.bog)", new String[]{"xml", "bog"})};
        BFileChooser x = BNFileChooser.makeOpen(frame);
        x.addFilters(filterList);
        BOrd[] files = x.show(true);
        int i = 0;
        while (i < files.length) {
            System.out.println("  " + files[i]);
            ++i;
        }
        System.exit(0);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.tempOrd = null;
        this.lex = UiLexicon.bajaui();
        this.confirmOverwrite = true;
        this.createOnSave = true;
        this.savedFileOrd = null;
        this.lastSize = new Size(630.0, 430.0);
        this.lastLocation = null;
    }

    private BNFileChooser(BWidget parent) {
        this(parent, UiLexicon.bajaui().getText("fileChooser.open"));
    }

    private BNFileChooser(BWidget parent, BFileSpace space) {
        this(parent, space, UiLexicon.bajaui().getText("fileChooser.open"), true);
    }

    private BNFileChooser(BWidget parent, String confirmLabel) {
        this(parent, (BFileSpace)BFileSystem.INSTANCE, confirmLabel, true);
    }

    private BNFileChooser(BWidget parent, String confirmLabel, boolean open) {
        this(parent, (BFileSpace)BFileSystem.INSTANCE, confirmLabel, open);
    }

    private BNFileChooser(BWidget parent, BFileSpace space, String confirmLabel, boolean open) {
        super(parent, UiLexicon.bajaui().getText("fileChooser.title"));
        this.this();
        this.model = new FileChooserModel((BSpace)space);
        this.model.setSupport(new FileChooserSupport(2 - open));
        this.filename = new BTextField();
        this.filterList = new BListDropDown();
        this.listView = new BListView(this.model);
        this.preview = new BFilePreview(this.model);
        this.pathBar = new BFilePathBar(this.model);
        this.recentDirs = new BMruButton("fileChooserRecentDir");
        this.recentDirs.setMruController(new MruController());
        this.bookmarks = new BTree(new BookmarkModel());
        this.bookmarks.setController(new BookmarkController());
        this.linkTo(null, this.filename, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
        this.filename.setEditable(open ^ true);
        String allstr = this.lex.getText("fileChooser.allFiles") + " (*.*)";
        this.filterList.getList().addItem(allstr);
        this.filterList.getList().setSelectedIndex(0);
        this.filterMap = new Hashtable();
        this.filterMap.put(allstr, IFileFilter.all);
        this.linkTo(null, this.filterList, (Slot)BListDropDown.listActionPerformed, (Slot)changeFilter);
        this.confirmCommand = new ConfirmCommand(confirmLabel);
        this.cancelCommand = new CancelCommand(this.lex.getText("fileChooser.cancel"));
        this.history = new Stack();
        this.history.push(new HistoryArtifact(this.model.getSpace(), this.model.getDirectory()));
        this.backCommand = new BackCommand();
        this.backCommand.setEnabled(false);
        this.upLevelCommand = new UpLevelCommand();
        boolean bl = false;
        if (this.model.getDirectory() != null) {
            bl = true;
        }
        this.upLevelCommand.setEnabled(bl);
        this.createDirCommand = new CreateDirCommand();
        this.createDirCommand.setEnabled(this.model.getSpace() instanceof BFileSpace);
        this.homeCommand = new HomeCommand();
        this.listCommand = new ListCommand();
        this.detailsCommand = new DetailsCommand();
        this.listCommand.setSelected(true);
        this.bookmarkCommand = new BookmarkCommand();
        this.togglePreviewCommand = new TogglePreviewCommand();
        this.togglePreviewCommand.setSelected(true);
        ToggleCommandGroup group = new ToggleCommandGroup();
        group.add(this.listCommand);
        group.add(this.detailsCommand);
        BToolBar toolbar = new BToolBar();
        toolbar.add(null, this.backCommand);
        toolbar.add(null, this.upLevelCommand);
        toolbar.add(null, this.homeCommand);
        toolbar.add(null, this.createDirCommand);
        toolbar.add(null, (BValue)new BSeparator());
        toolbar.add(null, this.listCommand);
        toolbar.add(null, this.detailsCommand);
        toolbar.add(null, (BValue)new BSeparator());
        toolbar.add(null, (BValue)this.recentDirs);
        toolbar.add(null, this.bookmarkCommand);
        toolbar.add(null, this.togglePreviewCommand);
        BEdgePane top = new BEdgePane();
        top.setTop(new BBorderPane((BWidget)this.pathBar, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        top.setBottom(toolbar);
        BGridPane g1 = new BGridPane(2);
        g1.setStretchColumn(1);
        g1.setColumnAlign(BHalign.fill);
        g1.add(null, (BValue)new BLabel(this.lex.getText("fileChooser.fileName"), BHalign.left));
        g1.add(null, (BValue)this.filename);
        g1.add(null, (BValue)new BLabel(this.lex.getText("fileChooser.fileType"), BHalign.left));
        g1.add(null, (BValue)this.filterList);
        BGridPane g2 = new BGridPane(1);
        g2.setColumnAlign(BHalign.fill);
        g2.add(null, (BValue)new BButton(this.confirmCommand));
        g2.add(null, (BValue)new BButton(this.cancelCommand));
        BEdgePane bottom = new BEdgePane();
        bottom.setCenter(new BBorderPane(g1, 0.0, 10.0, 0.0, 0.0));
        bottom.setRight(g2);
        this.content = new BEdgePane();
        this.content.setTop(top);
        this.content.setCenter(this.buildPreview());
        this.content.setBottom(new BBorderPane(bottom, 5, 0.0, 0.0, 0.0));
        BImage icon1 = BImage.make((String)"module://icons/x16/computer.png");
        BImage icon2 = BImage.make((String)"module://icons/x16/bookmark.png");
        BLabel label1 = new BLabel(icon1, this.lex.getText("fileChooser.spaces"));
        BLabel label2 = new BLabel(icon2, this.lex.getText("fileChooser.bookmarks"));
        BToolPane toolpane = new BToolPane();
        this.spaceList = new BFileSpaceList(this.model, open ^ true);
        toolpane.addPane(label1, (BWidget)this.spaceList);
        toolpane.addPane(label2, (BWidget)this.bookmarks);
        BSplitPane bigPicture = new BSplitPane();
        bigPicture.setDividerPosition(25.0);
        bigPicture.setWidget1(new BBorderPane((BWidget)toolpane, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        bigPicture.setWidget2(this.content);
        this.setContent(new BBorderPane(bigPicture, 5, 5, 5, 5));
    }

    public BNFileChooser() {
        super(null, "");
        this.this();
    }

    static {
        Class clazz = class$com$tridium$ui$file$BNFileChooser;
        if (clazz == null) {
            clazz = class$com$tridium$ui$file$BNFileChooser = BNFileChooser.class("[Lcom.tridium.ui.file.BNFileChooser;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class BookmarkModel
    extends TreeModel {
        Node[] roots;
        static /* synthetic */ Class class$javax$baja$ui$bookmark$BBookmarkItem;

        public int getRootCount() {
            return this.roots.length;
        }

        public TreeNode getRoot(int index) {
            return this.roots[index];
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        public BookmarkModel() {
            BBookmarkFolder x = BNFileChooser.getFileBookmarks();
            Class clazz = class$javax$baja$ui$bookmark$BBookmarkItem;
            if (clazz == null) {
                clazz = class$javax$baja$ui$bookmark$BBookmarkItem = BookmarkModel.class("[Ljavax.baja.ui.bookmark.BBookmarkItem;", false);
            }
            BBookmarkItem[] items = (BBookmarkItem[])x.getChildren(clazz);
            this.roots = new Node[items.length];
            int i = 0;
            while (i < items.length) {
                this.roots[i] = new Node((TreeModel)this, items[i]);
                ++i;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CancelCommand
    extends Command {
        public CommandArtifact doInvoke() {
            BNFileChooser.this.model.deselectAll();
            BNFileChooser.this.close();
            return null;
        }

        CancelCommand(String label) {
            super(BNFileChooser.this, label);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class FileChooserSupport
    extends FileChooserModel.Support {
        static final int OPEN = 1;
        static final int SAVE = 2;
        int type;

        public void pathModified() {
            BNFileChooser.this.model.deselectAll();
            UpLevelCommand upLevelCommand = BNFileChooser.this.upLevelCommand;
            boolean bl = false;
            if (BNFileChooser.this.model.getDirectory() != null) {
                bl = true;
            }
            upLevelCommand.setEnabled(bl);
            if (BNFileChooser.this.history.size() > 0) {
                BINavNode dir = BNFileChooser.this.model.getDirectory();
                HistoryArtifact art = (HistoryArtifact)BNFileChooser.this.history.peek();
                if (art.space != BNFileChooser.this.model.getSpace()) {
                    BNFileChooser.this.history.push(new HistoryArtifact(BNFileChooser.this.model.getSpace(), dir));
                } else if (art.dir == null && dir != null) {
                    BNFileChooser.this.history.push(new HistoryArtifact(BNFileChooser.this.model.getSpace(), dir));
                } else if (art.dir != null && dir == null) {
                    BNFileChooser.this.history.push(new HistoryArtifact(BNFileChooser.this.model.getSpace(), dir));
                } else if (art.dir != null && dir != null && !art.dir.getNavName().equals(dir.getNavName())) {
                    BNFileChooser.this.history.push(new HistoryArtifact(BNFileChooser.this.model.getSpace(), BNFileChooser.this.model.getDirectory()));
                }
            } else {
                BNFileChooser.this.history.push(new HistoryArtifact(BNFileChooser.this.model.getSpace(), BNFileChooser.this.model.getDirectory()));
            }
            BackCommand backCommand = BNFileChooser.this.backCommand;
            boolean bl2 = false;
            if (BNFileChooser.this.history.size() > 1) {
                bl2 = true;
            }
            backCommand.setEnabled(bl2);
            BNFileChooser.this.createDirCommand.setEnabled(BNFileChooser.this.model.getSpace() instanceof BFileSpace);
            BNFileChooser.this.spaceList.relayout();
            BNFileChooser.this.listView.getSelection().deselectAll();
            BNFileChooser.this.listView.populateChildren();
            BNFileChooser.this.listView.relayout();
            BNFileChooser.this.pathBar.relayout();
        }

        public void selectionModified() {
            BIFile[] files = BNFileChooser.this.model.getSelectedFiles();
            StringBuffer str = new StringBuffer();
            int count = 0;
            int i = 0;
            while (i < files.length) {
                BNFileChooser.this.listView.select(files[i]);
                if (!(files[i] instanceof BIDirectory)) {
                    if (count > 0) {
                        str.append(";");
                    }
                    str.append(files[i].getNavDisplayName(null));
                    ++count;
                }
                ++i;
            }
            if (BNFileChooser.this.preview.isVisible()) {
                BNFileChooser.this.preview.relayout();
            }
            BookmarkCommand bookmarkCommand = BNFileChooser.this.bookmarkCommand;
            boolean bl = false;
            if (BNFileChooser.this.model.getDirectory() != null) {
                bl = true;
            }
            bookmarkCommand.setEnabled(bl);
            if (this.type == 1) {
                BNFileChooser.this.filename.setText(str.toString());
            } else if (count > 0) {
                BNFileChooser.this.filename.setText(str.toString());
            }
            BNFileChooser.this.filename.repaint();
        }

        /*
         * Unable to fully structure code
         */
        public void chooseSelectedFiles() {
            block18: {
                block17: {
                    block19: {
                        if (this.type != 1) break block19;
                        files = BNFileChooser.this.model.getSelectedFiles();
                        if (files.length == 0) {
                            return;
                        }
                        i = 0;
                        while (i < files.length) {
                            if (files[i] instanceof BIDirectory) {
                                BNFileChooser.this.model.setDirectory((BINavNode)files[i]);
                                return;
                            }
                            ++i;
                        }
                        break block18;
                    }
                    if (this.type != 2) break block18;
                    path = null;
                    try {
                        path = ((BIFile)BNFileChooser.this.model.getDirectory()).getFilePath().merge(BNFileChooser.this.filename.getText());
                    }
                    catch (Exception e) {
                        BDialog.error((BWidget)BNFileChooser.this, BNFileChooser.this.lex.getText("fileChooser.error"), (Object)BNFileChooser.this.lex.getText("fileChooser.noDirectoryError"), e);
                        return;
                    }
                    if (!BNFileChooser.this.confirmOverwrite) ** GOTO lbl-1000
                    BOrd.make((OrdQuery)path).resolve((BObject)BNFileChooser.this.model.getSpace()).get();
                    if (4 == BDialog.open(BNFileChooser.this, BNFileChooser.this.lex.getText("fileChooser.fileExists"), BNFileChooser.this.lex.getText("fileChooser.fileExistsPrompt"), 14, BDialog.WARNING_ICON)) break block17;
                    return;
                }
                try {
                    ** GOTO lbl-1000
                }
                catch (UnresolvedException e) {
                    try lbl-1000:
                    // 3 sources

                    {
                        if (BNFileChooser.this.createOnSave) {
                            file = null;
                            try {
                                file = ((BFileSpace)BNFileChooser.this.model.getSpace()).makeFile(path);
                            }
                            catch (Exception e) {
                                BDialog.error((BWidget)BNFileChooser.this, BNFileChooser.this.lex.getText("fileChooser.error"), (Object)BNFileChooser.this.lex.getText("fileChooser.cannotCreateFile"), e);
                                return;
                            }
                            BNFileChooser.this.model.deselectAll();
                            BNFileChooser.this.model.select(file);
                            break block18;
                        }
                        BNFileChooser.this.savedFileOrd = BOrd.make((BOrd)BNFileChooser.this.model.getSpace().getNavOrd(), (OrdQuery)path).normalize();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (BNFileChooser.this.createOnSave) {
                files = BNFileChooser.this.model.getSelectedFiles();
                if (files.length > 0) {
                    BNFileChooser.this.recentDirs.getMruOptions().save(files[0].getNavParent().getNavOrd().toString());
                }
            } else {
                BNFileChooser.this.recentDirs.getMruOptions().save(BNFileChooser.this.model.getDirectory().getNavOrd().toString());
            }
            BNFileChooser.this.close();
        }

        public FileChooserSupport(int type) {
            this.type = type;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class MruController
    extends BMruButton.MruController {
        public void select(String value) {
            try {
                BIFile dir = (BIFile)BOrd.make((String)value).resolve().get();
                BNFileChooser.this.setCurrentSpace((BSpace)dir.getFileSpace());
                BNFileChooser.this.setCurrentNavDirectory((BINavNode)dir);
            }
            catch (Exception e) {
                BDialog.error((BWidget)BNFileChooser.this, BNFileChooser.this.lex.getText("fileChooser.error"), (Object)BNFileChooser.this.lex.getText("fileChooser.noDirectoryError"), e);
            }
        }

        MruController() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BookmarkController
    extends TreeController {
        protected void doSelectAction(TreeNode target, double x, double y) {
            Node node = (Node)target;
            if (node.item instanceof BBookmark) {
                BNFileChooser.this.openBookmark((BBookmark)node.item);
            }
        }

        BookmarkController() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ConfirmCommand
    extends Command {
        public CommandArtifact doInvoke() {
            BNFileChooser.this.model.chooseSelectedFiles();
            return null;
        }

        ConfirmCommand(String label) {
            super(BNFileChooser.this, label);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class HistoryArtifact {
        BSpace space;
        BINavNode dir;

        HistoryArtifact(BSpace space, BINavNode dir) {
            this.space = space;
            this.dir = dir;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BackCommand
    extends Command {
        public CommandArtifact doInvoke() {
            BNFileChooser.this.history.pop();
            HistoryArtifact art = (HistoryArtifact)BNFileChooser.this.history.pop();
            BNFileChooser.this.model.setSpace(art.space);
            BNFileChooser.this.model.setDirectory(art.dir);
            return null;
        }

        BackCommand() {
            super((BWidget)BNFileChooser.this, BNFileChooser.this.lex.module, "fileChooser.back");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class UpLevelCommand
    extends Command {
        public CommandArtifact doInvoke() {
            BNFileChooser.this.model.moveUpDirectory();
            return null;
        }

        UpLevelCommand() {
            super((BWidget)BNFileChooser.this, BNFileChooser.this.lex.module, "fileChooser.upLevel");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CreateDirCommand
    extends Command {
        public CommandArtifact doInvoke() {
            String title = BNFileChooser.this.lex.getText("fileChooser.title");
            try {
                BFileSpace space = (BFileSpace)BNFileChooser.this.model.getSpace();
                BIFile dir = (BIFile)BNFileChooser.this.model.getDirectory();
                String newFolderName = BNFileChooser.this.lex.getText("fileChooser.newFolder");
                newFolderName = BDialog.prompt(BNFileChooser.this, title, newFolderName, 20);
                if (newFolderName != null) {
                    BDirectory newDir = space.makeDir(dir.getFilePath().merge(newFolderName));
                    BNFileChooser.this.model.setDirectory((BINavNode)newDir);
                }
            }
            catch (Exception e) {
                BDialog.error((BWidget)BNFileChooser.this, title, (Object)BNFileChooser.this.lex.getText("fileChooser.createDirFailed"), e);
            }
            return null;
        }

        CreateDirCommand() {
            super((BWidget)BNFileChooser.this, BNFileChooser.this.lex.module, "fileChooser.createDir");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class HomeCommand
    extends Command {
        public CommandArtifact doInvoke() {
            BNFileChooser.this.model.setSpace((BSpace)BFileSystem.INSTANCE);
            BNFileChooser.this.model.setDirectory((BINavNode)BFileSystem.INSTANCE.findFile(new FilePath("!")));
            return null;
        }

        HomeCommand() {
            super((BWidget)BNFileChooser.this, BNFileChooser.this.lex.module, "fileChooser.home");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ListCommand
    extends ToggleCommand {
        public CommandArtifact doInvoke() {
            BNFileChooser.this.listView.setListView();
            return null;
        }

        ListCommand() {
            super((BWidget)BNFileChooser.this, BNFileChooser.this.lex.module, "fileChooser.list");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DetailsCommand
    extends ToggleCommand {
        public CommandArtifact doInvoke() {
            BNFileChooser.this.listView.setDetailsView();
            return null;
        }

        DetailsCommand() {
            super((BWidget)BNFileChooser.this, BNFileChooser.this.lex.module, "fileChooser.details");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BookmarkCommand
    extends Command {
        public CommandArtifact doInvoke() {
            try {
                BBookmark bm = BNFileChooser.this.makeForCurrentContext();
                BNFileChooser.getFileBookmarks().add(null, (BValue)bm);
                BBookmarkOptions.make().save();
                BNFileChooser.this.bookmarks.setModel(new BookmarkModel());
                BNFileChooser.this.bookmarks.relayout();
            }
            catch (Exception e) {
                BDialog.error(this.getOwner(), "Error", (Object)"Add failed", e);
                return null;
            }
            try {
                Class cls = Sys.loadClass((String)"workbench", (String)"com.tridium.workbench.bookmark.BookmarkEvents");
                Object obj = cls.newInstance();
                Method method = cls.getDeclaredMethod("fireBookmarkChanged", null);
                method.invoke(obj, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        BookmarkCommand() {
            super((BWidget)BNFileChooser.this, BNFileChooser.this.lex.module, "fileChooser.bookmarks");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TogglePreviewCommand
    extends ToggleCommand {
        public CommandArtifact doInvoke() {
            BBorderPane parent = (BBorderPane)BNFileChooser.this.listView.getParentWidget();
            if (parent != null) {
                parent.setContent(new BNullWidget());
            }
            if ((parent = (BBorderPane)BNFileChooser.this.preview.getParentWidget()) != null) {
                parent.setContent(new BNullWidget());
            }
            BNFileChooser.this.content.setCenter(this.isSelected() ? BNFileChooser.this.buildPreview() : BNFileChooser.this.buildNoPreview());
            BNFileChooser.this.content.relayout();
            return null;
        }

        TogglePreviewCommand() {
            super((BWidget)BNFileChooser.this, BNFileChooser.this.lex.module, "fileChooser.togglePreview");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class Node
    extends TreeNode {
        BBookmarkItem item;
        Node[] kids;
        static /* synthetic */ Class class$javax$baja$ui$bookmark$BBookmarkItem;

        public void load() {
            Class clazz = class$javax$baja$ui$bookmark$BBookmarkItem;
            if (clazz == null) {
                clazz = class$javax$baja$ui$bookmark$BBookmarkItem = Node.class("[Ljavax.baja.ui.bookmark.BBookmarkItem;", false);
            }
            BBookmarkItem[] items = (BBookmarkItem[])this.item.getChildren(clazz);
            this.kids = new Node[items.length];
            int i = 0;
            while (i < items.length) {
                this.kids[i] = new Node(this, items[i]);
                ++i;
            }
        }

        public String getText() {
            return this.item.getText();
        }

        public BImage getIcon() {
            return BImage.make((BIcon)this.item.getIcon());
        }

        public Object getSubject() {
            return this.item;
        }

        public int getChildCount() {
            return this.kids.length;
        }

        public TreeNode getChild(int index) {
            return this.kids[index];
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        public Node(TreeModel model, BBookmarkItem item) {
            super(model);
            this.item = item;
            this.load();
        }

        public Node(TreeNode parent, BBookmarkItem item) {
            super(parent);
            this.item = item;
            this.load();
        }
    }
}

