/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.file;

import com.tridium.sys.module.BModuleNavNode;
import com.tridium.sys.registry.NModuleInfo;
import com.tridium.ui.file.FileChooserModel;
import java.util.ArrayList;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavContainer;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BListView
extends BTable {
    public static final Type TYPE;
    FileChooserModel fileModel;
    ListModel model;
    boolean showDirs;
    boolean showFiles;
    static /* synthetic */ Class class$com$tridium$ui$file$BListView;

    public Type getType() {
        return TYPE;
    }

    public boolean getShowDirectories() {
        return this.showDirs;
    }

    public void setShowDirectories(boolean v) {
        this.showDirs = v;
    }

    public boolean getShowFiles() {
        return this.showFiles;
    }

    public void setShowFiles(boolean v) {
        this.showFiles = v;
    }

    public void populateChildren() {
        BINavNode[] kids = this.fileModel.getChildren();
        this.model.kids = this.sort(this.filter(kids));
    }

    private final BINavNode[] filter(BINavNode[] files) {
        if (!(this.fileModel.getSpace() instanceof BFileSpace)) {
            return files;
        }
        ArrayList<BIFile> list = new ArrayList<BIFile>();
        int i = 0;
        while (i < files.length) {
            BIFile file = (BIFile)files[i];
            if (this.showDirs && file instanceof BIDirectory || this.showFiles && !(file instanceof BIDirectory)) {
                list.add(file);
            }
            ++i;
        }
        BIFile[] result = new BIFile[list.size()];
        return (BINavNode[])list.toArray(result);
    }

    private final BINavNode[] sort(BINavNode[] files) {
        if (!this.showDirs || !this.showFiles) {
            return files;
        }
        int i = 1;
        while (i < files.length) {
            if (files[i] instanceof BIDirectory) {
                int j = i;
                while (j > 0 && !(files[j - 1] instanceof BIDirectory)) {
                    BINavNode temp = files[j - 1];
                    files[j - 1] = files[j];
                    files[j] = temp;
                    --j;
                }
            }
            ++i;
        }
        return files;
    }

    public void select(BIFile file) {
        int i = 0;
        while (i < this.model.kids.length) {
            if (file.getNavName().equals(this.model.kids[i].getNavName())) {
                if (this.getSelection().isSelected(i)) break;
                this.getSelection().select(i);
                break;
            }
            ++i;
        }
    }

    public void setListView() {
        this.model = new ListModel();
        this.setModel(this.model);
        this.setHeaderVisible(false);
        this.populateChildren();
    }

    public void setDetailsView() {
        this.model = new DetailsModel();
        this.setModel(this.model);
        this.setHeaderVisible(true);
        this.populateChildren();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BListView(FileChooserModel fileModel) {
        this.model = new ListModel();
        this.fileModel = fileModel;
        this.setShowDirectories(true);
        this.setShowFiles(true);
        this.populateChildren();
        this.setModel(this.model);
        this.setController(new Controller());
        this.setSelection(new Selection());
        this.setHeaderVisible(false);
        this.setHgridVisible(false);
        this.setVgridVisible(false);
    }

    public BListView() {
    }

    static {
        Class clazz = class$com$tridium$ui$file$BListView;
        if (clazz == null) {
            clazz = class$com$tridium$ui$file$BListView = BListView.class("[Lcom.tridium.ui.file.BListView;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ListModel
    extends TableModel {
        BINavNode[] kids;

        public int getRowCount() {
            return this.kids.length;
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int col) {
            return "";
        }

        public Object getValueAt(int row, int col) {
            return this.kids[row].getNavDisplayName(null);
        }

        public BImage getRowIcon(int row) {
            return BImage.make((BIcon)this.kids[row].getNavIcon());
        }

        public Object getSubject(int row) {
            return this.kids[row];
        }

        public BINavNode get(int row) {
            return this.kids[row];
        }

        ListModel() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DetailsModel
    extends ListModel {
        public int getColumnCount() {
            if (this.kids.length == 0 || this.kids[0] instanceof BIFile) {
                return 3;
            }
            if (this.kids[0] instanceof BModuleNavNode) {
                return 4;
            }
            return 1;
        }

        public String getColumnName(int col) {
            if (this.kids.length == 0 || this.kids[0] instanceof BIFile) {
                switch (col) {
                    case 0: {
                        return UiLexicon.bajaui().getText("fileChooser.name");
                    }
                    case 1: {
                        return UiLexicon.bajaui().getText("fileChooser.size");
                    }
                    case 2: {
                        return UiLexicon.bajaui().getText("fileChooser.lastModified");
                    }
                }
                return "";
            }
            if (this.kids[0] instanceof BModuleNavNode) {
                switch (col) {
                    case 0: {
                        return "Name";
                    }
                    case 1: {
                        return "Vender";
                    }
                    case 2: {
                        return "Version";
                    }
                    case 3: {
                        return "Description";
                    }
                }
                return "";
            }
            return UiLexicon.bajaui().getText("fileChooser.name");
        }

        public Object getValueAt(int row, int col) {
            if (this.kids[row] instanceof BIFile) {
                return this.getFileDetail(row, col);
            }
            if (this.kids[row] instanceof BModuleNavNode) {
                return this.getModuleDetail(row, col);
            }
            return super.getValueAt(row, col);
        }

        private final Object getFileDetail(int row, int col) {
            BIFile file = (BIFile)this.kids[row];
            switch (col) {
                case 0: {
                    return super.getValueAt(row, col);
                }
                case 1: {
                    if (file instanceof BIDirectory) {
                        return "";
                    }
                    long sz = file.getSize();
                    String size = sz < 1024L ? "1 KB" : String.valueOf(sz / 1024L) + " KB";
                    return size;
                }
                case 2: {
                    if (file.getLastModified().getMillis() == 0L) {
                        return "";
                    }
                    return String.valueOf(file.getLastModified());
                }
            }
            return null;
        }

        private final Object getModuleDetail(int row, int col) {
            BModuleNavNode module = (BModuleNavNode)this.kids[row];
            NModuleInfo info = module.info;
            switch (col) {
                case 0: {
                    return super.getValueAt(row, col);
                }
                case 1: {
                    return info.getVendor();
                }
                case 2: {
                    return info.getVendorVersion();
                }
                case 3: {
                    return info.getDescription();
                }
            }
            return null;
        }

        DetailsModel() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Controller
    extends TableController {
        public void handleEnter(BKeyEvent event) {
            int row = this.getTable().getSelection().getRow();
            if (row >= 0) {
                this.handleSelection(BListView.this.model.kids[row]);
            }
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            this.handleSelection(BListView.this.model.kids[row]);
        }

        void handleSelection(BINavNode file) {
            if (file instanceof BIDirectory || file instanceof BNavContainer) {
                BListView.this.fileModel.setDirectory(file);
            } else {
                BListView.this.fileModel.chooseSelectedFiles();
            }
        }

        public void keyPressed(BKeyEvent event) {
            super.keyPressed(event);
            if (event.getKeyCode() == 38 && event.isAltDown()) {
                BListView.this.fileModel.moveUpDirectory();
            }
        }

        public int getTextSearchColumn() {
            return 0;
        }

        Controller() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Selection
    extends TableSelection {
        public void select(int row, boolean clear) {
            super.select(row, clear);
            if (clear) {
                BListView.this.fileModel.deselectAll();
            }
            if (row < BListView.this.model.getRowCount()) {
                this.handleSelect(row);
            }
        }

        public void select(int anchor, int lead, boolean clear) {
            int start;
            int end;
            super.select(anchor, lead, clear);
            if (clear) {
                BListView.this.fileModel.deselectAll();
            }
            if ((end = lead) < (start = anchor)) {
                int temp = start;
                start = end;
                end = temp;
            }
            int r = start;
            while (r <= end) {
                this.handleSelect(r);
                ++r;
            }
        }

        public void select(int[] rows) {
            super.select(rows);
            int i = 0;
            while (i < rows.length) {
                this.handleSelect(i);
                ++i;
            }
        }

        public void deselect(int row) {
            super.deselect(row);
            BINavNode nav = BListView.this.model.get(row);
            if (nav instanceof BIFile) {
                BListView.this.fileModel.deselect((BIFile)nav);
            }
        }

        public void deselectAll() {
            super.deselectAll();
            BListView.this.fileModel.deselectAll();
        }

        private final void handleSelect(int row) {
            BINavNode nav = BListView.this.model.get(row);
            if (nav instanceof BIFile) {
                BListView.this.fileModel.select((BIFile)nav);
            }
        }

        Selection() {
        }
    }
}

