/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.file;

import com.tridium.ui.file.FileChooserModel;
import com.tridium.ui.theme.Theme;
import javax.baja.file.FilePath;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.naming.OrdQuery;
import javax.baja.nav.BINavNode;
import javax.baja.space.BSpace;
import javax.baja.sys.BModule;
import javax.baja.sys.BModuleSpace;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.util.UiLexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BFilePathBar
extends BWidget {
    public static final Type TYPE;
    static BInsets insets;
    static final char separatorChar = '/';
    FileChooserModel model;
    RectGeom[] bounds;
    int buttonSize;
    RectGeom leftButton;
    RectGeom rightButton;
    boolean leftButtonEnabled;
    boolean rightButtonEnabled;
    int offset;
    int armed;
    int pressed;
    MouseCursor origCursor;
    static /* synthetic */ Class class$com$tridium$ui$file$BFilePathBar;

    public Type getType() {
        return TYPE;
    }

    public void computePreferredSize() {
        BFont font = Theme.widget().getTextFont();
        int w = 200;
        double h = (font.getHeight() + BFilePathBar.insets.top + BFilePathBar.insets.bottom) * (double)2;
        this.setPreferredSize(w, h);
    }

    public void doLayout(BWidget[] kids) {
        BSpace space = this.model.getSpace();
        BINavNode[] path = this.model.getPath();
        this.bounds = new RectGeom[path.length];
        BFont font = Theme.widget().getTextFont();
        double x = BFilePathBar.insets.left;
        double y = font.getHeight() + BFilePathBar.insets.top * (double)2 + BFilePathBar.insets.bottom;
        int i = this.offset;
        while (i < path.length) {
            String name = "";
            if (i > 0) {
                name = name + ' ';
                if (!this.isLeadingChar(path[i - 1].getNavName())) {
                    name = name + "/ ";
                }
            }
            if (i == 0 && (this.model.getSpace() instanceof BModuleSpace || this.model.getSpace() instanceof BModule)) {
                OrdQuery[] q = this.model.getDirectory().getNavOrd().parse();
                BModule module = Sys.loadModule((String)((FilePath)q[q.length - 1]).getAuthority());
                name = name + module.getModuleName();
            } else {
                name = name + path[i].getNavName();
            }
            this.bounds[i] = new RectGeom(x, y, font.width(name), font.getHeight());
            x += this.bounds[i].width;
            ++i;
        }
    }

    private final boolean isLeadingChar(String s) {
        boolean bl = false;
        if (s.equals("!") || s.equals("^")) {
            bl = true;
        }
        return bl;
    }

    public void paint(Graphics g) {
        g.setBrush(Theme.widget().getWindowBackground());
        g.fillRect(0.0, 0.0, this.getWidth() - 1.0, this.getHeight() - 1.0);
        BINavNode[] path = this.model.getPath();
        BFont font = Theme.widget().getBoldText();
        double ascent = font.getAscent();
        double x = 0.0;
        double y = font.getHeight() + BFilePathBar.insets.top * (double)2 + BFilePathBar.insets.bottom;
        g.setFont(font);
        g.setBrush(Theme.pathBar().getControlBackground());
        g.fillRect(0.0, 0.0, this.getWidth() - 1.0, y - BFilePathBar.insets.bottom);
        g.setBrush(BColor.black);
        g.strokeLine(0.0, y - BFilePathBar.insets.bottom, this.getWidth() - 1.0, y - BFilePathBar.insets.bottom);
        g.setBrush(BColor.white);
        g.drawString(UiLexicon.bajaui().getText("fileChooser.currentPath"), BFilePathBar.insets.left, BFilePathBar.insets.top + font.getAscent());
        font = Theme.widget().getTextFont();
        g.setFont(font);
        int i = this.offset;
        while (i < this.bounds.length) {
            String prefix = "";
            if (i > 0) {
                prefix = prefix + ' ';
                if (!this.isLeadingChar(path[i - 1].getNavName())) {
                    prefix = prefix + "/ ";
                }
            }
            String name = path[i].getNavName();
            if (i == 0 && (this.model.getSpace() instanceof BModuleSpace || this.model.getSpace() instanceof BModule)) {
                OrdQuery[] q = this.model.getDirectory().getNavOrd().parse();
                BModule module = Sys.loadModule((String)((FilePath)q[q.length - 1]).getAuthority());
                name = module.getModuleName();
            }
            double dx = x + this.bounds[i].x;
            double dy = y + ascent;
            g.setBrush(BColor.black);
            g.drawString(prefix, dx, dy);
            if (this.armed == i) {
                g.setBrush(BColor.blue);
            }
            g.drawString(name, dx += font.width(prefix), dy);
            if (this.armed == i) {
                g.strokeLine(dx, dy + 1.0, dx + font.width(name) - 1.0, dy + 1.0);
            }
            ++i;
        }
        if (this.leftButtonEnabled) {
            this.paintLeftButton(g);
        }
        if (this.rightButtonEnabled) {
            this.paintRightButton(g);
        }
        g.setBrush(BColor.black);
        g.strokeRect(0.0, 0.0, this.getWidth() - 1.0, this.getHeight() - 1.0);
    }

    public void paintLeftButton(Graphics g) {
        g.setBrush(BColor.white);
        g.translate(this.leftButton.x, this.leftButton.y);
        int size = 4;
        double mid = this.leftButton.height / (double)2;
        double x = (this.leftButton.width - (double)size) / (double)2;
        g.strokeLine(x, mid, x + (double)size, mid);
        int i = 1;
        while (i <= size) {
            g.strokeLine(x + (double)i, mid - (double)i, x + (double)size, mid - (double)i);
            ++i;
        }
        i = 1;
        while (i <= size) {
            g.strokeLine(x + (double)i, mid + (double)i, x + (double)size, mid + (double)i);
            ++i;
        }
        g.translate(-this.leftButton.x, -this.leftButton.y);
    }

    public void paintRightButton(Graphics g) {
        g.setBrush(BColor.white);
        g.translate(this.rightButton.x, this.rightButton.y);
        double mid = this.rightButton.height / (double)2;
        double size = 4;
        double x = (this.rightButton.width - size) / (double)2;
        g.strokeLine(x, mid, x + size, mid);
        int i = 1;
        while ((double)i <= size) {
            g.strokeLine(x, mid - (double)i, x + size - (double)i, mid - (double)i);
            ++i;
        }
        i = 1;
        while ((double)i <= size) {
            g.strokeLine(x, mid + (double)i, x + size - (double)i, mid + (double)i);
            ++i;
        }
        g.translate(-this.rightButton.x, -this.rightButton.y);
    }

    public void mouseMoved(BMouseEvent event) {
        int old = this.armed;
        int i = this.offset;
        while (i < this.bounds.length) {
            if (this.bounds[i] != null && this.bounds[i].contains(event.getX(), event.getY())) {
                if (this.origCursor == null) {
                    this.origCursor = this.getMouseCursor();
                    this.setMouseCursor(MouseCursor.hand);
                }
                this.armed = this.pressed != -1 ? (this.pressed == i ? i : -1) : i;
                this.repaint();
                return;
            }
            ++i;
        }
        this.setMouseCursor(this.origCursor);
        this.origCursor = null;
        this.armed = -1;
        if (old != this.armed) {
            this.repaint();
        }
    }

    public void mouseDragged(BMouseEvent event) {
        this.mouseMoved(event);
    }

    public void mouseExited(BMouseEvent event) {
        this.mouseMoved(event);
    }

    public void mouseEntered(BMouseEvent event) {
        this.mouseMoved(event);
    }

    public void mousePressed(BMouseEvent event) {
        if (this.leftButtonEnabled && this.leftButton.contains(event.getX(), event.getY())) {
            --this.offset;
            if (this.offset < 0) {
                this.offset = 0;
            }
            this.relayout();
        } else if (this.rightButtonEnabled && this.rightButton.contains(event.getX(), event.getY())) {
            ++this.offset;
            if (this.offset > this.bounds.length - 1) {
                this.offset = this.bounds.length - 1;
            }
            this.relayout();
        } else {
            int i = this.offset;
            while (i < this.bounds.length) {
                if (this.bounds[i].contains(event.getX(), event.getY())) {
                    this.pressed = i;
                    this.repaint();
                    return;
                }
                ++i;
            }
        }
    }

    public void mouseReleased(BMouseEvent event) {
        int i = this.offset;
        while (i < this.bounds.length) {
            if (this.bounds[i] != null && this.bounds[i].contains(event.getX(), event.getY())) {
                if (this.pressed != i) break;
                BINavNode[] path = this.model.getPath();
                this.model.setDirectory(path[i]);
                break;
            }
            ++i;
        }
        this.pressed = -1;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.buttonSize = 16;
        this.leftButton = new RectGeom();
        this.rightButton = new RectGeom();
        this.leftButtonEnabled = false;
        this.rightButtonEnabled = false;
        this.offset = 0;
        this.armed = -1;
        this.pressed = -1;
    }

    public BFilePathBar(FileChooserModel model) {
        this.this();
        this.model = model;
    }

    public BFilePathBar() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$ui$file$BFilePathBar;
        if (clazz == null) {
            clazz = class$com$tridium$ui$file$BFilePathBar = BFilePathBar.class("[Lcom.tridium.ui.file.BFilePathBar;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        insets = BInsets.make((double)3, (double)6.0, (double)3, (double)6.0);
    }
}

