/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.awt.se;

import com.tridium.ui.BNiagaraWidgetApplication;
import com.tridium.ui.awt.AwtShellManager;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.baja.log.Log;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BInputMethodEvent;
import javax.baja.ui.text.BTextEditor;

public class InputMethodManager
implements InputMethodRequests {
    private static final AttributedCharacterIterator EMPTY_TEXT = new AttributedString("").getIterator();
    static final Log log = Log.getLog((String)"ui.inputmethod");
    private AwtShellManager shellManager;
    private BWidget focus;

    InputMethodManager(AwtShellManager shellManager) {
        this.shellManager = shellManager;
    }

    final void process(InputMethodEvent event) {
        BNiagaraWidgetApplication.inputActivity();
        this.focus = this.shellManager.getCurrentFocus();
        if (this.focus != null && this.focus instanceof BTextEditor) {
            BTextEditor editor = (BTextEditor)this.focus;
            BInputMethodEvent ime = new BInputMethodEvent(event.getID(), this.focus, event.getText(), event.getCaret(), event.getVisiblePosition(), event.getCommittedCharacterCount());
            editor.fireInputMethodEvent(ime);
        }
    }

    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
        if (this.focus != null && this.focus instanceof BTextEditor) {
            return ((BTextEditor)this.focus).getController().cancelLatestCommittedText(attributes);
        }
        return EMPTY_TEXT;
    }

    public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
        if (this.focus != null && this.focus instanceof BTextEditor) {
            return ((BTextEditor)this.focus).getController().getCommittedText(beginIndex, endIndex, attributes);
        }
        return EMPTY_TEXT;
    }

    public int getCommittedTextLength() {
        if (this.focus != null && this.focus instanceof BTextEditor) {
            return ((BTextEditor)this.focus).getController().getCommittedTextLength();
        }
        return 0;
    }

    public int getInsertPositionOffset() {
        if (this.focus != null && this.focus instanceof BTextEditor) {
            return ((BTextEditor)this.focus).getController().getInsertPositionOffset();
        }
        return 0;
    }

    public TextHitInfo getLocationOffset(int x, int y) {
        if (this.focus != null && this.focus instanceof BTextEditor) {
            return ((BTextEditor)this.focus).getController().getLocationOffset(x, y);
        }
        return null;
    }

    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
        if (this.focus != null && this.focus instanceof BTextEditor) {
            return ((BTextEditor)this.focus).getController().getSelectedText(attributes);
        }
        return null;
    }

    public Rectangle getTextLocation(TextHitInfo offset) {
        if (this.focus != null && this.focus instanceof BTextEditor) {
            return ((BTextEditor)this.focus).getController().getTextLocation(offset);
        }
        return null;
    }

    void trace(String msg, int id, TextHitInfo caret, AttributedCharacterIterator text, int count, char c) {
        StringBuffer s = new StringBuffer(this.toString());
        s.append(' ');
        s.append(msg);
        s.append(' ');
        switch (id) {
            case 1101: {
                s.append("CaretChanged");
                break;
            }
            case 1100: {
                s.append("IMTextChanged");
                break;
            }
            default: {
                s.append("InputMethodEvent");
            }
        }
        s.append("[Char=").append(c);
        if (caret != null) {
            s.append(" TextHitInfo=[").append(caret.getCharIndex()).append(",");
            if (caret.isLeadingEdge()) {
                s.append("TRUE]");
            } else {
                s.append("FALSE]");
            }
        }
        if (text != null && text.getAttributes() != null) {
            s.append(" Attributes=").append(text.getAttributes());
        }
        s.append(" CommittedCount=").append(count);
        s.append("]");
        log.trace(s.toString());
    }
}

