/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.awt.se;

import com.tridium.ui.awt.AwtShellManager;
import com.tridium.ui.awt.DragOperation;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.dnd.DragSource;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.baja.gx.Graphics;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BValue;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.UndoManager;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.util.UiLexicon;

public class AwtSeDragOperation
extends DragOperation {
    BTransferWidget source;
    BMouseEvent gestureEvent;
    TransferContext context;
    DragRenderer dragRenderer;
    int actions;
    AwtShellManager dragManager;
    AwtShellManager curManager;
    AwtShellManager exitManager;
    int mx;
    int my;
    int lastx;
    int lasty;
    boolean pulse;
    BTransferWidget dragOver;
    int overActions;

    public AwtSeDragOperation(AwtShellManager manager, BTransferWidget source, BMouseEvent gestureEvent, TransferContext context, DragRenderer dragRenderer) {
        this.dragManager = manager;
        this.curManager = manager;
        this.mx = this.lastx = manager.mouseManager.lastX();
        this.my = this.lasty = manager.mouseManager.lastY();
        this.source = source;
        this.gestureEvent = gestureEvent;
        this.context = context;
        this.dragRenderer = dragRenderer;
        this.actions = 16;
        this.updateMouse(this.mx, this.my, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintDragEffect(AwtShellManager manager, Graphics g) {
        if (manager != this.curManager) {
            return;
        }
        g.push();
        try {
            RectGeom effect = this.dragRenderer.getDragEffectRectGeom();
            g.translate((double)this.mx, (double)this.my);
            g.clip(effect.x, effect.y, effect.width, effect.height);
            this.dragRenderer.paintDragEffect(g);
        }
        finally {
            g.pop();
        }
    }

    public void process(AwtShellManager manager, MouseEvent event) {
        int x = event.getX();
        int y = event.getY();
        if (event.getID() == 504) {
            this.curManager = manager;
            this.updateMouse(x, y, false);
        } else if (event.getID() == 505) {
            this.fireDragEnterExit(null);
            this.exitManager = this.curManager;
            this.curManager = null;
            this.exitManager.repaint();
            this.exitManager.setCursor(Cursor.getPredefinedCursor(0));
        } else if (event.getID() == 506) {
            if (this.curManager != null) {
                Point pt = this.translateDragToCur(x, y);
                this.updateMouse(pt.x, pt.y, false);
            }
        } else if (event.getID() == 502) {
            AwtShellManager.dragOperation = null;
            if (this.curManager != null) {
                Point pt = this.translateDragToCur(x, y);
                this.updateMouse(pt.x, pt.y, false);
                this.curManager.setCursor(Cursor.getPredefinedCursor(0));
                this.drop(event);
            }
        }
    }

    public void pulse() {
        this.updateMouse(this.mx, this.my, true);
    }

    public void process(AwtShellManager manager, KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.cancel();
        }
    }

    private void updateMouse(int newx, int newy, boolean pulse) {
        this.lastx = this.mx;
        this.lasty = this.my;
        this.mx = newx;
        this.my = newy;
        this.pulse = pulse;
        this.repaintDirty();
        this.checkDropZone();
    }

    private void repaintDirty() {
        AwtShellManager curManager = this.curManager;
        if (curManager == null) {
            return;
        }
        RectGeom effect = this.dragRenderer.getDragEffectRectGeom();
        RectGeom r1 = new RectGeom((IRectGeom)effect);
        RectGeom r2 = new RectGeom((IRectGeom)effect);
        r1.translate((double)this.lastx, (double)this.lasty);
        r2.translate((double)this.mx, (double)this.my);
        RectGeom dirty = RectGeom.bounds((IRectGeom)r1, (IRectGeom)r2, null);
        if (dirty.x < 0.0) {
            dirty.x = 0.0;
        }
        if (dirty.y < 0.0) {
            dirty.y = 0.0;
        }
        curManager.repaint((int)dirty.x, (int)dirty.y, (int)dirty.width, (int)dirty.height);
    }

    private void checkDropZone() {
        AwtShellManager curManager = this.curManager;
        if (curManager == null) {
            return;
        }
        Cursor cursor = DragSource.DefaultCopyNoDrop;
        try {
            BTransferWidget target = null;
            BWidget over = curManager.widgetAt(new javax.baja.gx.Point((double)this.mx, (double)this.my), true);
            if (over instanceof BTransferWidget) {
                target = (BTransferWidget)over;
            }
            this.fireDragEnterExit(target);
            if (target != null) {
                this.overActions = target.dragOver(this.dragContext(target, this.actions));
                if (this.overActions != 0) {
                    cursor = DragSource.DefaultCopyDrop;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        curManager.setCursor(cursor);
    }

    private void fireDragEnterExit(BTransferWidget newOver) {
        BTransferWidget oldOver = this.dragOver;
        if (oldOver != newOver) {
            this.dragOver = newOver;
            try {
                if (oldOver != null) {
                    oldOver.dragExit(this.dragContext(oldOver, this.actions));
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                if (newOver != null) {
                    newOver.dragEnter(this.dragContext(newOver, this.actions));
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void cancel() {
        AwtShellManager.dragOperation = null;
        this.fireDragEnterExit(null);
        if (this.curManager != null) {
            this.curManager.repaint();
            this.curManager.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void drop(MouseEvent event) {
        this.dragManager.mouseManager.holdRelease = true;
        if (this.dragOver == null) {
            return;
        }
        if (this.overActions == 0) {
            this.dragOver.dragExit(this.dragContext(this.dragOver, 0));
            return;
        }
        if ((event.getModifiers() & 4) != 0) {
            this.popupForAction();
        } else {
            this.fireDrop(this.dragOver, this.dragContext(this.dragOver, 16));
        }
    }

    private void popupForAction() {
        UiLexicon lex = UiLexicon.bajaui();
        DragOperation.PopupCommand cmdCopy = new DragOperation.PopupCommand(this.dragOver, lex.getText("commands.copy.label"), 16);
        DragOperation.PopupCommand cmdMove = new DragOperation.PopupCommand(this.dragOver, lex.getText("commands.move.label"), 32);
        DragOperation.PopupCommand cmdCancel = new DragOperation.PopupCommand(this.dragOver, lex.getText("action.cancel"), -1);
        if ((this.overActions & 0x10) == 0) {
            cmdCopy.setEnabled(false);
        }
        if ((this.overActions & 0x20) == 0) {
            cmdMove.setEnabled(false);
        }
        BMenu menu = new BMenu();
        menu.add("copy", cmdCopy);
        menu.add("move", cmdMove);
        menu.add("sep", (BValue)new BSeparator());
        menu.add("cancel", cmdCancel);
        javax.baja.gx.Point pt = new javax.baja.gx.Point((double)this.mx, (double)this.my);
        this.curManager.shellToWidget(this.dragOver, pt);
        menu.open(this.dragOver, pt.x, pt.y);
    }

    public void fireDrop(BTransferWidget target, int action) {
        this.fireDrop(target, this.dragContext(target, action));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireDrop(BTransferWidget target, TransferContext cx) {
        this.curManager.enterBusy(null);
        try {
            UndoManager um;
            CommandArtifact art = target.drop(cx);
            if (art != null && (um = target.getUndoManager()) != null) {
                um.addArtifact(art);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            String title = UiLexicon.bajaui().getText("dialog.error");
            String msg = UiLexicon.bajaui().getText("drop.error");
            BDialog.error((BWidget)target, title, (Object)msg, e);
        }
        finally {
            this.curManager.exitBusy(null);
            this.curManager.repaint();
        }
    }

    private TransferContext dragContext(BTransferWidget target, int action) {
        javax.baja.gx.Point pt = new javax.baja.gx.Point((double)this.mx, (double)this.my);
        this.curManager.shellToWidget(target, pt);
        this.context.setAction(action);
        this.context.setPosition(pt.x, pt.y);
        this.context.setPulse(this.pulse);
        return this.context;
    }

    private Point translateDragToCur(int x, int y) {
        Point pt = new Point(x, y);
        Point dragLoc = this.dragManager.getLocationOnScreen();
        Point curLoc = this.curManager.getLocationOnScreen();
        pt.translate(dragLoc.x, dragLoc.y);
        pt.translate(-curLoc.x, -curLoc.y);
        return pt;
    }
}

