/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.awt;

import com.tridium.ui.BNiagaraWidgetApplication;
import com.tridium.ui.Binder;
import com.tridium.ui.awt.AwtShellManager;
import java.io.PrintWriter;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Clock;

public class Perf {
    public static final boolean enabled = true;
    public AwtShellManager mgr;
    public int numShellPaint;
    public long durTotalPaint;
    public long durWidgetLayout;
    public long durCreateBuffer;
    public long durClearClip;
    public long durWidgetPaint;
    public long durDrawBuffer;

    public void dump() {
        PrintWriter out = new PrintWriter(System.out);
        this.dump(out);
        out.flush();
    }

    public void dump(PrintWriter out) {
        if (this.numShellPaint == 0) {
            return;
        }
        out.println("numShellPaint:     " + this.numShellPaint);
        out.println("durTotalPaint:     " + this.ns(this.durTotalPaint));
        out.println("durWidgetLayout:   " + this.percent(this.durWidgetLayout));
        out.println("durCreateBuffer:   " + this.percent(this.durCreateBuffer));
        out.println("durClearClip:      " + this.percent(this.durClearClip));
        out.println("durWidgetPaint:    " + this.percent(this.durWidgetPaint));
        out.println("durDrawBuffer:     " + this.percent(this.durDrawBuffer));
        out.println("avgTotalPaint:     " + this.ns(this.durTotalPaint / (long)this.numShellPaint));
        out.println("avgWidgetLayout:   " + this.ns(this.durWidgetLayout / (long)this.numShellPaint));
        out.println("avgWidgetPaint:    " + this.ns(this.durWidgetPaint / (long)this.numShellPaint));
        out.println("checkItemDelay:    " + Binder.checkItemsDelay);
        out.println("animateDelay:      " + BNiagaraWidgetApplication.animateDelay);
        out.println("runGc:             " + BNiagaraWidgetApplication.runGc);
    }

    public String percent(long ns) {
        String s = this.ns(ns);
        double percent = (double)ns / (double)this.durTotalPaint * 100.0;
        return TextUtil.pad((String)s, (int)8) + "  " + (int)percent + '%';
    }

    public String ns(long ns) {
        if (ns < 2000000L) {
            return ns + "ns";
        }
        return ns / 1000000L + "ms";
    }

    public static long now() {
        return Clock.nanoTicks();
    }

    Perf(AwtShellManager mgr) {
        this.mgr = mgr;
    }
}

