/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.awt;

import com.tridium.ui.UiEnv;
import com.tridium.ui.awt.AwtShellManager;
import com.tridium.ui.awt.AwtUiEnv;
import com.tridium.ui.awt.DragOperation;
import com.tridium.ui.awt.PanelPeer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Stack;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Point;
import javax.baja.sys.BComplex;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BMenu;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;

public class NPopup
extends Window {
    private static Stack stack = new Stack();
    private static boolean consumeUntilRelease;
    private AwtShellManager shellManager;
    private AwtShellManager masterShellManager;
    private BWidget widget;

    public static NPopup open(BWidget widget, BWidget owner, double x, double y) {
        return NPopup.open(widget, owner, x, y, -1.0, -1.0);
    }

    public static NPopup open(BWidget widget, BWidget owner, double x, double y, double fixedWidth, double fixedHeight) {
        AwtShellManager masterShellManager = null;
        masterShellManager = stack.size() == 0 ? (AwtShellManager)owner.widgetSupport(null) : ((PopupEntry)NPopup.stack.elementAt((int)0)).popup.masterShellManager;
        NPopup popup = (NPopup)AccessController.doPrivileged(new PrivilegedPopupFactory(masterShellManager, widget, owner, x, y, fixedWidth, fixedHeight));
        PopupEntry entry = new PopupEntry(popup, widget, owner);
        stack.push(entry);
        widget.setVisible(true);
        popup.setVisible(true);
        popup.takeTempFocus();
        return popup;
    }

    /*
     * Unable to fully structure code
     */
    public static void close(BWidget widget) {
        if (widget == null || NPopup.isOpen(widget)) ** GOTO lbl16
        return;
lbl-1000:
        // 1 sources

        {
            entry = (PopupEntry)NPopup.stack.pop();
            if (NPopup.stack.isEmpty() && entry.owner instanceof BMenu.MenuCloseListener && entry.widget instanceof BMenu) {
                try {
                    ((BMenu.MenuCloseListener)entry.owner).menuClosed((BMenu)entry.widget);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            entry.close();
            if (NPopup.stack.size() > 0) {
                ((PopupEntry)NPopup.stack.peek()).popup.takeTempFocus();
            }
            entry.popup.shellManager.disposeBuffer();
            if (entry.widget != widget) continue;
            return;
lbl16:
            // 2 sources

            ** while (!NPopup.stack.isEmpty())
        }
lbl17:
        // 1 sources

    }

    public static boolean isOpen(BWidget widget) {
        int i = 0;
        while (i < stack.size()) {
            if (((PopupEntry)NPopup.stack.elementAt((int)i)).widget == widget) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean cancel(KeyEvent event) {
        if (consumeUntilRelease) {
            if (event.getID() == 402) {
                consumeUntilRelease = false;
            }
            return true;
        }
        if (stack.size() == 0) {
            return false;
        }
        if (event.getID() == 401 && event.getKeyCode() == 27) {
            return NPopup.doCancel();
        }
        return false;
    }

    public static boolean cancel(MouseEvent event) {
        if (consumeUntilRelease) {
            if (event.getID() == 502) {
                consumeUntilRelease = false;
            }
            return true;
        }
        if (stack.size() == 0) {
            return false;
        }
        if (event.getID() == 501 && !(event.getComponent().getParent() instanceof NPopup)) {
            return NPopup.doCancel();
        }
        return false;
    }

    static boolean doCancel() {
        try {
            Command cmd;
            BMenuItem[] items;
            PopupEntry top = (PopupEntry)stack.get(0);
            if (top.widget instanceof BMenu && (items = ((BMenu)top.widget).getMenuItems()).length > 0 && (cmd = items[0].getCommand()) instanceof DragOperation.PopupCommand) {
                ((DragOperation.PopupCommand)cmd).popupCanceled();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        NPopup.close(null);
        consumeUntilRelease = true;
        return true;
    }

    public void takeTempFocus() {
        this.shellManager.takeTempFocus(this.masterShellManager);
    }

    public void releaseTempFocus() {
        this.shellManager.releaseTempFocus(this.masterShellManager);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    private final void insureOnScreen(BWidget owner, int x, int y, int w, int h) {
        IRectGeom srect = UiEnv.get().getScreenBounds(owner);
        int sx = (int)srect.x();
        int sy = (int)srect.y();
        int sw = (int)srect.width();
        int sh = (int)srect.height();
        if (x + w > sx + sw) {
            x = this.fitX(x, w, sx, sw);
        }
        if (y + h > sy + sh) {
            y = this.fitY(y, h, sy, sh);
        }
        if (x < sx) {
            x = sx;
        }
        if (y < sy) {
            y = sy;
        }
        this.setLocation(x, y);
    }

    private final int fitX(int x, int w, int sx, int sw) {
        NPopup parent = this.parentOnStack();
        if (parent == null) {
            return sx + sw - w;
        }
        return parent.getX() - w;
    }

    private final int fitY(int y, int h, int sy, int sh) {
        NPopup parent = this.parentOnStack();
        if (parent == null) {
            return sy + sh - h;
        }
        return y - h + 14;
    }

    private final NPopup parentOnStack() {
        int i = 1;
        while (i < stack.size()) {
            PopupEntry entry = (PopupEntry)stack.elementAt(i);
            if (entry.popup == this) {
                return ((PopupEntry)NPopup.stack.elementAt((int)(i - 1))).popup;
            }
            ++i;
        }
        return null;
    }

    private NPopup(AwtShellManager masterShellManager, BWidget widget, BWidget owner, double x, double y, double w, double h) {
        super(masterShellManager.getWindow());
        this.masterShellManager = masterShellManager;
        this.shellManager = ((AwtUiEnv)AwtUiEnv.get()).makeAwtShellManager(widget, new PanelPeer());
        this.widget = widget;
        widget.widgetSupport(this.shellManager);
        this.setLayout(new BorderLayout());
        this.add((Component)this.shellManager, "Center");
        Point pt = owner.translateToScreen(new Point(x, y));
        x = pt.x;
        y = pt.y;
        if (w == -1.0 || h == -1.0) {
            widget.computePreferredSize();
            if (w == -1.0) {
                w = widget.getPreferredWidth();
            }
            if (h == -1.0) {
                h = widget.getPreferredHeight();
            }
        }
        this.setBounds((int)x, (int)y, (int)w, (int)h);
        this.insureOnScreen(owner, (int)x, (int)y, (int)w, (int)h);
    }

    static class PopupEntry {
        NPopup popup;
        BWidget widget;
        BWidget owner;

        void close() {
            this.popup.releaseTempFocus();
            this.widget.setVisible(false);
            this.popup.setVisible(false);
            try {
                BComplex parent = this.popup.widget.getParent();
                if (this.owner instanceof BDropDown) {
                    ((BDropDown)this.owner).doCloseDropDown();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.popup.dispose();
        }

        PopupEntry(NPopup popup, BWidget widget, BWidget owner) {
            this.popup = popup;
            this.widget = widget;
            this.owner = owner;
        }
    }

    static class PrivilegedPopupFactory
    implements PrivilegedAction {
        AwtShellManager masterShellManager;
        BWidget widget;
        BWidget owner;
        double x;
        double y;
        double w;
        double h;

        public Object run() {
            return new NPopup(this.masterShellManager, this.widget, this.owner, this.x, this.y, this.w, this.h);
        }

        PrivilegedPopupFactory(AwtShellManager masterShellManager, BWidget widget, BWidget owner, double x, double y, double w, double h) {
            this.masterShellManager = masterShellManager;
            this.widget = widget;
            this.owner = owner;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }
}

