/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.awt;

import com.tridium.sys.Nre;
import com.tridium.ui.BNiagaraWidgetApplication;
import com.tridium.ui.UiEnv;
import com.tridium.ui.awt.AwtShellManager;
import com.tridium.ui.awt.AwtUiEnv;
import com.tridium.ui.awt.DragOperation;
import com.tridium.ui.awt.NPopup;
import java.awt.event.MouseEvent;
import javax.baja.gx.Point;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;

public class MouseManager {
    public static final int PRESSED = 501;
    public static final int RELEASED = 502;
    public static final int ENTERED = 504;
    public static final int EXITED = 505;
    public static final int MOVED = 503;
    public static final int DRAGGED = 506;
    public static final int WHEEL = 507;
    public static final int PULSED = 510;
    public static final int DRAG_STARTED = 511;
    public static final int HOVER = 512;
    static final int FIRST_PULSE_MILLIS = 700;
    static final int PULSE_MILLIS = 150;
    static final int DRAG_TOLERANCE = 10;
    static final int HOVER_MILLIS = 700;
    static MouseManager hoverManager = null;
    static final HoverThread hoverThread = new HoverThread();
    static MouseManager pulseManager;
    static final PulseThread pulseThread;
    AwtShellManager shellManager;
    BWidget over;
    BWidget active;
    int lastX;
    int lastY;
    int lastModifiers;
    int pressX;
    int pressY;
    boolean firedDragStarted;
    IMouseOverride override;
    public boolean holdRelease;

    public BWidget over() {
        return this.over;
    }

    public int lastX() {
        return this.lastX;
    }

    public int lastY() {
        return this.lastY;
    }

    public void setMouseOverride(IMouseOverride override) {
        this.override = override;
    }

    final void process(MouseEvent event) {
        BNiagaraWidgetApplication.inputActivity();
        if (NPopup.cancel(event)) {
            return;
        }
        switch (event.getID()) {
            case 501: {
                this.pressed(event);
                return;
            }
            case 502: {
                this.released(event);
                return;
            }
            case 505: {
                this.exited(event);
                return;
            }
            case 503: {
                this.moved(event);
                return;
            }
            case 506: {
                this.dragged(event);
                return;
            }
        }
    }

    private final void pressed(MouseEvent event) {
        BWidget t;
        this.active = t = this.getTarget(event);
        this.pressX = event.getX();
        this.pressY = event.getY();
        this.firedDragStarted = false;
        this.fire(501, event, t);
        this.startPulse();
    }

    private final void released(MouseEvent event) {
        this.stopPulse();
        if (this.holdRelease) {
            this.holdRelease = false;
        } else {
            this.fire(502, event, this.active);
        }
        BWidget t = this.getTarget(event);
        if (t != this.active) {
            if (t != null) {
                this.fire(504, event, t);
            }
            if (this.over != t && this.over != null) {
                this.fire(505, event, this.over);
            }
            this.over = t;
        }
        this.active = null;
    }

    private final void exited(MouseEvent event) {
        if (this.over != null) {
            this.fire(505, event, this.over);
        }
        this.over = null;
    }

    void checkOver() {
        if (this.active != null && this.active.isEnabled() && this.active.widgetSupport(null) != null) {
            return;
        }
        this.moved(new MouseEvent(this.shellManager, 503, System.currentTimeMillis(), this.lastModifiers, this.lastX, this.lastY, 0, false));
    }

    private final void moved(MouseEvent event) {
        BWidget t = this.getTarget(event);
        if (t != this.over) {
            if (this.over != null) {
                this.fire(505, event, this.over);
            }
            if (t != null) {
                this.fire(504, event, t);
            }
            this.over = t;
            this.shellManager.updateMouseCursor();
        } else if (t != null) {
            this.fire(503, event, t);
        }
    }

    private final void dragged(MouseEvent event) {
        BWidget t = this.getTarget(event);
        if (t != this.over) {
            if (t == this.active) {
                this.fire(504, event, this.active);
            } else {
                this.fire(505, event, this.active);
            }
            this.over = t;
        }
        this.fire(506, event, this.active);
        if (!this.firedDragStarted) {
            int dist;
            int dy;
            int mx = event.getX();
            int my = event.getY();
            int dx = mx - this.pressX;
            if (dx < 0) {
                dx = -dx;
            }
            if ((dy = my - this.pressY) < 0) {
                dy = -dy;
            }
            if ((dist = Math.max(dx, dy)) > 10) {
                this.firedDragStarted = true;
                BWidget w = this.active;
                if (w != null) {
                    Point pt = new Point((double)this.pressX, (double)this.pressY);
                    this.shellManager.shellToWidget(w, pt);
                    this.fire(new BMouseEvent(511, w, event.getWhen(), this.lastModifiers, pt.x, pt.y, -1, false));
                }
            }
        }
    }

    private final void hover() {
        BWidget w = this.over;
        if (w != null) {
            Point pt = new Point((double)this.lastX, (double)this.lastY);
            this.shellManager.shellToWidget(w, pt);
            this.fire(new BMouseEvent(512, w, this.lastModifiers, pt.x, pt.y, -1, false));
        }
    }

    private final void pulse() {
        BWidget w = this.active;
        if (w != null) {
            Point pt = new Point((double)this.lastX, (double)this.lastY);
            this.shellManager.shellToWidget(w, pt);
            this.fire(new BMouseEvent(510, w, this.lastModifiers, pt.x, pt.y, -1, false));
            DragOperation dragOp = AwtShellManager.dragOperation;
            if (dragOp != null) {
                dragOp.pulse();
            }
        }
    }

    public BMouseEvent fire(int id, MouseEvent src, BWidget w) {
        if (w == null) {
            return null;
        }
        try {
            BMouseEvent event;
            if (!UiEnv.get().hasMouse() && id == 501) {
                this.fire(504, src, w);
                this.fire(503, src, w);
            }
            this.lastX = src.getX();
            this.lastY = src.getY();
            this.lastModifiers = src.getModifiers();
            Point pt = new Point((double)src.getX(), (double)src.getY());
            this.shellManager.shellToWidget(w, pt);
            if (id == 507) {
                event = ((AwtUiEnv)AwtUiEnv.get()).makeMouseWheelEvent(id, src, w, pt);
            } else {
                boolean isPopupTrigger = src.isPopupTrigger();
                if (this.override != null && this.override.isPopupTrigger()) {
                    if (id == 502) {
                        isPopupTrigger = true;
                        this.override.mouseReleased();
                    }
                    this.lastModifiers &= 0xFFFFFFEF;
                    this.lastModifiers |= 4;
                }
                event = new BMouseEvent(id, w, src.getWhen(), this.lastModifiers, pt.x, pt.y, src.getClickCount(), isPopupTrigger);
            }
            this.fire(event);
            if (id == 504) {
                this.startHover();
            }
            if (!UiEnv.get().hasMouse() && id == 502) {
                this.fire(505, src, w);
            }
            return event;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private final void fire(BMouseEvent event) {
        try {
            event.getWidget().fireMouseEvent(event);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private final BWidget getTarget(MouseEvent event) {
        Point pt = new Point((double)event.getX(), (double)event.getY());
        BWidget target = this.shellManager.widgetAt(pt, true);
        while (target != null && !target.receiveInputEvents()) {
            target = target.getParentWidget();
        }
        return target;
    }

    private final String eventIdToString(int id) {
        switch (id) {
            case 501: {
                return "Pressed";
            }
            case 502: {
                return "Released";
            }
            case 504: {
                return "Entered";
            }
            case 505: {
                return "Exited";
            }
            case 503: {
                return "Moved";
            }
            case 506: {
                return "Dragged";
            }
        }
        return "????";
    }

    private final String toString(BMouseEvent event, BWidget widget) {
        switch (event.getId()) {
            case 501: {
                return "Pressed:  " + widget;
            }
            case 502: {
                return "Released: " + widget;
            }
            case 504: {
                return "Entered:  " + widget;
            }
            case 505: {
                return "Exited:   " + widget;
            }
            case 503: {
                return "Moved:    " + widget;
            }
            case 506: {
                return "Dragged:  " + widget;
            }
        }
        return "????";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void startHover() {
        hoverThread.interrupt();
        hoverManager = this;
        HoverThread hoverThread = MouseManager.hoverThread;
        synchronized (hoverThread) {
            MouseManager.hoverThread.notifyAll();
            return;
        }
    }

    private final void stopHover() {
        hoverManager = null;
    }

    void resetHover(BWidget w) {
        this.startHover();
    }

    private final void startPulse() {
        pulseThread.interrupt();
        pulseManager = this;
    }

    private final void stopPulse() {
        pulseManager = null;
    }

    MouseManager(AwtShellManager shellManager) {
        this.shellManager = shellManager;
    }

    static {
        hoverThread.start();
        pulseManager = null;
        pulseThread = new PulseThread();
        pulseThread.start();
    }

    public static interface IMouseOverride {
        public boolean isPopupTrigger();

        public void mouseReleased();
    }

    private static class HoverThread
    extends Thread {
        int pulseTime;

        public void run() {
            while (true) {
                try {
                    HoverThread.sleep(700L);
                    if (hoverManager != null) {
                        try {
                            hoverManager.hover();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                    Thread.sleep(Long.MAX_VALUE);
                    continue;
                }
                catch (InterruptedException e) {
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        HoverThread() {
            super(Nre.mainThreadGroup, "Ui:HoverThread");
            this.setDaemon(true);
        }
    }

    private static class PulseThread
    extends Thread {
        int pulseTime;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        block13: {
                            PulseThread pulseThread = this;
                            synchronized (pulseThread) {
                                while (true) {
                                    if (pulseManager != null) {
                                        // MONITOREXIT @DISABLED, blocks:[0, 3, 8, 9, 10, 12] lbl13 : MonitorExitStatement: MONITOREXIT : var1_1
                                        if (pulseManager != null) {
                                            break;
                                        }
                                        break block13;
                                    }
                                    this.pulseTime = 700;
                                    this.wait();
                                }
                            }
                            try {
                                pulseManager.pulse();
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                        Thread.sleep(this.pulseTime);
                        this.pulseTime = 150;
                    }
                }
                catch (InterruptedException e) {
                    this.pulseTime = 700;
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        PulseThread() {
            super(Nre.mainThreadGroup, "Ui:PulseThread");
            this.setDaemon(true);
        }
    }
}

