/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui;

import com.tridium.ui.BKeyboard;
import com.tridium.ui.DialogPeer;
import com.tridium.ui.FramePeer;
import com.tridium.ui.KeyboardLayout;
import com.tridium.ui.NullUiEnv;
import com.tridium.ui.ShellManager;
import com.tridium.ui.ShellPeer;
import com.tridium.ui.WindowPeer;
import javax.baja.gx.BInsets;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Insets;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.ui.BDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetApplication;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.BWindow;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.PasswordRenderer;
import javax.baja.ui.text.TextController;
import javax.baja.ui.transfer.TransferEnvelope;

public abstract class UiEnv {
    private static UiEnv env;
    public static Object appLock;
    public static BWidgetApplication app;
    public static final int CURSOR_DEFAULT = 0;
    public static final int CURSOR_CROSSHAIR = 1;
    public static final int CURSOR_HAND = 2;
    public static final int CURSOR_MOVE = 3;
    public static final int CURSOR_TEXT = 4;
    public static final int CURSOR_WAIT = 5;
    public static final int CURSOR_E_RESIZE = 6;
    public static final int CURSOR_W_RESIZE = 7;
    public static final int CURSOR_N_RESIZE = 8;
    public static final int CURSOR_S_RESIZE = 9;
    public static final int CURSOR_NE_RESIZE = 10;
    public static final int CURSOR_NW_RESIZE = 11;
    public static final int CURSOR_SE_RESIZE = 12;
    public static final int CURSOR_SW_RESIZE = 13;
    public static final int CURSOR_GRAB_HAND = 14;
    public static final int CURSOR_OPEN_HAND = 15;
    public static final int CURSOR_DO_NOT_ENTER = 16;
    public static final int CURSOR_STACK = 17;
    public static final int CURSOR_DROP_LEFT = 18;
    public static final int CURSOR_DROP_RIGHT = 19;
    public static final int CURSOR_DROP_TOP = 20;
    public static final int CURSOR_DROP_BOTTOM = 21;
    public static final int CURSOR_DROPPER = 22;
    public static final int CURSOR_LINK_LEFT = 23;
    public static final int CURSOR_LINK_RIGHT = 24;
    public static final int CURSOR_MAGNIFY = 25;
    private boolean hasKeyboard = new Boolean(System.getProperty("bajaui.hasKeyboard", "true"));
    private boolean hasMouse = new Boolean(System.getProperty("bajaui.hasMouse", "true"));
    private boolean hasTouchscreen = new Boolean(System.getProperty("bajaui.hasTouchscreen", "false"));

    public static UiEnv get() {
        if (env == null) {
            try {
                if (System.getProperty("os.name", "").equals("QNX")) {
                    if (System.getProperty("niagara.ui.env", "").equals("AwtMeUiEnv")) {
                        env = (UiEnv)Sys.newInstance((String)"bajaui", (String)"com.tridium.ui.awt.me.AwtMeUiEnv");
                        return env;
                    }
                    if (System.getProperty("niagara.ui.env", "").equals("PwtUiEnv")) {
                        env = (UiEnv)Sys.newInstance((String)"pwt", (String)"com.tridium.pwt.ui.PwtUiEnv");
                        return env;
                    }
                    env = new NullUiEnv();
                    return env;
                }
                env = (UiEnv)Sys.newInstance((String)"bajaui", (String)"com.tridium.ui.awt.se.AwtSeUiEnv");
                return env;
            }
            catch (Throwable e) {
                e.printStackTrace();
                env = new NullUiEnv();
                return env;
            }
        }
        return env;
    }

    public abstract boolean isMicroEdition();

    public boolean hasKeyboard() {
        return this.hasKeyboard;
    }

    public boolean hasMouse() {
        return this.hasMouse;
    }

    public boolean hasTouchscreen() {
        return this.hasTouchscreen;
    }

    public void setHasKeyboard(boolean v) {
        this.hasKeyboard = v;
    }

    public void setHasMouse(boolean v) {
        this.hasMouse = v;
    }

    public void setHasTouchscreen(boolean v) {
        this.hasTouchscreen = v;
    }

    public void input(BTextEditor editor) {
        this.input(editor, null);
    }

    public void input(BTextEditor editor, KeyboardLayout layout) {
        BWidget top;
        BTextEditor working;
        if (editor instanceof BTextField) {
            BTextField field = (BTextField)editor;
            working = new BTextField(field.getText(), field.getVisibleColumns());
            if (editor.getRenderer() instanceof PasswordRenderer) {
                working.setRenderer(new PasswordRenderer());
            }
            top = working;
        } else {
            working = new BTextEditor(editor.getText(), true);
            top = new BTextEditorPane(working, 4, 80);
        }
        working.setController(new TextController(){

            public final void mouseReleased(BMouseEvent event) {
            }
        });
        BKeyboard keyboard = new BKeyboard(working, layout);
        BGridPane grid = new BGridPane();
        grid.setColumnCount(1);
        grid.add("editor", (BValue)top);
        BEdgePane edge = new BEdgePane();
        edge.setTop(new BBorderPane((BWidget)grid, BInsets.make((double)0.0, (double)0.0, (double)5, (double)0.0)));
        edge.setCenter(keyboard);
        BBorderPane pane = new BBorderPane((BWidget)edge, BInsets.make((double)10.0));
        int r = BDialog.open(editor, "Text Input", pane, 3);
        if (r != 1) {
            return;
        }
        editor.setText(working.getText());
    }

    public abstract void setKiosk(BWidgetShell var1);

    public abstract IRectGeom getScreenBounds(BWidget var1);

    public abstract IRectGeom getScreenBounds(double var1, double var3);

    public abstract Insets getWindowInsets(BWindow var1);

    public abstract ShellManager makeShellManager(BWidgetShell var1);

    public abstract ShellManager makeShellManager(BWidgetShell var1, ShellPeer var2);

    public abstract FramePeer makeFramePeer(String var1);

    public abstract DialogPeer makeDialogPeer(BWidget var1, String var2, boolean var3);

    public abstract WindowPeer makeWindowPeer(BWidget var1);

    public abstract WindowPeer makeRoundedWindowPeer(BWidget var1, float var2, float var3);

    public abstract FramePeer makeRoundedFramePeer(String var1, float var2, float var3);

    public abstract DialogPeer makeRoundedDialogPeer(BWidget var1, String var2, boolean var3, float var4, float var5);

    public abstract MouseCursor makeCursor(int var1);

    public abstract void invokeLater(Runnable var1);

    public abstract boolean isPopupOpen(BWidget var1);

    public abstract void openPopup(BWidget var1, BWidget var2, double var3, double var5);

    public abstract void openPopup(BWidget var1, BWidget var2, double var3, double var5, double var7, double var9);

    public abstract void closePopup(BWidget var1);

    public abstract void setPopupOpacity(BWidget var1, float var2);

    public abstract void openBubbleHelp(BWidget var1, double var2, double var4, String var6);

    public abstract void updateBubbleHelp(BWidget var1, double var2, double var4, String var6);

    public abstract void closeBubbleHelp();

    public abstract BFileChooser makeOpenFileChooser(BWidget var1);

    public abstract BFileChooser makeSaveFileChooser(BWidget var1);

    public abstract BDirectoryChooser makeDirectoryChooser(BWidget var1);

    public abstract ClipboardManager makeDefaultClipboardManager();

    static {
        appLock = new Object();
        app = null;
    }

    public static interface ClipboardManager {
        public TransferEnvelope getContents();

        public void setContents(TransferEnvelope var1);
    }
}

