/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui;

import com.tridium.ui.Binder;
import java.io.ByteArrayInputStream;
import java.io.StringBufferInputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.agent.BAbstractPxView;
import javax.baja.agent.BDynamicPxView;
import javax.baja.agent.BPxView;
import javax.baja.file.BDataFile;
import javax.baja.file.BIFile;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.SortUtil;
import javax.baja.security.PermissionException;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.PxDecoder;
import javax.baja.user.BUser;

public class PxCache {
    static final BUser dummyUser = new BUser();
    static HashMap cache = new HashMap();
    static Log log = Log.getLog((String)"px.cache");

    public static synchronized Item get(OrdTarget op, BAbstractPxView pxView) throws Exception {
        return PxCache.get(op, pxView != null ? pxView.getName() : "", pxView);
    }

    public static synchronized Item get(OrdTarget op, String viewName, BAbstractPxView pxView) throws Exception {
        Key key;
        Item item;
        BObject target = op.get();
        BOrd pxFileOrd = BOrd.NULL;
        String uid = "";
        if (target instanceof BDataFile) {
            pxFileOrd = op.getOrd();
        } else {
            if (pxView == null) {
                throw new IllegalArgumentException("pxView cannot be null when using " + target.getType());
            }
            if (pxView instanceof BPxView) {
                pxFileOrd = ((BPxView)pxView).getPxFile();
            } else if (pxView instanceof BDynamicPxView) {
                uid = ((BDynamicPxView)pxView).getUniqueId(op);
            } else {
                throw new IllegalArgumentException("Don't know how to handle " + pxView.getType());
            }
        }
        if (log.isTraceOn()) {
            log.trace(op.getOrd() + " [" + target.getType() + "] px=" + pxFileOrd + " type=" + pxView.getType());
        }
        if ((item = (Item)cache.get(key = new Key(target, pxFileOrd, uid, (Context)op))) != null) {
            if (item.hasFileBeenModified()) {
                if (log.isTraceOn()) {
                    log.trace("  cache out of date");
                }
                cache.remove(key);
            } else {
                if (log.isTraceOn()) {
                    log.trace("  cached");
                }
                PxCache.bindAll(target, item.widget, (Context)op);
                item.lastUsedTicks = Clock.ticks();
                return item;
            }
        }
        int max = PxCache.getMaxCacheSize();
        while (cache.size() > max - 1) {
            PxCache.removeLeastRecentlyUsed();
        }
        BasicContext cx = new BasicContext(op.getUser(), op.getLanguage());
        BIFile file = null;
        if (log.isTraceOn()) {
            log.trace("  load");
        }
        BWidget widget = null;
        if (!pxFileOrd.isNull()) {
            file = (BIFile)pxFileOrd.get(target);
            widget = new PxDecoder(file, (Context)cx).decodeDocument();
        } else {
            BComponent comp = op.getComponent();
            if (pxView != null && viewName != null && pxView instanceof BDynamicPxView && Sys.getStation() == null && comp != null && comp.isMounted()) {
                try {
                    String reflectKey = "reflectProperty:" + viewName + ":generateXml";
                    BString xml = (BString)comp.getComponentSpace().fw(109, (Object)comp, (Object)reflectKey, null, (Object)op);
                    ByteArrayInputStream in = new ByteArrayInputStream(xml.toString().getBytes());
                    widget = new PxDecoder(comp.getNavOrd(), in, (Context)op).decodeDocument();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            if (widget == null) {
                String xml = ((BDynamicPxView)pxView).generateXml((Object)target, (Context)op);
                widget = new PxDecoder(op.getOrd(), new StringBufferInputStream(xml), (Context)cx).decodeDocument();
            }
        }
        BComponentSpace space = PxCache.load(target, widget, (Context)op);
        item = new Item(key, file, space);
        item.lastUsedTicks = Clock.ticks();
        cache.put(key, item);
        return item;
    }

    static int getMaxCacheSize() {
        try {
            return Integer.parseInt(System.getProperty("niagara.ui.pxCache.max", "10"));
        }
        catch (Exception e) {
            return 10;
        }
    }

    static void removeLeastRecentlyUsed() {
        Iterator it = cache.values().iterator();
        Item lru = null;
        while (it.hasNext()) {
            Item item = (Item)it.next();
            if (lru != null && item.lastUsedTicks >= lru.lastUsedTicks) continue;
            lru = item;
        }
        if (lru != null) {
            if (log.isTraceOn()) {
                log.trace("  remove LRU " + lru.key);
            }
            cache.remove(lru.key);
        }
    }

    static BComponentSpace load(BObject target, BWidget widget, Context cx) throws Exception {
        PxCache.bindAll(target, widget, cx);
        BComponentSpace space = new BComponentSpace("foo", null, BOrd.make((String)"foo:"));
        space.setRootComponent((BComponent)widget);
        return space;
    }

    static void bindAll(BObject target, BComponent comp, Context cx) {
        SlotCursor cursor = comp.getProperties();
        while (cursor.nextComponent()) {
            BComponent kid = (BComponent)cursor.get();
            if (kid instanceof BBinding) {
                PxCache.bind(target, (BBinding)kid, cx);
                continue;
            }
            PxCache.bindAll(target, kid, cx);
        }
    }

    static void bind(BObject base, BBinding binding, Context cx) {
        block5: {
            BOrd ord = binding.getOrd();
            try {
                OrdTarget target = ord.resolve(base, cx);
                if (!target.canRead()) {
                    throw new PermissionException();
                }
                Binder.updateBinding(binding, target);
            }
            catch (PermissionException e) {
                if (ord != null && !ord.isNull()) {
                    Binder.log.warning("no read permission: " + ord);
                }
            }
            catch (Exception e) {
                if (ord == null || ord.isNull()) break block5;
                Binder.log.warning("unresolved: " + ord);
            }
        }
    }

    static {
        Spy.ROOT.add("pxCache", (Spy)new PxCacheSpy());
    }

    static class Key {
        BObject target;
        BOrd pxFileOrd;
        String uid;
        BUser user;
        String lang;
        int hashCode;

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key key = (Key)obj;
            boolean bl = false;
            if (this.target.equals((Object)key.target) && this.pxFileOrd.equals((Object)key.pxFileOrd) && this.uid.equals(key.uid) && this.lang.equals(key.lang) && this.user == key.user) {
                bl = true;
            }
            return bl;
        }

        public String toString() {
            return this.targetToString() + ' ' + this.pxFileOrd + ' ' + this.uid;
        }

        public String targetToString() {
            if (this.target.isComponent()) {
                return this.target.asComponent().toPathString();
            }
            return this.target.toDebugString();
        }

        Key(BObject target, BOrd pxFileOrd, String uid, Context cx) {
            this.target = target;
            this.pxFileOrd = pxFileOrd;
            this.uid = uid;
            if (cx != null) {
                this.user = cx.getUser();
                this.lang = cx.getLanguage();
            }
            if (this.lang == null) {
                this.lang = Sys.getLanguage();
            }
            if (this.user == null) {
                this.user = dummyUser;
            }
            this.hashCode = target.hashCode() ^ pxFileOrd.hashCode() ^ uid.hashCode() ^ this.lang.hashCode() ^ this.user.hashCode();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Item {
        long lastUsedTicks;
        final Key key;
        final BIFile file;
        final BAbsTime fileTime;
        public final BComponentSpace space;
        public final BWidget widget;
        public final HashMap cache;

        boolean hasFileBeenModified() {
            if (this.file == null) {
                return false;
            }
            BIFile x = (BIFile)this.file.getNavOrd().get();
            return x.getLastModified().equals((Object)this.fileTime) ^ true;
        }

        private final /* synthetic */ void this() {
            this.cache = new HashMap();
        }

        Item(Key key, BIFile file, BComponentSpace space) {
            this.this();
            this.key = key;
            this.file = file;
            this.fileTime = file == null ? BAbsTime.NULL : file.getLastModified();
            this.space = space;
            this.widget = (BWidget)space.getRootComponent();
        }
    }

    static class PxCacheSpy
    extends Spy {
        public void write(SpyWriter out) throws Exception {
            Object[] items = cache.values().toArray(new Item[cache.size()]);
            long now = Clock.ticks();
            Object[] ages = new Long[items.length];
            int i = 0;
            while (i < ages.length) {
                ages[i] = new Long(now - ((Item)items[i]).lastUsedTicks);
                ++i;
            }
            SortUtil.sort((Object[])ages, (Object[])items);
            out.startTable(true);
            out.trTitle((Object)("PxCache [max=" + PxCache.getMaxCacheSize() + ']'), 4);
            out.w((Object)"<tr>").th((Object)"Target").th((Object)"PxFile").th((Object)"UID").th((Object)"Age").w((Object)"</tr>\n");
            i = 0;
            while (i < items.length) {
                Object item = items[i];
                String age = BRelTime.toString((long)(now - ((Item)item).lastUsedTicks));
                out.tr((Object)((Item)item).key.targetToString(), (Object)((Item)item).key.pxFileOrd, (Object)((Item)item).key.uid, (Object)age);
                ++i;
            }
            out.endTable();
        }

        PxCacheSpy() {
        }
    }
}

